<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Repeater;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow; 


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0 
	 */
	class PowerElements_Tabs extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_tabs';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Tabs', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-tabs';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_tabs_content_tab',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_tabs_style',
				[
					'label'   => __( 'Type', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'vertical_style',
					'options' => [
						'horizontal_style' => __( 'Horizontal', 'power-elements' ),
						'vertical_style'   => __( 'Vertical', 'power-elements' )
					]
				]
			);
			
			$repeater = new Repeater();
			$repeater->add_control(
				'tab_title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Objective', 'power-elements' ),
					'placeholder' => __( 'Give your first tab title', 'power-elements' ),
				]
			);
			$repeater->add_control(
				'tab_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
						'library' => 'peeaoicons',
					],
				]
			);
			$repeater->add_control(
				'tab_source',
				[
					'label'   => __( 'Source', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'custom',
					'options' => [
						'custom' => __( 'Custom', 'power-elements' ),
						'nested_template'   => __( 'Nested Templates', 'power-elements' )
					]
				]
			);
			$repeater->add_control(
				'nested_template_id',
				[
					'label'   => __( 'Nested Templates', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => Partials::get_all_nested_templates(),
					'condition' => [
						'tab_source' => 'nested_template',
					]
				]
			);
			$repeater->add_control(
				'tab_content',
				[
					'label'       => __( 'Content', 'power-elements' ),
					'type'        => Controls_Manager::WYSIWYG,
					'default'     => __( 'You need no programming knowledge to edit this tab. You will be able to edit change
					element there as you wish. So change according to the vibe of your website njoy your
					with us in the journey', 'power-elements' ),
					'placeholder' => __( 'Give your tab content', 'power-elements' ),
					'condition' => [
						'tab_source' => 'custom',
					]
				]
			);
			$this->add_control(
				'peeao_tabs_list',
				[
					'label'       => __( 'Tabs', 'power-elements' ),
					'type'        => Controls_Manager::REPEATER,
					'fields'      => $repeater->get_controls(),
					'default'     => [
						[
							'tab_title'   => __( 'Objective', 'power-elements' ),
							'tab_content' => __( 'You need no programming knowledge to edit this tab. You will be able to edit change
							element there as you wish. So change according to the vibe of your website njoy your
							with us in the journey', 'power-elements' ),
						],
						[
							'tab_title'   => __( 'Vision', 'power-elements' ),
							'tab_content' => __( 'You need no programming knowledge to edit this tab. You will be able to edit change
							element there as you wish. So change according to the vibe of your website njoy your
							with us in the journey', 'power-elements' ),
						],
						[
							'tab_title'   => __( 'Mission', 'power-elements' ),
							'tab_content' => __( 'You need no programming knowledge to edit this tab. You will be able to edit change
							element there as you wish. So change according to the vibe of your website njoy your
							with us in the journey', 'power-elements' ),
						],
					],
					'title_field' => '{{{ tab_title }}}'
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE TAB
			 */
			$this->start_controls_section(
				'peeao_tabs_style_tab',
				[
					'label' => __( 'Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->end_controls_section();
			/*
			 * STYLE TITLE WRAPPER
			 */
			$this->start_controls_section(
				'peeao_tabs_title_wrapper_style',
				[
					'label' => __( 'Title Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_title_wrapper_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_title_wrapper_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_title_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_wrapper_width',
				[
					'label'      => __( 'Width', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => '%',
						'size' => 25,
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			
			/*
			 * STYLE CONTENT WRAPPER
			 */
			$this->start_controls_section(
				'peeao_tabs_content_wrapper_style',
				[
					'label' => __( 'Content Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_content_wrapper_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_content_wrapper_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_content_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_wrapper_width',
				[
					'label'      => __( 'Width', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => '%',
						'size' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_wrapper_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			
			/*
			 * STYLE TITLE
			 */
			$this->start_controls_section(
				'peeao_tabs_title_style_tab',
				[
					'label' => __( 'Title', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_style_tab_title_align',
				[
					'label'     => esc_html__( 'Alignment', 'power-elements' ),
					'type'      => Controls_Manager::CHOOSE,
					'options' => [
						'left'    => [
							'title' =>esc_html__( 'Left', 'power-elements' ),
							'icon' => 'fa fa-align-left',
						],
						'center' => [
							'title' =>esc_html__( 'Center', 'power-elements' ),
							'icon' => 'fa fa-align-center',
						],
						'right' => [
							'title' =>esc_html__( 'Right', 'power-elements' ),
							'icon' => 'fa fa-align-right',
						],
					],
					'default' => 'center',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group a' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_tabs_style_tab_title_tabs'
			);
			/*
			 * TITLE ACTIVE
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_title_active_tab',
				[
					'label' => __( 'Active', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_tabs_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected',
				]
			);
			$this->add_control(
				'peeao_tabs_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_title_bg_color',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_itle_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_title_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a.selected' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * TITLE NORMAL
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_title_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_tabs_title_typography_normal',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)',
				]
			);
			$this->add_control(
				'peeao_tabs_title_color_normal',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_title_bg_color_normal',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_title_shadow_normal',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_title_border_normal',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_radius_normal',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_margin_normal',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_padding_normal',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:not(.selected)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * TITLE HOVER
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_title_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_tabs_title_typography_hover',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover',
				]
			);
			$this->add_control(
				'peeao_tabs_title_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_title_bg_color_hover',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_title_shadow_hover',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_title_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_margin_hover',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_title_padding_hover',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button_group li a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * ICON STYLE
			 */
			$this->start_controls_section(
				'peeao_tabs_icon_style_tab',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_tabs_style_tab_icon_tabs'
			);
			/*
			 * ICON ACTIVE
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_icon_active_tab',
				[
					'label' => __( 'Active', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_tabs_icon_color_active',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a.selected .power_tab_button_icon i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_icon_font_size_active',
				[
					'label' => __( 'Font Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						],
						'em' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 18,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a.selected .power_tab_button_icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * ICON NORMAL
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_icon_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_tabs_icon_color_normal',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a:not(.selected) .power_tab_button_icon i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_icon_font_size_normal',
				[
					'label' => __( 'Font Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						],
						'em' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 18,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a:not(.selected) .power_tab_button_icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * ICON HOVER
			 */
			$this->start_controls_tab(
				'peeao_tabs_style_tab_icon_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_tabs_icon_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a:hover .power_tab_button_icon i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_icon_font_size_hover',
				[
					'label' => __( 'Font Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						],
						'em' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 18,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a:hover .power_tab_button_icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_control(
				'peeao_tabs_hr',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->add_control(
				'peeao_tabs_icon_position',
				[
					'label'   => __( 'Position', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'eicon-h-align-left',
						],
						'top' => [
							'title' => __( 'Top', 'power-elements' ),
							'icon'  => 'eicon-v-align-top',
						],
						'right' => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'eicon-h-align-right',
						],
						'bottom' => [
							'title' => __( 'Bottom', 'power-elements' ),
							'icon'  => 'eicon-v-align-bottom',
						],
					],
					'default' => is_rtl() ? 'right' : 'left',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_icon_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a .power_tab_button_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_icon_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_button a .power_tab_button_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * CONTENT STYLE
			 */
			$this->start_controls_section(
				'peeao_tabs_tab_content_style',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_tabs_content_typo',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info',
				]
			);
			$this->add_control(
				'peeao_tabs_content_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_tabs_content_bg_color',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_tabs_content_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_tabs_content_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info',
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_tabs_content_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_tab_nav .power_tab_container .power_tab_info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			$html     = '<div class="peeao-wrapper">';
			$icon_class = $start_icon_html = $end_icon_html = $content = '';
			if ( $settings['peeao_tabs_icon_position'] == 'left' ) {
				$icon_class .= 'power_tab_button_icon_left';
			}elseif($settings['peeao_tabs_icon_position'] == 'top') {
				$icon_class .= 'power_tab_button_icon_top';
			}elseif($settings['peeao_tabs_icon_position'] == 'right') {
				$icon_class .= 'power_tab_button_icon_right';
			}elseif($settings['peeao_tabs_icon_position'] == 'bottom') {
				$icon_class .= 'power_tab_button_icon_bottom';
			}

			if ( $settings['peeao_tabs_list'] ) {
				$html         .= ' <div class="power_tab_nav power_tab ' . esc_attr( $settings['peeao_tabs_style'] ) . '">';
				$title_html   = '<ul class="power_tab_button_group">';
				$content_html = '<div  class="power_tab_container">';
				foreach ( $settings['peeao_tabs_list'] as $key => $item ) {
					if ( $settings['peeao_tabs_icon_position'] == 'left' || $settings['peeao_tabs_icon_position'] == 'top') {
						$start_icon_html .= '<span class="power_tab_button_icon"><i class="' . esc_attr( $item['tab_icon']['value'] ) . '"></i></span>';
					}elseif($settings['peeao_tabs_icon_position'] == 'right' || $settings['peeao_tabs_icon_position'] == 'bottom') {
						$end_icon_html .= '<span class="power_tab_button_icon"><i class="' . esc_attr( $item['tab_icon']['value'] ) . '"></i></span>';
					}

					if ( $key == 0 ) {
						$active = 'selected';
					} else {
						$active = 'not_selected'; 
					}

					$title_html   .= '<li class="power_tab_button">
						<a class="' . esc_attr( $active ) . ' '.$icon_class.'" href="#">
							'.$start_icon_html.esc_html( $item['tab_title'] ).$end_icon_html.'
                        </a>
					</li>';
					
					$content_html .= '<div class="power_tab_info ' . esc_attr( $active ) . '">';
					if($item['tab_source'] == 'custom'){
						$content_html .= $item['tab_content'];
					}elseif($item['tab_source'] == 'nested_template'){
						$content_html .= Utils::get_builder_content($item['nested_template_id']) ; 
					}
					$content_html .= '</div>';
				}
				$title_html   .= '</ul>';
				$content_html .= '</div>';

				$html         .= $title_html . $content_html . '</div></div>';
			}
			
			echo $html;
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}