<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Xs_Post_Widget extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'recent-posts';
    }

    public function get_title()
    {
        return esc_html__('Recent Posts', 'power-elements');
    }

    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return ['power-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'power-elements'),
            ]
        );


        $this->add_control(
            'peeao_recent_posts_count',
            [
                'label'         => esc_html__('Post count', 'power-elements'),
                'type'          => Controls_Manager::NUMBER,
                'default'       => esc_html__('3', 'power-elements'),

            ]
        );

        $this->add_control(
            'peeao_recent_posts_count_col',
            [
                'label'     => esc_html__('Select Column', 'power-elements'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 4,
                'options'   => [
                    '6'     => esc_html__('2 Column', 'power-elements'),
                    '4'     => esc_html__('3 Column', 'power-elements'),
                ],
            ]
        );


        $this->add_control(
            'peeao_recent_posts_select',
            [
                'label' => esc_html__('Select Posts', 'power-elements'),
                'type'      => Controls_Manager::SELECT2,
                'options'   => 'post_list',
                'label_block' => true,
                'multiple'  => true,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $posts_select = $settings['peeao_recent_posts_select'];
        $count_col = $settings['peeao_recent_posts_count_col'];
        $post_count = $settings['peeao_recent_posts_count'];

        $paged = 1;
        if (get_query_var('paged')) $paged = get_query_var('paged');
        if (get_query_var('page')) $paged = get_query_var('page');
        $query = array(
            'post_type'      => 'post',
            'post_status'    => 'publish',
            'posts_per_page' => $post_count,
            'post__in' => $posts_select,
            'paged' => $paged,
        );
        $the_query = new \WP_Query($query);
        if ($the_query->have_posts()) :

            echo '<div class="blog-post-list">'; ?>
            <?php
            while ($the_query->have_posts()) :
                $the_query->the_post();
                $terms  = get_the_terms(get_the_ID(), 'category');
                if ($terms && !is_wp_error($terms)) :
                    $cat_temp = '';
                    foreach ($terms as $term) {
                        $cat_temp .= '<a href="' . get_category_link($term->term_id) . '" class="recent-posts-meta-tag green-bg bold color-white" rel="category tag">' . esc_html($term->name) . '</a>';
                    }
                endif; ?>

                <div class="single-blog blog-style2">
                    <div class="entry-header">
                        <div class="entry-meta">

                            <?php $category_list = get_the_category_list(', ');
                            if ($category_list) {
                                echo '<a href="#" class="post-cat gradient-title"><i class="icon icon-folder"></i> ' . $category_list . '</a>';
                            } ?>
                        </div>
                        <h4 class="entry-title">
                            <a href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a>
                        </h4>
                    </div>
                </div>
            <?php endwhile; ?>
            </div>
<?php
        endif;
        wp_reset_postdata();
    }
    protected function _content_template()
    {
    }
}
