<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Progressbar extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_progress';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Progressbar', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-skill-bar';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_progress_content',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_progress_style',
				[
					'label'   => __( 'Style', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'power_progress_type1',
					'options' => [
						'power_progress_type1' => __( 'Style 1', 'power-elements' ),
						'power_progress_type2' => __( 'Style 2', 'power-elements' ),
						'power_progress_type3' => __( 'Style 3', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_progress_title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Marketing', 'power-elements' ),
					'placeholder' => __( 'Title', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_progress_title_hide',
				[
					'label' => esc_html__('Show title? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_progress_value',
				[
					'label'       => __( 'Value', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( '65%', 'power-elements' ),
					'placeholder' => __( 'Value%.', 'power-elements' ),
					'description' => __( 'Value is numerical, must include % sign.', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_progress_value_hide',
				[
					'label' => esc_html__('Show value? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_progress_striped',
				[
					'label'   => __( 'Striped', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'No-striped',
					'options' => [
						'striped'    => __( 'Striped', 'power-elements' ),
						'no_striped' => __( 'No-striped', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_progress_striped_anime',
				[
					'label'     => __( 'Striped Animation', 'power-elements' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'right_anim',
					'options'   => [
						'right_anim' => __( 'Right Anime', 'power-elements' ),
						'left_anim'  => __( 'Left Anime', 'power-elements' ),
					],
					'condition' => [
						'peeao_progress_striped' => 'striped',
					]
				]
			);
			$this->add_control(
				'peeao_progress_animation',
				[
					'label'   => __( 'Animation', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'bounce'     => __( 'Bounce', 'power-elements' ),
						'flash'      => __( 'Flash', 'power-elements' ),
						'pulse'      => __( 'Pulse', 'power-elements' ),
						'shake'      => __( 'Shake', 'power-elements' ),
						'swing'      => __( 'Swing', 'power-elements' ),
						'tada'       => __( 'Tada', 'power-elements' ),
						'wobble'     => __( 'Wobble', 'power-elements' ),
						'jello'      => __( 'Jello', 'power-elements' ),
						'zoomIn'     => __( 'Zoom In', 'power-elements' ),
						'fadeIn'     => __( 'Fade In', 'power-elements' ),
						'heartBeat'  => __( 'Heart Beat', 'power-elements' ),
						'rubberBand' => __( 'Rubber Band', 'power-elements' ),
					]
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR
			 */
			$this->start_controls_section(
				'peeao_progress_wrapper_style',
				[
					'label' => __( 'Progressbar', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_progress_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#e0e0e0',
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_progress_height',
				[
					'label' => __( 'Height', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 80,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content' => 'height: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_progress_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content',
				]
			);
			$this->add_responsive_control(
				'peeao_progress_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR INNER
			 */
			$this->start_controls_section(
				'peeao_progress_inner_style',
				[
					'label' => __( 'Inner', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_progress_inner_height',
				[
					'label' => __( 'Height', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'default' => [
						'unit' => 'px',
						'size' => 10,
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 60,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar' => 'height: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_control(
				'peeao_progress_inner_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#333',
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_progress_inner_border',
					'label'    => __( 'Border', 'power-elements' ),
					'fields_options' => [
						'border' => [
							'default' => 'none',
						],
					],
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar',
				]
			);
			$this->add_responsive_control(
				'peeao_progress_inner_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_inner_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_inner_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR TEXT
			 */
			$this->start_controls_section(
				'peeao_progress_text_style',
				[
					'label' => __( 'Text', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_progress_text_color',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => '600',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 16 ] ]
						],
						'text_transform' => [
							'default' => 'unset'
						]
					],
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_progress_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text',
				]
			);
			$this->add_control(
				'peeao_progress_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#333',
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_text_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '0',
						'right' => '0',
						'bottom' => '0',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '0',
						'right' => '5',
						'bottom' => '0',
						'left' => '5',
						'unit' => 'px',
						'isLinked' => false,
					],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_progress_text_top',
				[
					'label' => __( 'Top', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => -100,
							'max' => 100,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => -25,
					],
					'condition' => [
						'peeao_progress_style' => [
							'power_progress_type1',
							'power_progress_type3',
						]
					],
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_text' => 'top: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR VALUE
			 */
			$this->start_controls_section(
				'peeao_progress_value_style',
				[
					'label' => __( 'Value', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_progress_value_color',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => '400',
						],
						'font_family' => [
							'default' => 'inherit',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 14 ] ]
						],
						'text_transform' => [
							'default' => 'unset'
						]
					],
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_progress_value_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value',
				]
			);
			$this->add_control(
				'peeao_progress_value_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ffffff',
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_progress_value_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => 'transperent',
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_value_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '0',
						'right' => '0',
						'bottom' => '0',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => false,
					],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_progress_value_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '0',
						'right' => '5',
						'bottom' => '0',
						'left' => '5',
						'unit' => 'px',
						'isLinked' => false,
					],
					'selectors'  => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_progress_value_top',
				[
					'label' => __( 'Top', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => -100,
							'max' => 100,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => -25,
					],
					'selectors' => [
						'{{WRAPPER}}  .peeao-wrapper .power_progress_content .power_progress_value' => 'top: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			
			$animation = $settings['peeao_progress_animation']!=''? ' '.$settings['peeao_progress_animation'].' animated' : '';
			$value = $settings['peeao_progress_value']!=''? $settings['peeao_progress_value'] : '0';
			$title_html = $settings['peeao_progress_title_hide'] == 'yes' ? '<span class="power_progress_text">'.esc_html($settings['peeao_progress_title']).'</span>' : '';
			$value_html = $settings['peeao_progress_value_hide'] == 'yes' ? '<span class="power_progress_value">'.esc_html($value).'</span>' : '';
			 
			echo '<div class="peeao-wrapper"><div class="power_progress_content '.esc_attr($settings['peeao_progress_style']).' '.esc_attr($animation).'">
				'.$value_html.'
                <div class="power_progress_bar '.esc_attr($settings['peeao_progress_striped']).' '.esc_attr($settings['peeao_progress_striped_anime']).'" style="max-width: '.esc_attr($value).';"></div>
                '.$title_html.'
            </div></div>';
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}