<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;




	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Nav_Menu extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_nav_menu';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0 
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return esc_html__( 'Nav Menu', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-nav-menu';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		

		public function get_menus(){
			$list = [];
			$menus = wp_get_nav_menus();
			foreach($menus as $menu){
				$list[$menu->slug] = $menu->name;
			}
	
			return $list;
		}
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		protected function _register_controls() {

			$this->start_controls_section(
				'power_elements_content_tab',
				[
					'label' => esc_html__('Menu settings', 'power-elements'),
					'tab' => Controls_Manager::TAB_CONTENT,
				]
			);
			
			$this->add_control(
				'power_elements_nav_menu',
				[
					'label'     =>esc_html__( 'Select menu', 'power-elements' ),
					'type'      => Controls_Manager::SELECT,
					'options'   => $this->get_menus(), 
				]
			);
			$this->add_control(
				'power_elements_nav_menu_sticky',
				[
					'label' => esc_html__('Enable sticky menu? ', 'power-elements'),
					'description'	=> esc_html__('This works in the current page.', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'no',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'power_elements_nav_menu_alignment',
				[
					'label' => esc_html__( 'Menu Alignment', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'left' => __( 'Left', 'power-elements' ),
						'right' => __( 'Right', 'power-elements' ),
						'center' => __( 'Center', 'power-elements' ),
					],
					'default' => 'left',
				]
			);
			$this->add_control(
				'peeao_nav_menu_humburger_alignment',
				[
					'label' => esc_html__( 'Humburger Alignment', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'left' => __( 'Left', 'power-elements' ),
						'right' => __( 'Right', 'power-elements' ),
						'center' => __( 'Center', 'power-elements' ),
					],
					'default' => 'left',
				]
			);
			$this->add_control(
				'peeao_nav_menu_responsive_alignment',
				[
					'label' => esc_html__( 'Responsive Menu Alignment', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'left' => __( 'Left', 'power-elements' ),
						'right' => __( 'Right', 'power-elements' ),
					],
					'default' => 'left',
				]
			);
			$this->end_controls_section();
	
			$this->start_controls_section(
				'peeao_nav_menu_wrapper_section_tab',
				[
					'label' => __( 'Menu Item Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_menu_item_wrapper_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_menu_item_wrapper_border',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_menu_item_wrapper_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_nav_menu_item_wrapper_box_shadow',
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_menu_item_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_menu_item_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .power-menu-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
	
			// Menu Item
			$this->start_controls_section(
				'peeao_nav_menu_item_section_tab',
				[
					'label' => __( 'Menu Item', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_nav_menu_item_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a',
				]
			);

			$this->start_controls_tabs(
				'peeao_nav_menu_item_tabs'
			);
			$this->start_controls_tab(
				'peeao_nav_menu_item_tabs_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_nav_menu_item_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_menu_item_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_menu_item_border_normal',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a',
					'separator' => 'before',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_nav_menu_item_tabs_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				] 
			);
	
			$this->add_control(
				'peeao_nav_menu_item_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li:hover > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_menu_item_background_hover',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li:hover > a',
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_menu_item_border_hover',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a:hover, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner ul:not(.sub-menu ) > li.active > a',
					'separator' => 'before',
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_nav_menu_item_tabs_active',
				[
					'label' => __( 'Active', 'power-elements' ),
				] 
			);
	
			$this->add_control(
				'peeao_nav_menu_item_active_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li.active > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_menu_item_background_active',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li.active > a',
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_menu_item_border_active',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li.active > a',
					'separator' => 'before',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			

			$this->add_responsive_control(
				'peeao_nav_menu_item_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_nav_menu_item_box_shadow',
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_menu_item_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_menu_item_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul:not(.sub-menu ) > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
	
			//Submenu Wrapper
			$this->start_controls_section(
				'peeao_nav_sub_menu_wrapper_section_tab',
				[
					'label' => __( 'Submenu Item Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_sub_menu_item_wrapper_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_sub_menu_item_wrapper_border',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_wrapper_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_nav_sub_menu_item_wrapper_box_shadow',
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
	
			// Submenu Item
			$this->start_controls_section(
				'peeao_nav_sub_menu_item_section_tab',
				[
					'label' => __( 'Submenu Item', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_nav_sub_menu_item_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a',
				]
			);

			$this->start_controls_tabs(
				'peeao_nav_sub_menu_item_tabs'
			);
			$this->start_controls_tab(
				'peeao_nav_sub_menu_item_tabs_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_nav_sub_menu_item_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_sub_menu_item_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_nav_sub_menu_item_tabs_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_nav_sub_menu_item_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li:hover > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_sub_menu_item_background_hover',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li:hover > a',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_nav_sub_menu_item_tabs_active',
				[
					'label' => __( 'Active', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_nav_sub_menu_item_active_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li.active > a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_sub_menu_item_background_active',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li.active > a',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_nav_sub_menu_item_border',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_nav_sub_menu_item_box_shadow',
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_sub_menu_item_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  ul.sub-menu > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
	
			// Humbarger
			$this->start_controls_section(
				'peeao_nav_humburger_section_tab',
				[
					'label' => __( 'Humburger', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			$this->start_controls_tabs(
				'peeao_nav_humburge_tabs'
			);
			$this->start_controls_tab(
				'peeao_nav_humburger_tabs_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_nav_humburger_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:before' => 'background: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:after' => 'border-top-color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:after' => 'border-bottom-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_humburger_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_nav_humburger_tabs_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_nav_humburger_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:hover:before' => 'background: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:hover:after' => 'border-top-color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle:hover:after' => 'border-bottom-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_nav_humburger_background_hover',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_humburger_border',
					'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_humburger_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_nav_humburger_box_shadow',
					'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle',
				]
			);
			$this->add_responsive_control(
				'peeao_nav_humburger_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper #powermenu #mobile-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);

			$this->end_controls_section();


		//Mobile Menu Wrapper
		$this->start_controls_section(
			'peeao_nav_mobile_menu_wrapper_section_tab',
			[
				'label' => __( 'Mobile Menu Item Wrapper', 'power-elements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'peeao_nav_mobile_menu_item_wrapper_background',
				'label' => esc_html__( 'Background', 'power-elements' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner > ul.power-main-menu, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'peeao_nav_mobile_menu_item_wrapper_border',
				'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_wrapper_border_radius',
			[
				'label'      => __( 'Border Radius', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_nav_mobile_menu_item_wrapper_box_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_wrapper_padding',
			[
				'label'      => __( 'Padding', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_wrapper_margin',
			[
				'label'      => __( 'Margin', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul, {{WRAPPER}} .peeao-wrapper #powermenu .nav-inner .mobile-btn.menu-opened + ul ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->end_controls_section();

		// Mobile Menu Item
		$this->start_controls_section(
			'peeao_nav_mobile_menu_item_section_tab',
			[
				'label' => __( 'Mobile Menu Item', 'power-elements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_nav_mobile_menu_item_typography',
				'label'    => __( 'Typography', 'power-elements' ),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a',
			]
		);

		$this->start_controls_tabs(
			'peeao_nav_mobile_menu_item_tabs'
		);
		$this->start_controls_tab(
			'peeao_nav_mobile_menu_item_tabs_normal',
			[
				'label' => __( 'Normal', 'power-elements' ),
			]
		);
		$this->add_control(
			'peeao_nav_mobile_menu_item_color',
			[
				'label'     => __( 'Color', 'power-elements' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper #powermenu .submenu-button:before,{{WRAPPER}} .peeao-wrapper #powermenu .submenu-button:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'peeao_nav_mobile_menu_item_background',
				'label' => esc_html__( 'Background', 'power-elements' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'peeao_nav_mobile_menu_item_tabs_hover',
			[
				'label' => __( 'Hover', 'power-elements' ),
			]
		);

		$this->add_control(
			'peeao_nav_mobile_menu_item_hover_color',
			[
				'label'     => __( 'Color', 'power-elements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper #powermenu li:hover .submenu-button:before,{{WRAPPER}} .peeao-wrapper #powermenu li:hover .submenu-button:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'peeao_nav_mobile_menu_item_background_hover',
				'label' => esc_html__( 'Background', 'power-elements' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li:hover a',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'peeao_nav_mobile_menu_item_tabs_active',
			[
				'label' => __( 'Active', 'power-elements' ),
			]
		);

		$this->add_control(
			'peeao_nav_mobile_menu_item_active_color',
			[
				'label'     => __( 'Color', 'power-elements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li.active a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper #powermenu li.active .submenu-button:before,{{WRAPPER}} .peeao-wrapper #powermenu li.active .submenu-button:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'peeao_nav_mobile_menu_item_background_active',
				'label' => esc_html__( 'Background', 'power-elements' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li.active a',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'peeao_nav_mobile_menu_item_border',
				'selector'  => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_border_radius',
			[
				'label'      => __( 'Border Radius', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_nav_mobile_menu_item_box_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_padding',
			[
				'label'      => __( 'Padding', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'peeao_nav_mobile_menu_item_margin',
			[
				'label'      => __( 'Margin', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #powermenu .nav-inner  .mobile-btn.menu-opened + ul:not(.sub-menu ) li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->end_controls_section();
	
		}
	 
		protected function render( ) {
	
			$settings = $this->get_settings();
			extract($settings);
			if($power_elements_nav_menu != '' && wp_get_nav_menu_items($power_elements_nav_menu) !== false){
				$menu_class = ($power_elements_nav_menu_sticky == 'yes') ? 'power-main-menu power-main-menu-sticky' : 'power-main-menu';
				?>
				<div class="peeao-wrapper">
					<nav id="powermenu">
						<div class="nav-inner">
							<div id="mobile-toggle" class="mobile-btn power_humburger_alignment_<?php echo esc_attr($peeao_nav_menu_humburger_alignment); ?>"></div>
							<?php 
							$args = [ 
								'items_wrap'      => '<ul id="%1$s" class="power_responsive_alignment_'.$peeao_nav_menu_responsive_alignment.' power_nav_menu_alignment_'.$power_elements_nav_menu_alignment.' %2$s">%3$s</ul>',
								'container'       => 'ul',
								'container_class' => '' ,
								'menu_id'         => 'main-menu',
								'menu'         	  => $power_elements_nav_menu,
								'menu_class'      => $menu_class,
								'depth'           => 4,
								'echo'            => true,
								'fallback_cb'     => 'wp_page_menu',
								'walker'          => new \PowerElements\Admin\Nav_Menu_Walker
							];
				
							wp_nav_menu($args); ?>
						</div>
					</nav>
				</div>

							
				<?php



			}
		}
		protected function _content_template() { }
	}