<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class PowerElements_Instafeed extends Widget_Base {

	public function get_name() { 
		return 'power_elements_instafeed';
	}
	public function get_title() {
		return __( 'Instagram Feed', 'power-elements' );
	}
	public function get_icon() {
		return 'eicon-instagram-nested-gallery';
    }
    public function get_categories() {
		return [ 'power-elements' ];
	}
    protected function _register_controls() {

  		$this->start_controls_section(
  			'peeao_section_instafeed_form',
  			[
  				'label' => __( 'Instagram Feed', 'power-elements' )
  			]
  		);

		$this->add_control(
			'peeao_instafeed_user_name',
			[
				'label' => __( 'Instagram User Name', 'power-elements' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'peeao_instafeed_number_of_columns',
			[
				'label' =>esc_html__( 'Number of columns', 'power-elements' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'1' =>esc_html__( '1', 'power-elements' ),
					'2' =>esc_html__( '2', 'power-elements' ),
					'3' =>esc_html__( '3', 'power-elements' ),
					'4' =>esc_html__( '4', 'power-elements' ),
					'5' =>esc_html__( '5', 'power-elements' ),
					'6' =>esc_html__( '6', 'power-elements' ),
					'7' =>esc_html__( '7', 'power-elements' ),
					'8' =>esc_html__( '8', 'power-elements' ),
					'9' =>esc_html__( '9', 'power-elements' ),
					'10' =>esc_html__( '10', 'power-elements' ),
					'11' =>esc_html__( '11', 'power-elements' ),
					'12' =>esc_html__( '12', 'power-elements' ),
				],
			]
		);
		
		$this->add_control(
			'peeao_instafeed_limit',
			[
				'label'       => __( 'Limit', 'power-elements' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( '12', 'power-elements' ),
				'placeholder' => __( 'Type your number here', 'power-elements' ),
			]
		);

		$this->end_controls_section(); 

		$this->start_controls_section(
			'peeao_instafeed_item_style',
			[
				'label' => __( 'Style', 'power-elements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'peeao_instafeed_item_padding',
			[
				'label'      => __( 'Gutter', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power-instafeed-gallery .power-instafeed-grid li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
	}
	
    protected function render() {

		$settings = $this->get_settings(); 
		extract($settings); 
		$username = $peeao_instafeed_user_name;
		$limit = $peeao_instafeed_limit;
		$padding = $peeao_instafeed_item_padding;
		$columns = $peeao_instafeed_number_of_columns;

		if($peeao_instafeed_user_name == '') return;
		$ch = curl_init();
		$options = [
			CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_URL            => 'https://www.instagram.com/'.$username.'/?__a=1'
		];

		curl_setopt_array($ch, $options);
		$data = json_decode(curl_exec($ch));
		curl_close($ch);


		$instagram_photos = $data->graphql->user->edge_owner_to_timeline_media->edges;

		?>

		<div class="peeao-wrapper">
			<div class="power-instafeed-gallery">
				<ul class="power-instafeed-grid power-instafeed-grid-<?php echo esc_attr($columns); ?>">
					<?php $i = 0; foreach($instagram_photos as $instagram_photo){  
						
						if( $i == $limit) continue; ?>
						<li>
							<img src="<?php echo $instagram_photo->node->display_url; ?>">
						</li>
					<?php $i++; }  ?>
				</ul>
			</div>
        </div>
        
	<?php }  
}