<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;


use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;




	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Funfact extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 * 
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_funfact';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Fun Fact', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-nerd-chuckle';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {

			$this->start_controls_section(
				'section_funfact_settings',
				[
					'label' => __( 'Settings', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_funfact_type',
				[
					'label'   => __( 'Image Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'type1',
					'options' => [
						'type1' => __( 'Left', 'power-elements' ),
						'type2' => __( 'Top', 'power-elements' ),
						'type3' => __( 'Merge', 'power-elements' ),
						'type4' => __( 'Right', 'power-elements' )
					],
				]
			);
			$this->add_control(
				'peeao_funfact_title_position',
				[
					'label'   => __( 'Title Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'bottom',
					'options' => [
						'bottom' => __( 'After number', 'power-elements' ),
						'top' => __( 'Before number', 'power-elements' )
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_align',
				[
					'label'   => __( 'Alignment', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'left'    => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justified', 'power-elements' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'condition' => [
						'peeao_funfact_type!' => [ 'type1', 'type4'],
					],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox' => 'text-align: {{VALUE}};',
					],
					'default' => '',
				]
			);
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_funfact_content',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_funfact_number',
				[
					'label'   => __( 'Number', 'power-elements' ),
					'type'    => Controls_Manager::NUMBER,
					'min'     => 1,
					'max'     => 10000,
					'step'    => 1,
					'default' => 75,
				]
			);
			$this->add_control(
				'peeao_funfact_suffix',
				[
					'label'   => __( 'Use Suffix', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( '', 'power-elements' ),
					'placeholder' => __( 'Use + sign', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_funfact_title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Default title', 'power-elements' ),
					'placeholder' => __( 'Type your title here', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_funfact_description',
				[
					'label'       => __( 'Description', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( '', 'power-elements' ),
					'placeholder' => __( 'Description here', 'power-elements' ),
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_funfact_section_icon',
				[ 
					'label' => esc_html__( 'Icon/Image', 'power-elements' ),
					'tab' => Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'peeao_funfact_switcher',
				[
					'label' => __( 'Image', 'power-elements' ),
					'type'  => Controls_Manager::SWITCHER,
				]
			);
			$this->add_control(
				'peeao_funfact_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-alarm',
						'library' => 'peeaoicons',
					],
					'condition'   => [
						'peeao_funfact_switcher' => '',
					],
				]
			);
			$this->add_control(
				'peeao_funfact_image',
				[
					'label'     => __( 'Choose Image', 'power-elements' ),
					'type'      => Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_funfact_switcher' => 'yes',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_funfact_style',
				[
					'label'     => __( 'Funfact Box', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_funfact_background',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_funbox',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_funfact_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_funbox',
				] 
			);
			$this->add_responsive_control(
				'peeao_funfact_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .power_funbox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_funfact_section_style',
				[
					'label'     => __( 'Space Between', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_funfact_type' => 'type1',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_space_between',
				[
					'label'     => __( 'Space Between', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_funbox.type1 .power_fun_content' => 'padding-left: calc({{SIZE}}{{UNIT}}/2);'
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_funfact_number_style',
				[
					'label'     => __( 'Number', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_funfact_number_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_funbox .power_fun_value',
				]
			);
			$this->add_control(
				'peeao_funfact_number_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_value' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'peeao_funfact_number_suffix_color',
				[
					'label'     => __( 'Suffix Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_value .power-suffix' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_funfact_number_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_funbox .power_fun_value',
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_number_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_value' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_number_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_value' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * TITLE STYLE
			 */
			$this->start_controls_section(
				'peeao_funfact_title_style',
				[
					'label'     => __( 'Title', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_funfact_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_funbox .power_fun_title',
				]
			);
			$this->add_control(
				'peeao_funfact_title_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_title' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_funfact_title_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_funbox .power_fun_title',
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			/*
			 * DESCRIPTION STYLE
			 */
			$this->start_controls_section(
				'peeao_funfact_description_style',
				[
					'label'     => __( 'Description', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_funfact_description_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_funbox .power_fun_desc',
				]
			);
			$this->add_control(
				'peeao_funfact_description_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_desc' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_description_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_description_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			/*
			 * ICON STYLE
			 */
			$this->start_controls_section(
				'peeao_funfact_icon_style',
				[
					'label'     => __( 'Icon/Image', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_icon_size',
				[
					'label'   => __( 'Size', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
					'default' => [
						'size' => 60,
					],
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_image i' => 'font-size: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_control(
				'peeao_funfact_icon_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#6771da',
					'selectors' => [
						'{{WRAPPER}} .power_funbox .power_fun_image i' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_icon_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_funfact_icon_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_funbox .power_fun_image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			extract($settings);

			echo '<div class="peeao-wrapper">';
				$title_html = $peeao_funfact_title != '' ? 
							'<h3 class="power_fun_title">' . esc_html( $peeao_funfact_title ) . '</h3>' : '';
				$number_html = $peeao_funfact_number != '' ? 
							'<h1 class="power_fun_value"><span class="power_fun_number">' . esc_html( $peeao_funfact_number ) . '</span><span class="power-suffix">' . esc_html( $peeao_funfact_suffix ) . '</span></h1>' : '';
				$desc_html = $peeao_funfact_description != '' ? 
							'<p class="power_fun_desc">' . Utils::kses( $peeao_funfact_description ) . '</p>' : '';
				$icon_image_html = $peeao_funfact_switcher == 'yes' ? 
							(($peeao_funfact_image['url'] != '' ) ? '<div class="power_fun_image"><img src="' . esc_url( $peeao_funfact_image['url'] ) . '" alt="' . esc_attr( $peeao_funfact_title ) . '"></div>' : '') : 
							(($peeao_funfact_icon['value'] != '' ) ? '<div class="power_fun_image"><i class="' .esc_attr( $peeao_funfact_icon['value'] ).'"></i></div>' : ''); 
				$image_position = $peeao_funfact_type == 'type4' ? 'type1' : $peeao_funfact_type;
				echo '<div class="power_funbox ' . esc_attr( $image_position ) . '">';
					echo $peeao_funfact_type != 'type4' ? Utils::kses($icon_image_html) : '';
					echo '<div class="power_fun_content">'; 
						echo $peeao_funfact_title_position == 'top' ? Utils::kses($title_html) : '';
						echo Utils::kses($number_html);
						echo $peeao_funfact_title_position == 'bottom' ? Utils::kses($title_html) : '';
						echo Utils::kses($desc_html);
					echo '</div>';
					echo $peeao_funfact_type == 'type4' ? Utils::kses($icon_image_html) : '';
				echo '</div>';
			echo '</div>';
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}