<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Repeater;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;



	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Faq extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_faq';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0 
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return esc_html__( 'Faq', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-accordion';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		protected function _register_controls() {
			$this->start_controls_section(
				'section_tab', [
					'label' => esc_html__( 'Faq', 'power-elements' ),
				]
			);
			$repeater = new Repeater();
			$repeater->add_control(
				'peeao_acc_title', [
					'label' => esc_html__('Title', 'power-elements'),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
				]
			);
			$repeater->add_control(
				'peeao_acc_content', [
					'label' => esc_html__('Description', 'power-elements'),
					'type' => Controls_Manager::WYSIWYG,
					'label_block' => true,
				]
			);
			$this->add_control(
				'peeao_faq_items',
				[
					'label' => esc_html__('Content', 'power-elements'),
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'title_field' => '{{ peeao_acc_title }}',
					'default' => [
						[
							'peeao_acc_title' => esc_html__(' How to take the service from a hosting company ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this faq. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
							'peeao_acc_is_active'    => 'yes'
						],[
							'peeao_acc_title' => esc_html__(' How will we cutomize elements in this faq ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this faq. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
						],[
							'peeao_acc_title' => esc_html__(' How will we cutomize elements in this faq ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this faq. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
						],
					],
					'fields' => $repeater->get_controls(),
				]
			);
			$this->end_controls_section();
	
			//Title Style Section
			$this->start_controls_section(
				'peeao_faq_section_title_style', [
					'label'	 =>esc_html__( 'Title', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_faq_title_typography',
					'selector'	 => '{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header .power-btn-link .power-faq-title',
				]
			);
			
			$this->add_control(
				'peeao_faq_title_color', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header .power-btn-link .power-faq-title' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_faq_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_faq_title_border_open',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '.peeao-wrapper .power-faq .power-card-header',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_faq_box_shadow_open',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header',
				]
			);
	
			$this->add_control(
				'peeao_faq_title_divide',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
			$this->add_responsive_control(
				'peeao_faq_title_padding',
				[
					'label' => esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_faq_title_margin_bottom',
				[
					'label' => esc_html__( 'Margin Bottom', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => -10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => -1,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
	
			$this->start_controls_section(
				'peeao_faq_section_content_style', [
					'label'	 =>esc_html__( 'Description', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_faq_content_color', [
					'label'		 =>esc_html__( 'color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'default'   => '#586c85',
					'selectors'	 => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-body' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_faq_content_typography',
					'selector'	 => '{{WRAPPER}} .peeao-wrapper .power-faq .power-card-body',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_faq_content_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-faq .power-card-body',
				]
			);
			$this->add_responsive_control(
				'peeao_faq_content_border_radious',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_faq_content_padding',
				[
					'label' => esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '30',
						'right' => '10',
						'bottom' => '30',
						'left' => '35',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-faq .power-card-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
	
		}
	
		protected function render( ) {
	
			$settings = $this->get_settings();
			extract($settings);?>

			<div class="peeao-wrapper"> 
				<div class="power-faq">
					<?php foreach($peeao_faq_items as $item): ?>
						<div class="power-card">
							<div class="power-card-header">
								<a href="#" class="power-btn-link">
									<span class="power-faq-title"><?php echo Utils::kses($item['peeao_acc_title']); ?></span>
								</a>
							</div>
							<div class="power-card-body">
								<?php echo Utils::kses($item['peeao_acc_content']); ?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php }
		protected function _content_template() { }
	}