<?php

namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;



defined( 'ABSPATH' ) || die();

class PowerElements_Easy_Forms extends Widget_Base {
	public function get_name() { 
		return 'power_elements_easy_forms';
	}
	public function get_title() {
		return __( 'Easy Forms', 'power-elements' );
	}
	public function get_icon() {
		return 'eicon-form-horizontal';
    }
    public function get_categories() {
		return [ 'power-elements' ];
	}
	protected function peeao_is_easy_forms_activated(){
		return class_exists( 'Yikes_Inc_Easy_Mailchimp_Forms_Admin' );
	}
    protected function _register_controls() {

  		$this->start_controls_section(
  			'peeao_section_easy_forms_form',
  			[
  				'label' => __( 'Contact Form', 'power-elements' )
  			]
  		);

		if ( ! $this->peeao_is_easy_forms_activated() ) {
			
			$this->add_control(
                'peeao_easy_forms_missing_notice',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => sprintf(
                        __( 'Hello, looks like %1$s is missing in your site. Please click on the link below and install/activate %1$s. Make sure to refresh this page after installation or activation.', 'power-elements' ),
                        '<a href="'.esc_url( admin_url( 'plugin-install.php?s=Easy+Forms+for+Mailchimp&tab=search&type=term' ) )
                        .'" target="_blank" rel="noopener">Easy Forms for Mailchimp</a>'
                    ),
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-danger',
                ]
            );

            $this->add_control(
                'peeao_easy_forms_install',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => '<a href="'.esc_url( admin_url( 'plugin-install.php?s=Easy+Forms+for+Mailchimp&tab=search&type=term' ) ).'" target="_blank" rel="noopener">Click to install or activate Easy Forms for Mailchimp</a>',
                ]
			);
			
            $this->end_controls_section();
            return;
		}
		$this->add_control(
			'peeao_easy_forms_form',
			[
				'label' => __( 'Select Your Easy Form', 'power-elements' ),
				'label_block' => true,
				'type' => Controls_Manager::SELECT,
				'options' => $this->peeao_contact_form(),
			]
		);

		$this->end_controls_section();
        
        $this->start_controls_section('peeao_easy_forms_settings_section', 
            [
                'label'     => __('Settings', 'power-elements'),
			]
		);
        
        $this->add_control('peeao_easy_forms_settings',
            [
                'label'     => __('Width', 'power-elements'),
                'type'      => Controls_Manager::HEADING
			]
		);
        
        $this->add_responsive_control(
  			'peeao_easy_forms_settings_input_width',
  			[
  				'label' => __( 'Input Field', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1200,
					],
					'em' => [ 
						'min' => 1,
						'max' => 80,
					],
				],
                'default'   => [
                    'size'  => 80,
                    'unit'  => '%'
                ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-easy-mc-form label.label-inline' => 'min-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'width: {{SIZE}}{{UNIT}};',
				],
  			]
  		);
        /*Button Width*/
        $this->add_responsive_control(
			'peeao_easy_forms_button_width',
			[
				'label' => __( 'Button', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
			  'size_units' => [ 'px', 'em', '%' ],
			  'range' => [
				  'px' => [
					  'min' => 10,
					  'max' => 1200,
				  ],
				  'em' => [
					  'min' => 1,
					  'max' => 80,
				  ],
			  ],
			  'selectors' => [
				  '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-easy-mc-form .submit-button-inline-label' => 'min-width: {{SIZE}}{{UNIT}};',
				  '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'width: {{SIZE}}{{UNIT}};',
			  ],
			]
		);  
         $this->add_control('peeao_easy_forms_settings_height_heading',
            [
                'label'     => __('Height', 'power-elements'),
                'type'      => Controls_Manager::HEADING
			]
		);
         
         $this->add_responsive_control(
  			'peeao_easy_forms_settings_input_height',
  			[
  				'label' => __( 'Input Field', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 500,
					],
					'em' => [
						'min' => 1,
						'max' => 40,
					],
				],
				'default'   => [
                    'size'  => 35,
                    'unit'  => 'px'
                ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'height: {{SIZE}}{{UNIT}};',
				],
  			]
		  );
		  $this->add_control(
			'peeao_easy_forms_settings_button_label_switch',
			[
				'label'        => __( 'Hide Button Label?', 'power-elements' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'power-elements' ),
				'label_off'    => __( 'No', 'power-elements' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		$this->add_control(
			'peeao_easy_forms_settings_button_icon',
			[
				'label' => esc_html__('Button Icon', 'power-elements'),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'peeao peeao-ios-send',
					'library' => 'peeaoicons',
				],
			]
		);
        /*Button Height*/
        $this->add_responsive_control(
			'peeao_easy_forms_settings_button_height',
			[
				'label' => __( 'Button', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 500,
					],
					'em' => [
						'min' => 1,
						'max' => 40,
					],
				],
			  	'default'   => [
					'size'  => 35,
					'unit'  => 'px'
				],
			  	'selectors' => [
				  	'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'height: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
			  	],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'section_contact_form_styles',
			[
				'label' => __( 'Form', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			  
		$this->add_control(
			'peeao_easy_forms_input_color',
			[
				'label' => __( 'Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email,
					{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone,
					{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-tex,
					{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_easy_forms_input_placeholder_color',
			[
				'label' => __( 'Placeholder Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container :-ms-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container :-moz-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_easy_forms_input_background',
				'label'    => __( 'Background Color', 'power-elements' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address',
			]
		);
        $this->add_responsive_control(
			'peeao_easy_forms_input_padding',
			[
				'label' => __( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);            
                
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'peeao_easy_forms_input_border',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email,
				{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone,
				{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text,
				{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address',
			]
		);
                
        $this->add_responsive_control(
			'peeao_easy_forms_input_border_radius',
			[
				'label' => __( 'Border Radius', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'peeao_easy_forms_input_margin',
			[
				'label' => __( 'Margin', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',					
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_button_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address',
			]
		);

    	$this->end_controls_section();
		  
		
		$this->start_controls_section(
			'section_contact_form_typography',
			[
				'label' => __( 'Labels', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
                
        $this->add_control(
			'peeao_easy_forms_heading_default',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __( 'Default Typography', 'power-elements' ),
			]
		);
		
		$this->add_control(
			'peeao_easy_forms_contact_form_color',
			[
				'label' => __( 'Default Font Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power-easy-form-container, {{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container label' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'peeao_easy_forms_contact_form_default_typography',
				'selector' => '{{WRAPPER}} .power-easy-form-container',
			]
		);
        
      	$this->add_control(
			'peeao_easy_forms_heading_input',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __( 'Input Typography', 'power-elements' ),
            'separator' => 'before',
			]
		);
		
		$this->add_control(
			'peeao_easy_forms_contact_form_field_color',
			[
				'label' => __( 'Input Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'peeao_easy_forms_contact_form_field_typography',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-email,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-text,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-phone,{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-address',
			]
		);
        
		
		$this->add_control(
			'peeao_easy_forms_contact_form_placeholder_color',
			[
				'label' => __( 'Placeholder Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container ::-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
	
		
		$this->end_controls_section();
                         
        $this->start_controls_section(
			'section_contact_form_submit_button_styles',
			[
				'label' => __( 'Button', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
             'name' => 'section_title_peeao_btn_typography',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button',
			]
		);
		
		$this->add_responsive_control(
			'section_title_peeao_btn_padding',
			[
				'label' => __( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'section_title_peeao_btn_margin',
			[
				'label' => __( 'Margin', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
					'top' => '-1',
					'right' => '',
					'bottom' => '',
					'left' => '-9',
					'unit' => 'px',
					'isLinked' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->start_controls_tabs( 'peeao_easy_forms_button_tabs' );

		$this->start_controls_tab( 'normal', [ 'label' => __( 'Normal', 'power-elements' ) ] );

		$this->add_control(
			'peeao_easy_forms_button_text_color',
			[
				'label' => __( 'Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'color: {{VALUE}};',
				],
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_easy_forms_button_background_color',
				'label'    => __( 'Background Color', 'power-elements' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'peeao_easy_forms_btn_border',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button',
			]
		);
		
		$this->add_responsive_control(
			'peeao_easy_forms_btn_border_radius',
			[
				'label' => __( 'Border Radius', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'default'   => [
                    'size'  => 0,
                    'unit'  => 'px'
                ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'border-radius: {{SIZE}}px;',
				],
			]
		);
		

		
		$this->end_controls_tab();

		$this->start_controls_tab( 'peeao_easy_forms_hover', [ 'label' => __( 'Hover', 'power-elements' ) ] );

		$this->add_control(
			'peeao_easy_forms_button_hover_text_color',
			[
				'label' => __( 'Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_easy_forms_button_hover_background_color',
				'label'    => __( 'Background Color', 'power-elements' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button:hover',
			]
		);

		$this->add_control(
			'peeao_easy_forms_button_hover_border_color',
			[
				'label' => __( 'Border Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'peeao_easy_forms_button_box_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button',
			]
		);
		
		$this->add_responsive_control(
			'peeao_easy_forms_button_align',
			[
				'label'        => __( 'Align', 'power-elements' ),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => [
					'none'    => [
						'title' => __( 'None', 'power-elements' ),
						'icon'  => 'fa fa-align-justify',
					],
					'right'   => [
						'title' => __( 'Right', 'power-elements' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-easy-form-container .yikes-mailchimp-container .yikes-easy-mc-submit-button' => 'float: {{VALUE}};',
				],
				'default'      => 'none',
			]
		);

		$this->end_controls_section();
                
    }
        
    protected function peeao_contact_form( ) {

		if ( ! function_exists( 'yikes_easy_mailchimp_extender_get_form_interface' ) ) {
			return [];
		}
		$result = [];
		$form_interface = yikes_easy_mailchimp_extender_get_form_interface();
		$all_forms = $form_interface->get_all_forms();
		foreach( $all_forms as $id => $form ) {
			$result[ $id ] = $form['form_name'];
		}

		return $result;
	}
    
    protected function render() {

		$settings = $this->get_settings();

		if ( ! $this->peeao_is_easy_forms_activated() || empty( $settings['peeao_easy_forms_form'] )) {
			return;
		} ?>
		<div class="peeao-wrapper">
			<div class="power-easy-form-container power_easy_forms_settings_button_label_switch_<?php echo $settings['peeao_easy_forms_settings_button_label_switch']; ?>">
				<?php echo do_shortcode( '[yikes-mailchimp form="' . $settings['peeao_easy_forms_form'] . '" ]' );?>
				<div style="clear:both"></div>
			</div>
        </div>
        
	<?php }
}