<?php
namespace PowerElements;

use \Elementor\Icons_Manager;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element button widget.
	 *
	 * Elementor widget that displays a button with the ability to control every
	 * aspect of the button design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Dual_Button extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve button widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_dual_button';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve button widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Dual Button', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve button widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-button';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the button widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements'];
		}
		

		
		/**
		 * Register button widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_section_dual_button_one',
				[
					'label' => __( 'Button One', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_style',
				[
					'label'        => __( 'Type', 'power-elements' ),
					'type'         => Controls_Manager::SELECT,
					'default'      => 'effect_1',
					'options'      => [
						'effect_1'  => __( 'Effect 1', 'power-elements' ),
						'effect_2'  => __( 'Effect 2', 'power-elements' ),
						'effect_3'  => __( 'Effect 3', 'power-elements' ),
						'effect_4'  => __( 'Effect 4', 'power-elements' ),
						'effect_5'  => __( 'Effect 5', 'power-elements' ),
						'effect_6'  => __( 'Effect 6', 'power-elements' ),
						'effect_7'  => __( 'Effect 7', 'power-elements' ),
						'effect_8'  => __( 'Effect 8', 'power-elements' ),
						'effect_9'  => __( 'Effect 9', 'power-elements' ),
						'effect_10' => __( 'Effect 10', 'power-elements' ),
						'effect_11' => __( 'Effect 11', 'power-elements' ),
						'effect_12' => __( 'Effect 12', 'power-elements' ),
						'effect_13' => __( 'Effect 13', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_text',
				[
					'label'       => __( 'Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Click here', 'power-elements' ),
					'placeholder' => __( 'Click here', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_link',
				[
					'label'       => __( 'Link', 'power-elements' ),
					'type'        => Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'power-elements' ),
					'default'     => [
						'url' => '#',
					],
				]
			);
		
			$this->add_control(
				'peeao_dual_button_one_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
						'library' => 'peeaoicons',
					],
				]
			);
			$this->add_control(
				'peeao_dual_button_one_icon_align',
				[
					'label'     => __( 'Icon Position', 'power-elements' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'power_dual_button_icon_left',
					'options'   => [
						'power_dual_button_icon_right' => __( 'Right', 'power-elements' ),
						'power_dual_button_icon_left'  => __( 'Left', 'power-elements' ),
					],
					'condition' => [
						'peeao_dual_button_one_icon!' => '',
					],
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_one_icon_indent',
				[
					'label'     => __( 'Icon Spacing', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 50,
						],
					],
					'condition' => [
						'peeao_dual_button_one_icon!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_icon_right i' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_dual_button_icon_left i'  => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_view',
				[
					'label'   => __( 'View', 'power-elements' ),
					'type'    => Controls_Manager::HIDDEN,
					'default' => 'traditional',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_section_dual_button_two',
				[
					'label' => __( 'Button Two', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_style',
				[
					'label'        => __( 'Type', 'power-elements' ),
					'type'         => Controls_Manager::SELECT,
					'default'      => 'effect_1',
					'options'      => [
						'effect_1'  => __( 'Effect 1', 'power-elements' ),
						'effect_2'  => __( 'Effect 2', 'power-elements' ),
						'effect_3'  => __( 'Effect 3', 'power-elements' ),
						'effect_4'  => __( 'Effect 4', 'power-elements' ),
						'effect_5'  => __( 'Effect 5', 'power-elements' ),
						'effect_6'  => __( 'Effect 6', 'power-elements' ),
						'effect_7'  => __( 'Effect 7', 'power-elements' ),
						'effect_8'  => __( 'Effect 8', 'power-elements' ),
						'effect_9'  => __( 'Effect 9', 'power-elements' ),
						'effect_10' => __( 'Effect 10', 'power-elements' ),
						'effect_11' => __( 'Effect 11', 'power-elements' ),
						'effect_12' => __( 'Effect 12', 'power-elements' ),
						'effect_13' => __( 'Effect 13', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_text',
				[
					'label'       => __( 'Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Click here', 'power-elements' ),
					'placeholder' => __( 'Click here', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_link',
				[
					'label'       => __( 'Link', 'power-elements' ),
					'type'        => Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'power-elements' ),
					'default'     => [
						'url' => '#',
					],
				]
			);
			$this->add_control(
				'peeao_dual_button_two_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
						'library' => 'peeaoicons',
					],
				]
			);
			$this->add_control(
				'peeao_dual_button_two_icon_align',
				[
					'label'     => __( 'Icon Position', 'power-elements' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'power_dual_button_icon_left',
					'options'   => [
						'power_dual_button_icon_right' => __( 'Right', 'power-elements' ),
						'power_dual_button_icon_left'  => __( 'Left', 'power-elements' ),
					],
					'condition' => [
						'peeao_dual_button_one_icon!' => '',
					],
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_two_icon_indent',
				[
					'label'     => __( 'Icon Spacing', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 50,
						],
					],
					'condition' => [
						'peeao_dual_button_one_icon!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_icon_right i' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_dual_button_icon_left i'  => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_view',
				[
					'label'   => __( 'View', 'power-elements' ),
					'type'    => Controls_Manager::HIDDEN,
					'default' => 'traditional',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_section_dual_button_settings',
				[
					'label' => __( 'Settings', 'power-elements' ),
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_spacing',
				[
					'label' => esc_html__( 'Spacing', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 30,
					],
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one' => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_dual_button_align',
				[
					'label'        => __( 'Alignment', 'power-elements' ),
					'type'         => Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justified', 'power-elements' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'prefix_class' => 'elementor%s-align-',
					'default'      => '',
				]
			);
			$this->end_controls_section();



			$this->start_controls_section(
				'peeao_dual_button_one_section_style',
				[
					'label' => __( 'Button One', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_dual_button_one_content_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_dual_button_one',
				]
			);
			$this->start_controls_tabs( 'peeao_dual_button_one_tabs_button_style' );
			
			$this->start_controls_tab(
				'peeao_dual_button_one_tab_style_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_ext_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#0071f0',
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one span' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one .power_dual_button-link' => 'text-decoration-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_dual_button_one_background_color',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_dual_button_one ',
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_background_color_after',
				[
					'label'     => __( 'Background After Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one:after,' => 'background-color: {{VALUE}};',
						
					],
				]
			);
			
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'peeao_dual_button_one_tab_style_before',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_hover_text_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one:hover span' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one:focus' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one:hover .power_dual_button-link' => 'text-decoration-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_dual_button_one_background_hover_color',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_dual_button_one:hover',
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_background_before_color',
				[
					'label'     => __( 'Background Before Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one:before' => 'background-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_hover_border_color',
				[
					'label'     => __( 'Border Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'peeao_dual_button_one_border_border!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one:focus' => 'border-color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one:hover' => 'border-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_one_before_animation',
				[
					'label' => __( 'Hover Animation', 'power-elements' ),
					'type'  => Controls_Manager::HOVER_ANIMATION,
				]
			);
			
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			$this->add_control(
				'peeao_dual_button_one_hr-i',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->start_controls_tabs( 'peeao_dual_button_one_tabs_border' );
			
			$this->start_controls_tab(
				'peeao_dual_button_one_tab_border_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_dual_button_one_border',
					'fields_options' => [
						'border' => [
							'default' => 'solid',
						],
						'width' => [
							'default' => [
								'top' => '1',
								'right' => '1',
								'bottom' => '1',
								'left' => '1',
								'isLinked' => false,
							],
						],
						'color' => [
							'default' => '#0071f0',
						],
					],
					'selector'  => '{{WRAPPER}} .power_dual_button_one',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_one_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '100',
						'right' => '100',
						'bottom' => '100',
						'left' => '100',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}}  .power_dual_button_one' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_dual_button_one_box_shadow',
					'selector' => '{{WRAPPER}} .power_dual_button',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_one_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_control(
				'peeao_dual_button_one_icon_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one span .power_dual_button_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_dual_button_one_tab_border_before',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_dual_button_one_border_before',
					'selector'  => '{{WRAPPER}} .power_dual_button_one:before',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_one_before_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '100',
						'right' => '100',
						'bottom' => '100',
						'left' => '100',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_one:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_dual_button_one_before_box_shadow',
					'selector' => '{{WRAPPER}} .power_dual_button:before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_one_before_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_one:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
				
			);
			$this->add_control(
				'peeao_dual_button_one_hover_icon_hover_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_one:hover span .power_dual_button_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_one:focus .power_dual_button_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();


			$this->start_controls_section(
				'peeao_dual_button_two_section_style',
				[
					'label' => __( 'Button Two', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_dual_button_two_content_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_dual_button_two',
				]
			);
			$this->start_controls_tabs( 'peeao_dual_button_two_tabs_button_style' );
			
			$this->start_controls_tab(
				'peeao_dual_button_two_tab_style_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_ext_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#0071f0',
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two span' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_two .power_dual_button-link' => 'text-decoration-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_dual_button_two_background_color',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_dual_button_two',
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_background_color_after',
				[
					'label'     => __( 'Background After Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} a.power_dual_button_two:after' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_two:after' => 'background-color: {{VALUE}};',
						
					],
				]
			);
			
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'peeao_dual_button_two_tab_style_before',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_hover_text_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two:hover span' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_two:focus span',
						'{{WRAPPER}} .power_dual_button_two:hover .power_dual_button-link' => 'text-decoration-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_dual_button_two_background_hover_color',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_dual_button_two:hover',
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_background_before_color',
				[
					'label'     => __( 'Background Before Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two:before' => 'background-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_hover_border_color',
				[
					'label'     => __( 'Border Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'peeao_dual_button_one_border_border!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two:hover' => 'border-color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_two:focus' => 'border-color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'peeao_dual_button_two_before_animation',
				[
					'label' => __( 'Hover Animation', 'power-elements' ),
					'type'  => Controls_Manager::HOVER_ANIMATION,
				]
			);
			
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			$this->add_control(
				'peeao_dual_button_two_hr-i',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->start_controls_tabs( 'peeao_dual_button_two_tabs_border' );
			
			$this->start_controls_tab(
				'peeao_dual_button_two_tab_border_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_dual_button_two_border',
					'fields_options' => [
						'border' => [
							'default' => 'solid',
						],
						'width' => [
							'default' => [
								'top' => '1',
								'right' => '1',
								'bottom' => '1',
								'left' => '1',
								'isLinked' => false,
							],
						],
						'color' => [
							'default' => '#0071f0',
						],
					],
					'selector'  => '{{WRAPPER}} .power_dual_button_two',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_two_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '100',
						'right' => '100',
						'bottom' => '100',
						'left' => '100',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_dual_button_two_box_shadow',
					'selector' => '{{WRAPPER}} .power_dual_button_two',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_two_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_control(
				'peeao_dual_button_two_icon_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two span .power_dual_button_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_dual_button_two_tab_border_before',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_dual_button_two_border_before',
					'selector'  => '{{WRAPPER}} .power_dual_button_two:before',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_two_before_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '100',
						'right' => '100',
						'bottom' => '100',
						'left' => '100',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_two:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_dual_button_two_before_box_shadow',
					'selector' => '{{WRAPPER}} .power_dual_button_two:before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_dual_button_two_before_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .power_dual_button_two:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
				
			);
			$this->add_control(
				'peeao_dual_button_two_hover_icon_hover_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_dual_button_two:hover span .power_dual_button_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_dual_button_two:focus .power_dual_button_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

		}
		
		
		
		/**
		 * Render button widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected 
		 */
		protected function render() {
			$settings = $this->get_settings();
			
			$this->add_render_attribute( 'wrapper', 'class', 'power_dual_button_wrapper_flex' );
			
			if ( ! empty( $settings['peeao_dual_button_one_link']['url'] ) ) {
				$this->add_render_attribute( 'button_one', 'href', $settings['peeao_dual_button_one_link']['url'] );
				$this->add_render_attribute( 'button_one', 'class', 'power_dual_button-link' );
				
				if ( $settings['peeao_dual_button_one_link']['is_external'] ) {
					$this->add_render_attribute( 'button_one', 'target', '_blank' );
				}
				
				if ( $settings['peeao_dual_button_one_link']['nofollow'] ) {
					$this->add_render_attribute( 'button_one', 'rel', 'nofollow' );
				}
			}
			if ( ! empty( $settings['peeao_dual_button_two_link']['url'] ) ) {
				$this->add_render_attribute( 'button_two', 'href', $settings['peeao_dual_button_two_link']['url'] );
				$this->add_render_attribute( 'button_two', 'class', 'power_dual_button-link' );
				
				if ( $settings['peeao_dual_button_two_link']['is_external'] ) {
					$this->add_render_attribute( 'button_two', 'target', '_blank' );
				}
				
				if ( $settings['peeao_dual_button_two_link']['nofollow'] ) {
					$this->add_render_attribute( 'button_two', 'rel', 'nofollow' );
				}
			}
			
			$this->add_render_attribute( 'button_one', 'class', [
				'power_dual_button power_dual_button_one',
				$settings['peeao_dual_button_one_style'],
				$settings['peeao_dual_button_one_icon_align']
			] );
			$this->add_render_attribute( 'button_two', 'class', [
				'power_dual_button power_dual_button_two',
				$settings['peeao_dual_button_two_style'],
				$settings['peeao_dual_button_two_icon_align']
			] );
			$this->add_render_attribute( 'button_one', 'role', 'button' );
			$this->add_render_attribute( 'button_two', 'role', 'button' );
			
			if ( $settings['peeao_dual_button_one_before_animation'] ) {
				$this->add_render_attribute( 'button_one', 'class', 'elementor-animation-' . $settings['peeao_dual_button_one_before_animation'] );
			}
			if ( $settings['peeao_dual_button_two_before_animation'] ) {
				$this->add_render_attribute( 'button_two', 'class', 'elementor-animation-' . $settings['peeao_dual_button_two_before_animation'] );
			}

			
			$this->add_inline_editing_attributes( 'text', 'none' ); ?>
			
			<div class="peeao-wrapper">
				<div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
					<a <?php echo $this->get_render_attribute_string( 'button_one' ); ?>>
						<?php if ( $settings['peeao_dual_button_one_icon_align'] == 'power_dual_button_icon_right' ) : ?>
							<?php if ( ! empty( $settings['peeao_dual_button_one_icon'] ) ) : ?>
								<span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php echo $settings['peeao_dual_button_one_text']; ?><?php Icons_Manager::render_icon( $settings['peeao_dual_button_one_icon'], [ 'class'    => 'power_dual_button_icon' ] );?></span>
							<?php endif; ?>
						<?php else : ?>
							<span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php Icons_Manager::render_icon( $settings['peeao_dual_button_one_icon'], [ 'class'    => 'power_dual_button_icon' ] );?><?php echo $settings['peeao_dual_button_one_text']; ?></span>
						<?php endif; ?>
					</a>
					<a <?php echo $this->get_render_attribute_string( 'button_two' ); ?>>
						<?php if ( $settings['peeao_dual_button_two_icon_align'] == 'power_dual_button_icon_right' ) : ?>
							<?php if ( ! empty( $settings['peeao_dual_button_two_icon'] ) ) : ?>
								<span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php echo $settings['peeao_dual_button_two_text']; ?><?php Icons_Manager::render_icon( $settings['peeao_dual_button_two_icon'], [ 'class'    => 'power_dual_button_icon' ] );?></span>
							<?php endif; ?>
						<?php else : ?>
							<span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php Icons_Manager::render_icon( $settings['peeao_dual_button_two_icon'], [ 'class'    => 'power_dual_button_icon' ] );?><?php echo $settings['peeao_dual_button_two_text']; ?></span>
						<?php endif; ?>
					</a>
				</div>
            </div>
			<?php
		}

		/**
		 * Render button widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() { }
	}