<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Demo_Gallery extends Widget_Base {
		
		/**
		 * Get widget name. 
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_demo_gallery';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Demo Gallery', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-icon-box';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_demo_gallery_section',
				[
					'label' => __( 'Demo Gallery', 'power-elements' ),
				]
			);

			$this->add_control(
				'peeao_demo_gallery_api',
				[
					'label'       => __( 'API', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => esc_url_raw('http://api.wpthemebooster.com/public/power-layouts/?action=get_layouts&tab=power_block'),
					'placeholder' => __( 'Type your api here', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_demo_gallery_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-add-circle-outline',
						'library' => 'peeaoicons',
					],
				]
			);
			
			$this->end_controls_section();



			/*
			 * STYLE OPTIONS WRAPPER
			 */
			$this->start_controls_section(
				'section_peeao_demo_gallery_wrapper_style',
				[
					'label' => __( 'Item Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_demo_gallery_wrapper_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_demo_gallery_wrapper_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_demo_gallery_wrapper_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power-gallery-thumb a',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_demo_gallery_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-gallery-thumb a',
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_demo_gallery_shadow',
					'selector' => '{{WRAPPER}} .power-gallery-thumb a',
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_demo_gallery_wrapper_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_demo_gallery_wrapper_bg_hover',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power-gallery-thumb a:hover',
				]
			);
			$this->add_group_control( 
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_demo_gallery_wrapper_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-gallery-thumb a:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_demo_gallery_shadow_hover',
					'selector' => '{{WRAPPER}} .power-gallery-thumb:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_padding_hover',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_wrapper_margin_hover',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS ICON
			 */
			$this->start_controls_section(
				'section_peeao_demo_gallery_icon_style',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			
			$this->add_responsive_control(
				'peeao_demo_gallery_icon_size',
				[
					'label'     => __( 'Size', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 36,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power-gallery-thumb a i'   => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'peeao_demo_gallery_icon_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_demo_gallery_icon_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power-gallery-thumb a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_demo_gallery_icon_tabs'
			);

			$this->start_controls_tab(
				'peeao_demo_gallery_icon_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_demo_gallery_icon_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power-gallery-thumb a i' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_demo_gallery_icon_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power-gallery-thumb a',
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_demo_gallery_icon_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_demo_gallery_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power-gallery-thumb a:hover i' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			extract($settings);
			
			$response = wp_remote_get(
				$peeao_demo_gallery_api,
				[
					'timeout'=>120,
					'httpversion'=>'1.1'
				]
			);
			
			if( is_array($response) && $response['body'] != ''){
				$blocks_obj = json_decode(Utils::kses($response['body']));
				$gallery = $blocks_obj->data->templates;
			}
			
			?>
		
			<div class="peeao-wrapper">
                <div class="container power-gallery-demo">
                    <div class="row">
						<?php if(!empty($gallery)) foreach($gallery as $item){ ?>
							<div class="col-md-4">
								<div class="power-gallery-thumb">
									<a href="<?php echo esc_url($item->livelink); ?>" target="_blank">
										<img src="<?php echo esc_url($item->thumbnail); ?>" alt="block">
										<i class="<?php echo esc_attr($peeao_demo_gallery_icon['value']); ?>"></i>
									</a>
								</div>
							</div>
						<?php } ?>
                    </div>
                </div>
			</div> 
			
			<?php
			
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
		
	}