<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Scheme_Typography;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	

	class PowerElements_Circle_Progressbar extends Widget_Base {
		
		public function get_name() {
			return 'power_elements_circle_progress';
		}

		public function get_title() {
			return __( 'Circle Progressbar', 'power-elements' );
		}
		
		public function get_icon() {
			return 'eicon-counter-circle';
		}
		
		public function get_categories() {
			return [ 'power-elements' ];
		}

		protected function _register_controls() {
			$this->start_controls_section(
				'section_progress_content',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_circle_progress_title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Marketing', 'power-elements' ),
					'placeholder' => __( 'Title', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_value',
				[
					'label'       => __( 'Value', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'default'     => __( '65', 'power-elements' ),
					'placeholder' => __( 'Value.', 'power-elements' ),
					'description' => __( 'Value is numerical.', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_circle_progress_value_postfix',
				[
					'label'       => __( 'Postfix', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( '%', 'power-elements' ),
					'description' => __( 'Postfix of value field. if value is 85 then % will be its postfix. 85%', 'power-elements' ),
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR
			 */
			$this->start_controls_section(
				'peeao_circle_progress_wrapper_style',
				[
					'label' => __( 'Circular', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_align',
				[
					'label'        => __( 'Alignment', 'power-elements' ),
					'type'         => Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular_content' => 'text-align: {{VALUE}}',
					]
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_width',
				[
					'label' => __( 'Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 200,
					],
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular' => 'width: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_height',
				[
					'label' => __( 'Height', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 200,
					],
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular' => 'height: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_control(
				'peeao_circle_progress_fill_color',
				[
					'label'     => __( 'Fill Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_track' => 'fill: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_circle_progress_stroke_color',
				[
					'label'     => __( 'Stroke Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [ 
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_track' => 'stroke: {{VALUE}}',
					]
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_stroke_width',
				[
					'label' => __( 'Stroke Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 5,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 8,
					],
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_track' => 'stroke-width: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR CIRCLE MOVE
			 */
			$this->start_controls_section(
				'peeao_circle_progress_circle_style',
				[
					'label' => __( 'Circle Move', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_circle_progress_circle_stroke_width',
				[
					'label' => __( 'Stroke Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 5,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 4,
					],
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_fill' => 'stroke-width: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_control(
				'peeao_circle_progress_circle_fill_color',
				[
					'label'     => __( 'Fill Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_fill' => 'fill: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_circle_progress_circle_stroke_color',
				[
					'label'     => __( 'Stroke Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_fill' => 'stroke: {{VALUE}}',
					]
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR CIRCLE MOVE
			 */
			$this->start_controls_section(
				'peeao_circle_progress_value_style',
				[
					'label' => __( 'Value', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_circle_progress_value_fill_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_value' => 'fill: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_circle_progress_value_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_progress_circular .power_progress_circular_value',
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE PROGRESSBAR CIRCLE MOVE
			 */
			$this->start_controls_section(
				'peeao_circle_progress_text_style',
				[
					'label' => __( 'Text', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_circle_progress_text_fill_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_progress_circular .power_progress_circular_text' => 'fill: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_circle_progress_text_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_progress_circular .power_progress_circular_text',
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			
			$value = $settings['peeao_circle_progress_value']!=''? $settings['peeao_circle_progress_value'].$settings['peeao_circle_progress_value_postfix'] : '0';
			$this->add_render_attribute( 'circle_postfix', 'data-postfix', $settings['peeao_circle_progress_value_postfix']);
			echo '<div class="peeao-wrapper"><div class="power_progress_circular_content">
                <svg class="power_progress_circular" '.$this->get_render_attribute_string( 'circle_postfix' ).' data-progress="'.esc_attr($settings['peeao_circle_progress_value']).'" x="0px" y="0px" viewBox="0 0 80 80">
                    <path class="power_progress_circular_track" d="M5,40a35,35 0 1,0 70,0a35,35 0 1,0 -70,0" />
                    <path class="power_progress_circular_fill" d="M5,40a35,35 0 1,0 70,0a35,35 0 1,0 -70,0" />
                    <text class="power_progress_circular_value" x="50%" y="45%">'.esc_html($value).'</text>
                    <text class="power_progress_circular_text" x="50%" y="65%">'.esc_html($settings['peeao_circle_progress_title']).'</text>
                </svg>
            </div></div>';
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}