<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;


use \Elementor\Widget_Base;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Blog_Carousel extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_blog_carousel';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Blog Carousel', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-posts-carousel';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_blog_carousel_section_posts_content',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_group_control(
				'powerpost',
				[
					'name' => 'powerpost',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_advanced',
				[
					'label' => __( 'Advanced', 'power-elements' ),
					'type'  => Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'peeao_blog_carousel_orderby',
				[
					'label'   => __( 'Order By', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'post_date',
					'options' => [
						'post_date'  => __( 'Date', 'power-elements' ),
						'post_title' => __( 'Title', 'power-elements' ),
						'menu_order' => __( 'Menu Order', 'power-elements' ),
						'rand'       => __( 'Random', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_blog_carousel_order',
				[
					'label'   => __( 'Order', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'desc',
					'options' => [
						'asc'  => __( 'ASC', 'power-elements' ),
						'desc' => __( 'DESC', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_blog_carousel_offset',
				[
					'label'       => __( 'Offset', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'default'     => 0,
					'description' => __( 'Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_post__not_in', 
				[
					'label'       => __( 'Exclude', 'power-elements' ),
					'type'        => Controls_Manager::SELECT2,
					'options'     => Partials::get_all_types_post(),
					'label_block' => true,
					'post_type'   => '',
					'multiple'    => true,
					'condition'   => [
						'eaeposts_post_type!' => 'by_id',
					], 
				]
			);
			$this->add_control(
				'peeao_blog_carousel_posts_per_page',
				[
					'label'   => __( 'Posts Per Page', 'power-elements' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => '3',
				]
			);
			$this->end_controls_section();
			/*
			 *
			 * SETTINGS
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_section_settings',
				[
					'label' => __( 'Settings', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_blog_carousel_item',
				[
					'label'       => __( 'Desktop Item', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 1,
					'max'         => 100,
					'step'        => 1,
					'default'     => 3,
					'description' => __( 'Number of item shows on destop and tablet screen', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_item_mobile',
				[
					'label'       => __( 'Mobile Item', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 1,
					'max'         => 100,
					'step'        => 1,
					'default'     => 1,
					'description' => __( 'Number of item shows on mobile and small tablet screen', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_margin',
				[
					'label'   => __( 'Margin', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'range'   => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'default' => [
						'size' => 30,
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_padding',
				[
					'label'   => __( 'Padding', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'range'   => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'default' => [
						'size' => 30,
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_autoplay',
				[
					'label'   => __( 'Autoplay', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_responsive_class',
				[
					'label'   => __( 'Responsive Class', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_dots',
				[
					'label'   => __( 'Dots', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav',
				[
					'label'   => __( 'Navigation', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav_style',
				[
					'label'   => __( 'Navigation Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'power_owl_nav_bottom',
					'options' => [
						'power_owl_nav_bottom'  => __( 'Bottom', 'power-elements' ),
						'power_owl_nav_side' => __( 'Side', 'power-elements' ),
						'power_owl_nav_outside_grid' => __( 'Outside Grid', 'power-elements' ),
					],
					'condition'   => [
						'peeao_blog_carousel_nav' => 'true',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_heading_text',
				[
					'label'       => esc_html__( 'Heading', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'label_block' => false,
					'default'     => esc_html__( 'Blog Carousel', 'power-elements' ),
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_outside_grid',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_heading_desc',
				[
					'label'       => esc_html__( 'Dscription', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'label_block' => false,
					'default'     => esc_html__( 'description here', 'power-elements' ),
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_outside_grid',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_blog_carousel_post_layout_style',
				[
					'label' => __( 'Layout', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			
			$this->add_control(
				'peeao_blog_carousel_show_image',
				[
					'label'   => __( 'Show Image', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name'      => 'peeao_blog_carousel_image',
					'exclude'   => [ 'custom' ],
					'default'   => 'medium',
					'condition' => [
						'peeao_blog_carousel_show_image' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_title',
				[
					'label'   => __( 'Show Title', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			
			$this->add_control(
				'peeao_blog_carousel_show_excerpt',
				[
					'label'   => __( 'Show excerpt', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			
			$this->add_control(
				'peeao_blog_carousel_excerpt_length',
				[
					'label'     => __( 'Excerpt Words', 'power-elements' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => '10',
					'condition' => [
						'peeao_blog_carousel_show_excerpt' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_read_more',
				[
					'label'   => __( 'Show Read More', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '0'
				]
			);
			$this->add_control(
				'peeao_blog_carousel_read_more_position',
				[
					'label'   => __( 'Read More Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'1'  => __( 'With meta', 'power-elements' ),
						'2' => __( 'After meta', 'power-elements' ),
					],
					'condition'   => [
						'peeao_blog_carousel_show_read_more' => '1',
					],
					'default' => '2'
				]
			);

			$this->add_control(
				'peeao_blog_carousel_read_more_text',
				[
					'label'       => esc_html__( 'Label Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'label_block' => false,
					'default'     => esc_html__( 'Read More', 'power-elements' ),
					'condition'   => [
						'peeao_blog_carousel_show_read_more' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_meta',
				[
					'label'   => __( 'Show Meta', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_meta_position',
				[
					'label'   => __( 'Meta Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'1'  => __( 'Before Title ', 'power-elements' ),
						'2' => __( 'After Title', 'power-elements' ),
						'3' => __( 'After Content', 'power-elements' ),
					],
					'condition'   => [
						'peeao_blog_carousel_show_meta' => '1',
					],
					'default' => '3'
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_author',
				[
					'label'   => __( 'Show Author', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'condition'   => [
						'peeao_blog_carousel_show_meta' => '1',
					],
					'default' => '0',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_avatar',
				[
					'label'   => __( 'Show Avatar', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'condition'   => [
						'peeao_blog_carousel_show_meta' => '1',
					],
					'default' => '0',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_date',
				[
					'label'   => __( 'Show Date', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'condition'   => [
						'peeao_blog_carousel_show_meta' => '1',
					],
					'default' => '1',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_date_icon',
				[
					'label'       => __( 'Date Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-alarm',
						'library' => 'peeaoicons',
					],
					'label_block' => true,
					'condition'   => [
						'peeao_blog_carousel_show_date' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_comments',
				[
					'label'   => __( 'Show Comments', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'condition'   => [
						'peeao_blog_carousel_show_meta' => '1',
					],
					'default' => '1',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_comment_icon',
				[
					'label'       => __( 'Comment Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-alarm',
						'library' => 'peeaoicons',
					],
					'label_block' => true,
					'condition'   => [
						'peeao_blog_carousel_show_comments' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_show_category',
				[
					'label'   => __( 'Show Category', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __( 'Yes', 'power-elements' ),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __( 'No', 'power-elements' ),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_text',
				[
					'label'       => esc_html__( 'Label Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'label_block' => false,
					'default'     => esc_html__( 'Categories:', 'power-elements' ),
					'condition'   => [
						'peeao_blog_carousel_show_category' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_position',
				[
					'label'   => __( 'Category Position', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'1'  => __( 'With Meta ', 'power-elements' ),
						'2' => __( 'Without Meta', 'power-elements' ),
					],
					'condition'   => [
						'peeao_blog_carousel_show_category' => '1',
					],
					'default' => '2'
				]
			);
			$this->end_controls_section();
			/*
			 * Blog Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_post_heading_style',
				[
					'label' => __( 'Post Heading', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_outside_grid',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_post_heading_title_label',
				[
					'label'     => __( 'Title', 'power-elements' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_post_heading_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_title',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_post_heading_title_color',
				[
					'label'     => __( 'Title Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_post_heading_title_margin',
				[
					'label'      => __( 'Title Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_post_heading_title_padding',
				[
					'label'      => __( 'Title Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_post_heading_subtitle_label',
				[
					'label'     => __( 'Sub Title', 'power-elements' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_post_heading_subtitle_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_shortdesc',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_post_heading_subtitle_color',
				[
					'label'     => __( 'Title Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_shortdesc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_post_heading_subtitle_margin',
				[
					'label'      => __( 'Title Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_shortdesc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_post_heading_subtitle_padding',
				[
					'label'      => __( 'Title Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_heading_wrapper .power_shortdesc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_blog_carousel_wrapper_style',
				[
					'label' => __( 'Post Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_blog_carousel_wrapper_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * CONTENT Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_content_style',
				[
					'label' => __( 'Content Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_blog_carousel_content_wrapper_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post_content' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_content_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post_content',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_content_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_content_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_content_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '30',
						'right' => '0',
						'bottom' => '30',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_content_wrapper_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post_content',
				]
			); 
			$this->end_controls_section();
			/*
			 * Category Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_category_style',
				[
					'label'     => __( 'Category', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition'   => [
						'peeao_blog_carousel_show_category' => '1',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_label_options',
				[
					'label'     => __( 'Label', 'power-elements' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_category_label_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_label_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_category_label_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_peeao_blog_carousel_category_label_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_link_options',
				[
					'label'     => __( 'Link', 'power-elements' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_category_link_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_category_link_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_category_link_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_link_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_category_link_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_link_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_link_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_blog_carousel_category_link_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_category_link_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * TITLE Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_title_style',
				[
					'label'     => __( 'Title', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition'   => [
						'peeao_blog_carousel_show_title' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_title_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_title_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => '500',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							'default' => [ 
								'unit' => 'px', 
								'size' => 11 
							]
						],
						'text_transform' => [
							'default' => 'uppercase'
						]
					],
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_blog_carousel_title_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_title_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * IMAGE Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_image_style',
				[
					'label'     => __( 'Featured Image', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition'   => [
						'peeao_blog_carousel_show_image' => '1',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_image_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_img img',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_image_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_image_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_image_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * META Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_meta_style',
				[
					'label'     => __( 'Meta', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_blog_carousel_show_meta' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_meta_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_meta_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_meta_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} {{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_meta_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_meta_icon_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta li i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_meta_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_meta_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_blog_carousel_meta_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_meta_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover a,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * EXCERPT Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_excerpt_style',
				[
					'label'     => __( 'Excerpt', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_blog_carousel_show_excerpt' => '1',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_excerpt_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_excerpt_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_excerpt_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_excerpt_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_excerpt_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * READ MORE Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_read_more_style',
				[
					'label'     => __( 'Read More', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_blog_carousel_show_read_more' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_read_more_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_read_more_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_blog_carousel_read_more_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_control(
				'peeao_blog_carousel_read_more_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_read_more_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button:after' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_read_more_align',
				[
					'label'     => __( 'Alignment', 'power-elements' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => [
						'left'   => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'selectors' => [
						'{{WRAPPER}} .power_blog_button_group' => 'text-align: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_read_more_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_read_more_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_read_more_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_read_more_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_blog_carousel_read_more_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_read_more_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_blog_carousel_read_more_background',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'gradient' ],
					'selector' => '{{WRAPPER}} .power_blog_button:before',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * Nav Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_nav_style_tab',
				[
					'label'     => __( 'Nav', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_blog_carousel_nav' => 'true',
					],
				]
			);

			$this->add_responsive_control(
				'peeao_blog_carousel_nav_typography',
				[
					'label'   => __( 'Nav Icon Size', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'   => [
						'min'  => 1,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 26,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-nav .owl-prev' => 'font-size: {{SIZE}}{{UNIT}}',
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-nav .owl-next' => 'font-size: {{SIZE}}{{UNIT}}',
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_outside_grid_owl_prev' => 'font-size: {{SIZE}}{{UNIT}}',
						'{{WRAPPER}} .power_owl_nav_outside_grid .power_outside_grid_owl_next' => 'font-size: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_vertical_position_spacing',
				[
					'label'   => __( 'Vertical Position', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'   => [
						'min'  => 1,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 50,
						'unit' => '%',
					],
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_side',
					],
					'selectors' => [
						'{{WRAPPER}} .power_owl_nav_side .power_blogcarousel .owl-nav' => 'top: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_prev_spacing',
				[
					'label'   => __( 'Previous arrow spacing', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 40,
						'max'  => 200,
						'step' => 1,
					],
					'default' => [
						'size' => 40,
					],
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_side',
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev' => 'left: -{{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_next_spacing',
				[
					'label'   => __( 'Next arrow spacing', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 40,
						'max'  => 200,
						'step' => 1,
					],
					'default' => [
						'size' => 40,
					],
					'condition'   => [
						'peeao_blog_carousel_nav_style' => 'power_owl_nav_side',
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-next' => 'right: -{{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_nav_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_nav_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev' => 'color: {{VALUE}}',
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-next' => 'color: {{VALUE}}',
						'{{WRAPPER}} .power_outside_grid_owl_prev, .power_outside_grid_owl_next' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-next' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_outside_grid_owl_prev, .power_outside_grid_owl_next' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_nav_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_nav_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '5',
						'right' => '15',
						'bottom' => '5',
						'left' => '15',
						'unit' => 'px',
						'isLinked' => false,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'peeao_blog_carousel_nav_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover ,{{WRAPPER}} .power_outside_grid_owl_prev:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_nav_bg_hover_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_nav_hover_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_nav_hover_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_hover_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_nav_hover_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '5',
						'right' => '15',
						'bottom' => '5',
						'left' => '15',
						'unit' => 'px',
						'isLinked' => false,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel .owl-nav .owl-prev:hover, {{WRAPPER}} .power_blogcarousel .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * DOTS Style
			 */
			$this->start_controls_section(
				'peeao_blog_carousel_dots_style_tab',
				[
					'label'     => __( 'Dots', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_blog_carousel_dots' => 'true',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_spacing',
				[
					'label'   => __( 'Spacing', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 5,
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot' => 'margin: 0 {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_blog_carousel_dots_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_blog_carousel_dots_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_height',
				[
					'label'   => __( 'Dot Height', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 7,
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_width',
				[
					'label'   => __( 'Dot Width', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 7,
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_dots_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_dots_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_dots_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_dots_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_blog_carousel_dots_active_tab',
				[
					'label' => __( 'Active', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_height_active',
				[
					'label'   => __( 'Dot Height', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 7,
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_width_active',
				[
					'label'   => __( 'Dot Width', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'default' => [
						'size' => 7,
					],
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_control(
				'peeao_blog_carousel_dots_active_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_blog_carousel_dots_active_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot.active span',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_blog_carousel_dots_active_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot.active span',
				]
			);
			$this->add_responsive_control(
				'peeao_blog_carousel_dots_active_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blogcarousel.owl-theme .owl-dots .owl-dot.active span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			
			/**
			 * Setup the post arguments.
			 */
			
			$post_args  = Partials::get_post_settings( $settings );
			$query_args = Partials::get_query_args( 'powerpost', $settings, 'blog_carousel');
			$query_args = array_merge( $query_args, $post_args, $settings );
			
			if ( isset( $query_args['tax_query'] ) ) {
				$tax_query = $query_args['tax_query'];
			}
			/**
			 * Get posts from database. 
			 */
			$posts = Partials::load_blog_posts( $query_args , 'blogcarousel');
			/**
			 * Set total posts.
			 */
			//$total_post = $posts['count'];

			$peeao_blog_carousel_nav = $settings['peeao_blog_carousel_nav_style'] == 'power_owl_nav_outside_grid' ?
				'false' : $settings['peeao_blog_carousel_nav'] ;
			?>
			<div class="peeao-wrapper">
				<div id="power-post-grid-<?php echo esc_attr( $this->get_id() ); ?>"
					class="power-post-grid-container <?php echo esc_attr($settings['peeao_blog_carousel_nav_style']); ?>">
					
					<?php if($settings['peeao_blog_carousel_nav_style'] == 'power_owl_nav_outside_grid'): ?>
						<div class="power_heading_wrapper">
							<h2 class="power_title"><?php echo Utils::kses( $settings['peeao_blog_carousel_heading_text'] ); ?></h2>
							<p class="power_shortdesc"><?php echo Utils::kses( $settings['peeao_blog_carousel_heading_desc'] ); ?></p>
							<div class="power_outside_grid_owl_nav">
								<button type="button" role="presentation" class="power_outside_grid_owl_prev">
									<span aria-label="Previous">‹</span>
								</button>
								<button type="button" role="presentation" class="power_outside_grid_owl_next">
									<span aria-label="Next">›</span>
								</button>
							</div>
						</div>  
					<?php endif; ?>
 
					<div class="owl-carousel owl-theme power_blogcarousel"
						data-owl-carousel='{
							"items": <?php echo esc_attr($settings['peeao_blog_carousel_item'])?>, 
							"margin": <?php echo esc_attr($settings['peeao_blog_carousel_margin']['size'])?>, 
							"padding": <?php echo esc_attr($settings['peeao_blog_carousel_padding']['size'])?>, 
							"autoplay": <?php echo esc_attr($settings['peeao_blog_carousel_autoplay'])?>, 
							"responsiveClass": <?php echo esc_attr($settings['peeao_blog_carousel_responsive_class'])?>, 
							"dots": <?php echo esc_attr($settings['peeao_blog_carousel_dots'])?>, 
							"nav": <?php echo esc_attr($peeao_blog_carousel_nav)?>,
							"responsive":{ "0" :{ "items": <?php echo esc_attr($settings['peeao_blog_carousel_item_mobile'])?>}, 
							"540" :{ "items": <?php echo esc_attr($settings['peeao_blog_carousel_item_mobile'])?> }, 
							"860" :{ "items" : <?php echo esc_attr($settings['peeao_blog_carousel_item'])?> } , 
							"1000":{ "items" : <?php echo esc_attr($settings['peeao_blog_carousel_item'])?> }}}'>
						<?php
							if ( ! empty( $posts['content'] ) ) {
								echo $posts['content'];
							} else {
								echo '<p class="text-danger">' . esc_html__( 'Something went wrong.', 'power-elements' ) . '</p>';
							}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		protected function _content_template() {}
	}