<?php
namespace PowerElements;

use \Elementor\Icons_Manager;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Video extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_video';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Video', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-youtube';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		protected function _register_controls() {

			$this->start_controls_section(
				'peeao_video_popup_content_section',
				[
					'label' => esc_html__( 'Video', 'power-elements' ),
					'tab' => Controls_Manager::TAB_CONTENT,
				]
			);
	
			$this->add_control(
				'peeao_video_popup_button_style',
				[
					'label' => esc_html__( 'Button Style', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'icon',
					'options' => [
						'text'  => esc_html__( 'Text', 'power-elements' ),
						'icon' => esc_html__( 'Icon', 'power-elements' ),
						'both' => esc_html__( 'Both', 'power-elements' ),
					],
				]
			);
	
			 $this->add_control(
				'peeao_video_popup_button_title',
				[
					'label' =>esc_html__( 'Button Title', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
					'placeholder' =>esc_html__( 'Play Video', 'power-elements' ),
					'default' =>esc_html__( 'Play Video', 'power-elements' ),
					'condition' => [
						'peeao_video_popup_button_style' => ['text', 'both']
					],
				]
			 );
	
			 $this->add_control(
				'peeao_video_popup_button_icons',
				[
					'label' =>esc_html__( 'Button Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-play',
						'library' => 'peeaoicons',
					],
					'label_block' => true,
					'condition' => [
						'peeao_video_popup_button_style' 		=> ['icon', 'both'],
					]
				]
			 );
			 $this->add_control(
				'peeao_video_popup_icon_align',
				[
					'label' =>esc_html__( 'Icon Position', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'before',
					'options' => [
						'before' =>esc_html__( 'Before', 'power-elements' ),
						'after' =>esc_html__( 'After', 'power-elements' ),
					],
					'condition' => [
						'peeao_video_popup_button_style' => 'both',
					]
				]
			);
	
			 $this->add_control(
				'peeao_video_popup_video_type',
				[
					'label'     => esc_html__( 'Video Type', 'power-elements' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'youtube',
					'options'   => [
						  'youtube'=> esc_html__( 'youtube', 'power-elements' ),
						  'vimeo'=> esc_html__( 'vimeo', 'power-elements' ),
					]
				]
			);
	
			$this->add_control(
				'peeao_video_popup_url',
				[
					'label' => esc_html__( 'URL to embed', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'input_type' => 'url',
					'placeholder' => esc_html( 'https://www.youtube.com/watch?v=668nUCeBHyY' ),
					'default' => esc_html('https://www.youtube.com/watch?v=668nUCeBHyY'),
				]
			);
	
			//video option
			$this->add_control(
				'peeao_video_popup_start_time',
				[
					'label' => esc_html__( 'Start Time', 'power-elements' ),
					'type' => Controls_Manager::NUMBER,
					'input_type' => 'number',
					'placeholder' =>  '',
					'default' => '0',
					'condition' => ['peeao_video_popup_video_type' => 'youtube' ]
				]
			);
	
			$this->add_control(
				'peeao_video_popup_end_time',
				[
					'label' => esc_html__( 'End TIme', 'power-elements' ),
					'type' => Controls_Manager::NUMBER,
					'input_type' => 'number',
					'placeholder' => '',
					'default' => '',
					'condition' => ['peeao_video_popup_video_type' => 'youtube']
				]
			);
			$this->add_control(
				'peeao_video_popup_auto_play',
				[
					'label' => esc_html__( 'Auto Play', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'yes',
				]
			);
	
			$this->add_control(
				'peeao_video_popup_video_mute',
				[
					'label' => esc_html__( 'Mute', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
				]
			);
	
			$this->add_control(
				'peeao_video_popup_video_loop',
				[
					'label' => esc_html__( 'Loop', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
				]
			);
	
			$this->add_control(
				'peeao_video_popup_video_player_control',
				[
					'label' => esc_html__( 'Player Control', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
				]
			);
	
		   $this->add_control(
				'peeao_video_popup_video_intro_title',
				[
					'label' => esc_html__( 'Intro Title', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
					'condition' => ['peeao_video_popup_video_type' => 'vimeo']
				]
			);
	
			$this->add_control(
				'peeao_video_popup_video_intro_portrait',
				[
					'label' => esc_html__( 'Intro Portrait', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
					'condition' => ['peeao_video_popup_video_type' => 'vimeo']
				]
			);
	
			$this->add_control(
				'peeao_video_popup_video_intro_byline',
				[
					'label' => esc_html__( 'Intro Byline', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => '1',
					'default' => 'no',
					'condition' => ['peeao_video_popup_video_type' => 'vimeo']
				]
			);
			//video option
	
			$this->end_controls_section();
	
			$this->start_controls_section(
				'peeao_video_popup_style_section',
				[
					'label' => esc_html__( 'Style', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_title_align', [
					'label'			 =>esc_html__( 'Alignment', 'power-elements' ),
					'type'			 => Controls_Manager::CHOOSE,
					'options'		 => [
	
						'left'		 => [
							'title'	 =>esc_html__( 'Left', 'power-elements' ),
							'icon'	 => 'fa fa-align-left',
						],
						'center'	 => [
							'title'	 =>esc_html__( 'Center', 'power-elements' ),
							'icon'	 => 'fa fa-align-center',
						],
						'right'		 => [
							'title'	 =>esc_html__( 'Right', 'power-elements' ),
							'icon'	 => 'fa fa-align-right',
						],
						'justify'	 => [
							'title'	 =>esc_html__( 'Justified', 'power-elements' ),
							'icon'	 => 'fa fa-align-justify',
						],
					],
					'default'		 => 'center',
					'selectors' => [
						'{{WRAPPER}} .power-video-content' => 'text-align: {{VALUE}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_text_padding',
				[
					'label' =>esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 1,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_video_popup_btn_typography',
					'label' =>esc_html__( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_video_popup_btn',
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_btn_width',
				[
					'label' => esc_html__( 'Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 30,
							'max' => 200,
							'step' => 1,
						],
						'%' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 60,
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_btn_height',
				[
					'label' => esc_html__( 'Height', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 30,
							'max' => 200,
							'step' => 1,
						],
						'%' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 60,
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_btn_line_height',
				[
					'label' => esc_html__( 'Line height', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 200,
							'step' => 1,
						],
						'%' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 45,
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn' => 'line-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			
			$this->add_responsive_control(
				'peeao_video_popup_btn_border_radius',
				[
					'label' =>esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px'],
					'default' => [
						'top' => '',
						'right' => '',
						'bottom' => '' ,
						'left' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn, {{WRAPPER}} .power_video_popup_btn:before' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'peeao_video_popup_btn_animation_color',
				[
					'label' =>esc_html__( 'Animation Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper a.power_video_popup_btn:before' => 'background: {{VALUE}};',
					],
				]
			);

			$this->start_controls_tabs( 'peeao_video_popup_button_style_tabs' );
	
			$this->start_controls_tab(
				'peeao_video_popup_button_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_video_popup_btn_text_color',
				[
					'label' =>esc_html__( 'Text Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#ffffff',
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				array(
					'name'     => 'peeao_video_popup_btn_bg_color',
					'default' => '',
					'selector' => '{{WRAPPER}} .power_video_popup_btn',
				)
			);
	
			$this->add_group_control(
				Group_Control_Border::get_type(),
				array(
					'name'     => 'peeao_video_popup_btn_border',
					'default' => '',
					'selector' => '{{WRAPPER}} .power_video_popup_btn',
				)
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_video_popup_btn_box_shadow',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_video_popup_btn',
				]
			);
	
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'peeao_video_popup_btn_text_shadow',
					'label' => esc_html__( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_video_popup_btn',
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_video_popup_btn_tab_button_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_video_popup_btn_hover_color',
				[
					'label' =>esc_html__( 'Text Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#ffffff',
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn:hover' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Background::get_type(),
				array(
					'name'     => 'peeao_video_popup_btn_bg_hover_color',
					'default' => '',
					'selector' => '{{WRAPPER}} .power_video_popup_btn:hover',
				)
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				array(
					'name'     => 'peeao_video_popup_btn_border_hover',
					'default' => '',
					'selector' => '{{WRAPPER}} .power_video_popup_btn:hover',
				)
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_video_popup_btn_box_shadow_hover',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_video_popup_btn:hover',
				]
			);
	
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'peeao_video_popup_btn_text_shadow_hover',
					'label' => esc_html__( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_video_popup_btn:hover',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
	
			$this->start_controls_section(
				'peeao_video_popup_icon_style',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_video_popup_button_style' => ['both', 'icon']
					]
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_icon_padding_right',
				[
					'label' => esc_html__( 'Padding Right', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 200,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 5,
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn > i' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_video_popup_icon_padding_left',
				[
					'label' => esc_html__( 'Padding Left', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 200,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 5,
					],
					'selectors' => [
						'{{WRAPPER}} .power_video_popup_btn > i' => 'padding-left: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->end_controls_section();
		}
	
		protected function render( ) {
			$settings = $this->get_settings();
			extract($settings);
			$peeao_video_popup_url = $peeao_video_popup_url."?autoplay={$peeao_video_popup_auto_play}&loop={$peeao_video_popup_video_loop}&controls={$peeao_video_popup_video_player_control}&mute={$peeao_video_popup_video_mute}&start={$peeao_video_popup_start_time}&end={$peeao_video_popup_end_time}&version=3";
			?>
			<div class="peeao-wrapper" >
				<div class="power-video-content"> 
					<a href="<?php echo esc_url($peeao_video_popup_url); ?>" class="power_video_popup power_video_popup_btn <?php echo esc_attr($peeao_video_popup_button_style == 'icon' ? 'power_icon_button': '') ?>">
						<?php if($peeao_video_popup_button_style == 'text'): ?>
							<span><?php echo esc_html($peeao_video_popup_button_title); ?></span>
						<?php endif; ?>
						<?php if($peeao_video_popup_button_style == 'icon' && $peeao_video_popup_button_icons != ''): ?>
							<?php Icons_Manager::render_icon( $settings['peeao_video_popup_button_icons'], [ 'aria-hidden' => 'true' ] ); ?>
						<?php endif; ?>
						<?php if($peeao_video_popup_button_style == 'both'): ?>
							<?php if($peeao_video_popup_icon_align == 'before' && $peeao_video_popup_button_icons != '') : ?>
							<?php Icons_Manager::render_icon( $settings['peeao_video_popup_button_icons'], [ 'aria-hidden' => 'true' ] ); ?>
							<?php endif; ?>
							<span><?php echo esc_html($peeao_video_popup_button_title); ?></span>
							<?php if($peeao_video_popup_icon_align == 'after' && $peeao_video_popup_button_icons != '') : ?>
							<?php Icons_Manager::render_icon( $settings['peeao_video_popup_button_icons'], [ 'aria-hidden' => 'true' ] ); ?>
							<?php endif; ?>
						<?php endif; ?>
					</a>
				</div>
			</div>
			<?php
		}
	
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}