<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social share widget.
	 *
	 * Elementor widget that displays a social share with the ability to control every
	 * aspect of the social share design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Social_Share extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social share widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_social_share';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social share widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Social Share', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social share widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon. 
		 */
		public function get_icon() {
			return 'eicon-social-icons';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social share widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social share widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_social_share',
				[
					'label' => __( 'Social Share', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_view',
				[
					'label'   => __( 'View', 'power-elements' ),
					'type'    => Controls_Manager::HIDDEN,
					'default' => 'traditional',
				]
			);
			$this->add_control(
				'peeao_social_share_style',
				[
					'label'   => __( 'Type', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'only_icon',
					'options' => [
						'only_icon'   => __( 'Show Only Icon', 'power-elements' ),
						'only_text'   => __( 'Show Only Text', 'power-elements' ),
						'both' => __( 'Show Both', 'power-elements' ),
					],
				]
			);
			
			$this->add_control(
				'peeao_social_share_facebook_show',
				[
					'label' => esc_html__('Facebook Show', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_facebook_text',
				[
					'label'       => __( 'Facebook Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Facebook', 'power-elements' ),
					'placeholder' => __( 'Facebook', 'power-elements' ),
					'condition' => [
						'peeao_social_share_facebook_show' =>'yes'
					]
				]
			);
			$this->add_control(
				'peeao_social_share_facebook_icon',
				[
					'label' => esc_html__( 'Facebook Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fa fa-facebook',
						'library' => '',
					],
					'condition' => [
						'peeao_social_share_facebook_show' =>'yes'
					]
				]
			);
			$this->add_control(
				'peeao_social_share_twitter_show',
				[
					'label' => esc_html__('Twitter Show', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_twitter_text',
				[
					'label'       => __( 'Twitter Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Twitter', 'power-elements' ),
					'placeholder' => __( 'Twitter', 'power-elements' ),
					'condition' => [
						'peeao_social_share_twitter_show' =>'yes'
					]
				]
			);
			$this->add_control(
				'peeao_social_share_twitter_icon',
				[
					'label' => esc_html__( 'Twitter Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fa fa-twitter',
						'library' => '',
					],
					'condition' => [
						'peeao_social_share_twitter_show' =>'yes'
					]
				]
			);
			$this->add_control(
				'peeao_social_share_linkedin_show',
				[
					'label' => esc_html__('Linkedin Show', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_linkedin_text',
				[
					'label'       => __( 'Linkedin Text', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Linkedin', 'power-elements' ),
					'placeholder' => __( 'Linkedin', 'power-elements' ),
					'condition' => [
						'peeao_social_share_linkedin_show' =>'yes'
					]
				]
			);
			$this->add_control(
				'peeao_social_share_linkedin_icon',
				[
					'label' => esc_html__( 'Linkedin Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fa fa-linkedin',
						'library' => '',
					],
					'condition' => [
						'peeao_social_share_linkedin_show' =>'yes'
					]
				]
			);
			
			
			$this->add_responsive_control(
				'peeao_social_share_align',
				[
					'label'   => __( 'Alignment', 'power-elements' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'text-left'    => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'text-center'  => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'text-right'   => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						],
						'text-justify' => [
							'title' => __( 'Justified', 'power-elements' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'default' => '',
				]
			);
		
			$this->end_controls_section();
			
			$this->start_controls_section(
				'peeao_social_share_item_wrapper_section_tab',
				[
					'label' => __( 'Item Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'tabs_social_share_item_wrapper'
			);
	
			$this->start_controls_tab(
				'tabs_social_share_item_wrapper_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_item_wrapper_border',
					'selector'  => '{{WRAPPER}} .power_social_share_icon',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'peeao_social_share_icon_background_color',
				[
					'label'     => __( 'BG Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  a.power_social_share_icon' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_item_wrapper_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_item_wrapper_box_shadow',
					'selector' => '{{WRAPPER}} .power_social_share_icon',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'tabs_social_share_item_wrapper_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_social_share_icon_background_color_hover',
				[
					'label'     => __( 'BG Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  a.power_social_share_icon:hover' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_item_wrapper_border_hover',
					'selector'  => '{{WRAPPER}} a.power_social_share_icon:hover',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_social_share_item_wrapper_hover_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_item_wrapper_hover_social_share_box_shadow',
					'selector' => '{{WRAPPER}} a.power_social_share_icon:hover',
				]
			);
	
			$this->end_controls_tab();
			$this->end_controls_tabs();


			$this->add_responsive_control(
				'peeao_social_share_item_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_item_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
			
			$this->start_controls_section(
				'peeao_social_share_icon_section_tab',
				[
					'label' => __( 'Social Share Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'tabs_social_share_icon'
			);
			$this->start_controls_tab(
				'tabs_social_share_icon_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_icon_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} a.power_social_share_icon i' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_icon_border',
					'selector'  => '{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_icon_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_icon_box_shadow',
					'selector' => '{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'tabs_social_share_icon_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_social_share_icon_hover_color',
				[
					'label'     => __( 'Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} a.power_social_share_icon:hover i' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'peeao_social_share_icon_background_hover_color',
				[
					'label'     => __( 'BG Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_class i' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_icon_border_hover',
					'selector'  => '{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_class i, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_icon_border_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_class i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_icon_box_shadow_hover',
					'selector' => '{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_class i, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();


			$this->add_control(
				'peeao_social_share_icon_size',
				[
					'label'     => __( 'Icon Size', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 60,
							'step' => 1,
						],
						'em'  => [
							'min' => 0,
							'max' => 60,
							'step' => 1,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 24,
					],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_icon_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_icon_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_class i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_social_share_text_section_tab',
				[
					'label' => __( 'Social Share Text', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_social_share_text_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name',
				]
			);

			$this->start_controls_tabs(
				'tabs_social_share_text'
			);
			$this->start_controls_tab(
				'tabs_social_share_text_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_social_share_text_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_text_border',
					'selector'  => '{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_text_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_text_box_shadow',
					'selector' => '{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_name',
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'tabs_social_share_text_hover',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_social_share_hover_text_color',
				[
					'label'     => __( 'Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_name' => 'color: {{VALUE}};',
						'{{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_name' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_social_share_text_border_hover',
					'selector'  => '{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_name, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_text_border_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_social_share_text_box_shadow_hover',
					'selector' => '{{WRAPPER}} a.power_social_share_icon:hover .power_social_share_icon_name, {{WRAPPER}} a.power_social_share_icon:focus .power_social_share_icon_class i',
				]
			);
	
			$this->end_controls_tab();
			$this->end_controls_tabs();




			$this->add_responsive_control(
				'peeao_social_share_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_social_share_text_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_social_share_icon .power_social_share_icon_name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social share widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			extract($settings);
			
			if( $peeao_social_share_style == 'only_text'){
				$class = 'power_social_share_icon_onlytext';
			}elseif($peeao_social_share_style == 'both'){
				$class = 'power_social_share_icon_showtext';
			}elseif($peeao_social_share_style == 'only_icon'){
				$class = 'power_social_share_icon_hidetext';
			}

			$this->add_render_attribute( 'wrapper', 'class', [
				'power_social_share_icon_wrapper',
				'power_social_share_icon_rounded',
				$class,
				$peeao_social_share_align
			] );
			
			$facebook_text = 
				$peeao_social_share_style != 'only_icon' ? 
				'<span class="power_social_share_icon_name">' . esc_attr( $peeao_social_share_facebook_text ) . '</span>' : '';
			$twitter_text = 
				$peeao_social_share_style != 'only_icon' ? 
				'<span class="power_social_share_icon_name">' . esc_attr( $peeao_social_share_twitter_text ) . '</span>' : '';
			$linkedin_text = 
				$peeao_social_share_style != 'only_icon' ? 
				'<span class="power_social_share_icon_name">' . esc_attr( $peeao_social_share_linkedin_text ) . '</span>' : '';
			?>
			<div class="peeao-wrapper">
				<ul <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
					<?php if($peeao_social_share_facebook_show == 'yes'):?>
					<li><a  class="power_social_share_icon" href="https://www.facebook.com/share.php?u=<?php the_permalink();?>">
						<?php  if($peeao_social_share_style != 'only_text'): ?>
							<span class="power_social_share_icon_class"><i class="<?php echo esc_attr( $peeao_social_share_facebook_icon['value'] ); ?>"></i></span>
						<?php endif; ?><?php echo $facebook_text; ?>
					</a></li><?php endif; ?>
					
					<?php if($peeao_social_share_twitter_show == 'yes'):?>
					<li><a class="power_social_share_icon" href="http://twitter.com/intent/tweet?status=<?php the_title() ?>+<?php the_permalink();?>">
						<?php  if($peeao_social_share_style != 'only_text'): ?>
							<span class="power_social_share_icon_class"><i class="<?php echo esc_attr( $peeao_social_share_twitter_icon['value'] ); ?>"></i></span>
						<?php endif; ?><?php echo $twitter_text; ?>
					</a></li><?php endif; ?>
					
					<?php if($peeao_social_share_linkedin_show == 'yes'):?>
					<li><a class="power_social_share_icon" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo the_permalink(); ?>&title=<?php the_title(); ?>&source=<?php echo home_url('/');?>">
						<?php  if($peeao_social_share_style != 'only_text'): ?>
							<span class="power_social_share_icon_class"><i class="<?php echo esc_attr( $peeao_social_share_linkedin_icon['value'] ); ?>"></i></span>
						<?php endif; ?><?php echo $linkedin_text; ?>
					</a></li><?php endif; ?>

				</ul>
			</div>

			<?php

		}
		
		/**
		 * Render social share widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}