<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Repeater;
use \Elementor\Icons_Manager;
use \Elementor\Widget_Base;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Control_Media;



	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Price_Table extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_price_table';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Price Table', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-price-table';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */

		protected function _register_controls() {

			$this->start_controls_section(
				'peeao_pricing_table_pricing_plan',
				[
					'label' => esc_html__('Header', 'power-elements'),
				]
			);
	 
			$this->add_control(
				'peeao_pricing_table_title', [
					'type' => Controls_Manager::TEXT,
					'label' => esc_html__('Table Title', 'power-elements'),
					'default'   =>  esc_html__('HOSTING SERVICE','power-elements'),
					'label_block' => true,
					
				]
			);
			$this->add_control(
				'peeao_pricing_table_title_size',
				[
					'label' => esc_html__( 'Title HTML Tag', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6',
						'div' => 'div',
						'span' => 'span',
						'p' => 'p',
					],
					'default' => 'h3',
					'separator' => 'after',
				]
			);
			$this->add_control(
				'peeao_pricing_table_subtitle', [
					'type' => Controls_Manager::TEXTAREA,
					'label' => esc_html__('Table Subtitle', 'power-elements'),
					'default'   =>  esc_html__('All the elements in this are customizable','power-elements'),
					'label_block' => true,
					
				]
			);
			$this->add_control(
				'peeao_pricing_table_icon_type',
				[
					'label' => esc_html__( 'Header Icon or Image? ', 'power-elements' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'none' => [
							'title' => esc_html__( 'None', 'power-elements' ),
							'icon' => 'fa fa-stop-circle',
						],
						'icon' => [
							'title' => esc_html__( 'Icon', 'power-elements' ),
							'icon' => 'fa fa-star',
						],
						'image' => [
							'title' => esc_html__( 'Image', 'power-elements' ),
							'icon' => 'fa fa-image',
						],
					],
					'default' => 'none',
					'separator' => 'before',
					'toggle' => true,
				]
			);
			
			$this->add_control(
				'peeao_pricing_table_icons__switch',
				[
					'label' => esc_html__('Add icon? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_icon_type' => 'icon',
					]
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_icons',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fab fa-amazon',
						'library' => 'brands',
					],
					'condition' => [
						'peeao_pricing_table_icon_type' => 'icon',
						'peeao_pricing_table_icons__switch'	=> 'yes'
					]
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_image',
				[
					'label' => esc_html__( 'Choose Image', 'power-elements' ),
					'type' => Controls_Manager::MEDIA,
					
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_pricing_table_icon_type' => 'image',
					],
					
				]
			);
	
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name' => 'peeao_pricing_table_thumbnail',
					'default' => 'thumbnail',
					'separator' => 'none',
					'condition' => [
						'peeao_pricing_table_icon_type' => 'image',
					]
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_price_tag_style',
				[
					'label' => esc_html__( 'Price Tag', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_price_tag_layout',
				[
					'label' => esc_html__( 'Tag Layout', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'plain' => esc_html__('Plain','power-elements'),
						'circle' => esc_html__('Circle','power-elements'),
					],
					'default' => 'plain',
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_price_tag_animation',
				[
					'label' => esc_html__('Allow Pulse Animation? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_heading_price_tag_layout' => 'circle',
					]
				]
			);

			$this->add_control(
				'peeao_pricing_table_currency_icon', [
					'type' => Controls_Manager::TEXT,
					'label' => esc_html__('Currency', 'power-elements'),
					'default'   => '$',
					
				]
			);
			$this->add_control(
				'peeao_pricing_table_price', [
					'type' => Controls_Manager::TEXT,
					'label' => esc_html__('Price', 'power-elements'),
					'default'   => esc_html__('90', 'power-elements'),
					
				]
			);
			$this->add_control(
				'peeao_pricing_table_duration', [
					'type' => Controls_Manager::TEXT,
					'label' => esc_html__('Duration', 'power-elements'),
					'default'   => esc_html__('Per Month', 'power-elements'),
					
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_seperator_style',
				[
					'label' => esc_html__( 'Seperator', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'peeao_pricing_table_seperator__switch',
				[
					'label' => esc_html__('Show Seperator Icon? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_pricing_table_seperator_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao-ios-globe',
						'library' => 'peeaoicons',
					],
					'condition'   => [
						'peeao_pricing_table_seperator__switch' => 'yes',
					],
				]
			);
			$this->add_control(
				'peeao_pricing_table_seperator_before_after__switch',
				[
					'label' => esc_html__('Show Seperator Border? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_seperator__switch' => 'yes',
					]
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_pricing_table_features_tab',
				[
					'label' =>esc_html__('Features', 'power-elements'),
				]
			);
			$this->add_control(
				'peeao_pricing_table_content_style',
				[
					'label' => esc_html__( 'Features style', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'list',
					'options' => [
						'paragraph'  => esc_html__( 'Paragraph', 'power-elements' ),
						'list' => esc_html__( 'List', 'power-elements' ),
					],
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_content', [
					'type' => Controls_Manager::TEXTAREA,
					'label' => esc_html__('Table Content', 'power-elements'),
					'label_block' => true,
					'default' => esc_html__('Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam','power-elements'),
					'condition' => [
						'peeao_pricing_table_content_style' => 'paragraph',
					],
					
				]
			);
			$repeater = new Repeater();
	
			$repeater->add_control(
				'peeao_pricing_table_list', [
					'label' => esc_html__('List text', 'power-elements'),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( '15 Email Account' , 'power-elements' ),
					'label_block' => true,
					
				]
			);
	
			$repeater->add_control(
				'peeao_pricing_table_check_icons', [
					'label' =>esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
					],
					'label_block' => true,
				]
			);
	
			$repeater->add_control(
				'peeao_pricing_table_list_icon_color', [
					'label' =>esc_html__( 'Icon Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .power_elements-single-pricing .power_elements-pricing-lists {{CURRENT_ITEM}} i' => 'color: {{VALUE}};',
					],
				]
			);
	
			$repeater->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_list_content_typography_group',
					'label' =>esc_html__( 'Icon Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_elements-single-pricing .power_elements-pricing-lists {{CURRENT_ITEM}} i',
				]
			);
			$this->add_control(
				'peeao_pricing_table_content_repeater',
				[
					'label' => esc_html__( 'Pricing Content List', 'power-elements' ),
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'title_field' => '{{peeao_pricing_table_list}}',
					'default' => [
						[
							'item' => esc_html__( '1 Free Websites', 'power-elements' ),
							'check_icon' => '',
						],
						[
							'item' => esc_html__( '2000 GB SSD storage', 'power-elements' ),
							'check_icon' => '',
						],
						[
							'item' => esc_html__( '30 Databases', 'power-elements' ),
							'check_icon' => '',
						],
						[
							'item' => esc_html__( 'Malware Detect', 'power-elements' ),
							'check_icon' => '',
						],
					],
					'title_field' => '{{{ peeao_pricing_table_list }}}',
					'condition' => [
						'peeao_pricing_table_content_style' => 'list',
					],
				]
			);
	
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_pricing_table_button_style_tab',
				[
					'label' =>esc_html__('Button', 'power-elements'),
				]
			);
			$this->add_control(
				'peeao_pricing_table_btn_text',
				[
					'label' =>esc_html__( 'Label', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' =>esc_html__( 'Learn more ', 'power-elements' ),
					'placeholder' =>esc_html__( 'Learn more ', 'power-elements' ),
					
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_btn_link',
				[
					'label' =>esc_html__( 'Link', 'power-elements' ),
					'type' => Controls_Manager::URL,
					'placeholder' =>esc_url('http://your-link.com'),
					'default' => [
						'url' => '#',
					],
					
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_btn_icons__switch',
				[
					'label' => esc_html__('Add icon? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_btn_icons',
				[
					'label' =>esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
					],
					'label_block' => true,
					'condition'		=> [
						'peeao_pricing_table_btn_icons__switch'	=> 'yes'
					]
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_icon_align',
				[
					'label' =>esc_html__( 'Icon Position', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'left',
					'options' => [
						'left' =>esc_html__( 'Before', 'power-elements' ),
						'right' =>esc_html__( 'After', 'power-elements' ),
					],
					'condition' => [
						'peeao_pricing_table_btn_icons__switch'	=> 'yes'
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_icon_spacing',
				[
					'label' => esc_html__( 'Icon Spacing', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['px', '%'],
					'default' => [
						'size' => 10,
						'unit' => 'px',
					],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a.power-pricing-btn-icon-pos-right i' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a.power-pricing-btn-icon-pos-left i' => 'margin-right: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'peeao_pricing_table_btn_icons__switch'	=> 'yes'
					],
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_button_class',
				[
					'label' => esc_html__( 'Class', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'placeholder' => esc_html__( 'Class Name', 'power-elements' ),
				]
			);
	
			$this->end_controls_section();
	
	
	//Body style start
	$this->start_controls_section(
		'peeao_pricing_table_section_body_style',
		[
			'label' =>esc_html__( 'Wrapper', 'power-elements' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
	$this->start_controls_tabs( 'peeao_pricing_table_body_wrapper_style' );

	$this->start_controls_tab(
		'peeao_pricing_table_body_wrapper_normal',
		[
			'label' =>esc_html__( 'Normal', 'power-elements' ),
		]
	);

	$this->add_group_control(
		Group_Control_Background::get_type(),
		array(
			'name'     => 'peeao_pricing_table_pricing_body_bg_sp',
			'default' => '',
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table',
		)
	);
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'peeao_pricing_table_body_border_group',
			'label' => esc_html__( 'Border', 'power-elements' ),
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table',
		]
	);
	$this->add_responsive_control(
		'peeao_pricing_table_body_border_radius',
		[
			'label' => esc_html__( 'Border Radius', 'power-elements' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$this->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'peeao_pricing_table_body_box_shadow_group',
			'label' => esc_html__( 'Box Shadow', 'power-elements' ),
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table',
		]
	);
	$this->end_controls_tab();

	$this->start_controls_tab(
		'peeao_pricing_table_body_wrapper_hover',
		[
			'label' =>esc_html__( 'Hover', 'power-elements' ),
		]
	);

	$this->add_group_control(
		Group_Control_Background::get_type(),
		array(
			'name'     => 'peeao_pricing_table_pricing_body_bg_sp_hover',
			'default' => '',
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table:hover',
		)
	);
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'peeao_pricing_table_body_border_group_hover',
			'label' => esc_html__( 'Border', 'power-elements' ),
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table:hover',
		]
	);
	$this->add_responsive_control(
		'peeao_pricing_table_body_border_radius_hover',
		[
			'label' => esc_html__( 'Border Radius', 'power-elements' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$this->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'peeao_pricing_table_body_box_shadow_group_hover',
			'label' => esc_html__( 'Box Shadow', 'power-elements' ),
			'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table:hover',
		]
	);
	$this->end_controls_tab();
	$this->end_controls_tabs();
	
	$this->add_responsive_control(
		'peeao_pricing_table_pricing_content_align',
		[
			'label' =>esc_html__( 'Alignment', 'power-elements' ),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'left'    => [
					'title' =>esc_html__( 'Left', 'power-elements' ),
					'icon' => 'fa fa-align-left',
				],
				'center' => [
					'title' =>esc_html__( 'Center', 'power-elements' ),
					'icon' => 'fa fa-align-center',
				],
				'right' => [
					'title' =>esc_html__( 'Right', 'power-elements' ),
					'icon' => 'fa fa-align-right',
				],
			],
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table' => 'text-align: {{VALUE}};'
			],
			'default' => 'center',
		]
	);
	$this->add_responsive_control(
		'peeao_pricing_table_pricing_content_padding',
		[
			'label' =>esc_html__( 'Padding', 'power-elements' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$this->end_controls_section();

		//Heading wrapper style start
		$this->start_controls_section(
			'peeao_pricing_table_section_heading_style',
			[
				'label' =>esc_html__( 'Heading Wrapper', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'peeao_pricing_table_heading_wrapper_style' );
	
		$this->start_controls_tab(
			'peeao_pricing_table_heading_wrapper_normal',
			[
				'label' =>esc_html__( 'Normal', 'power-elements' ),
			]
		);
	
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'peeao_pricing_table_pricing_heading_bg_sp',
				'default' => '',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading',
			)
		);

		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'peeao_pricing_table_heading_wrapper_hover',
			[
				'label' =>esc_html__( 'Hover', 'power-elements' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'peeao_pricing_table_pricing_heading_bg_sp_hover',
				'default' => '',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table:hover  .power-price-heading',
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
	
		$this->add_responsive_control(
			'peeao_pricing_table_pricing_heading_padding',
			[
				'label' =>esc_html__( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

			//Price Title style start
			$this->start_controls_section(
				'speeao_pricing_table_ection_title_style',
				[
					'label' =>esc_html__( 'Table Title', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);
			
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_title_style' );
	
			$this->start_controls_tab(
				'peeao_pricing_table_tab_title_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_pricing_table_title_text_color',
				[
					'label' =>esc_html__( 'Title Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_pricing_table_tab_title_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_pricing_table_title_hover_color',
				[
					'label' =>esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-heading .power_elements-pricing-title' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_title_typography_group', 
					'label' =>esc_html__( 'Title Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => 'bold',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 12 ] ]
						],
						'text_transform' => [
							'default' => 'uppercase'
						]
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_title_text_padding',
				[
					'label' =>esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_title_wraper_margin',
				[
					'label' =>esc_html__( 'Margin', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_pricing_table_titlehr12',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_title_border_style',
				[
					'label' => esc_html_x( 'Border Type', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'' => esc_html__( 'None', 'power-elements' ),
						'solid' => esc_html_x( 'Solid', 'Border Control', 'power-elements' ),
						'double' => esc_html_x( 'Double', 'Border Control', 'power-elements' ),
						'dotted' => esc_html_x( 'Dotted', 'Border Control', 'power-elements' ),
						'dashed' => esc_html_x( 'Dashed', 'Border Control', 'power-elements' ),
						'groove' => esc_html_x( 'Groove', 'Border Control', 'power-elements' ),
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'border-style: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_title_border_dimensions',
				[
					'label' => esc_html_x( 'Border Width', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'peeao_pricing_table_title_border_style!' => '',
					],
	
				]
			);
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_title_border_style' );
			$this->start_controls_tab(
				'peeao_pricing_table_title_border_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_title_border_style!' => '',
					],
	
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_title_border_color',
				[
					'label' => esc_html_x( 'Border Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_title_border_style!' => '',
					],
	
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_title_tab_border_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_title_border_style!' => '',
					],
	
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_title_hover_border_color',
				[
					'label' => esc_html_x( 'Border Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title:hover' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_title_border_style!' => '',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
	
			$this->add_responsive_control(
				'peeao_pricing_table_title_border_radius',
				[
					'label' =>esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px'],
					'default' => [
						'top' => '',
						'right' => '',
						'bottom' => '' ,
						'left' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
	
				]
			);
	
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_title_box_shadow_group',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power_elements-pricing-title',
				]
			);
			$this->end_controls_section();
	
			//Price Subtitle style start
			$this->start_controls_section(
				'peeao_pricing_table_section_subtitle_style',
				[
					'label' =>esc_html__( 'Table Subtitle', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_pricing_table_subtitle!' => '',
					]
				]
			);
			
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_subtitle_style' );
	
			$this->start_controls_tab(
				'peeao_pricing_table_tab_subtitle_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_text_color',
				[
					'label' =>esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_pricing_table_tab_subtitle_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_hover_color',
				[
					'label' =>esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading p' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_subtitle_typography_group',
					'label' =>esc_html__( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_text_padding',
				[
					'label' =>esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
	
			$this->add_responsive_control(
				'peeao_pricing_table_subtitlehr12',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_border_style',
				[
					'label' => esc_html_x( 'Border Type', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'' => esc_html__( 'None', 'power-elements' ),
						'solid' => esc_html_x( 'Solid', 'Border Control', 'power-elements' ),
						'double' => esc_html_x( 'Double', 'Border Control', 'power-elements' ),
						'dotted' => esc_html_x( 'Dotted', 'Border Control', 'power-elements' ),
						'dashed' => esc_html_x( 'Dashed', 'Border Control', 'power-elements' ),
						'groove' => esc_html_x( 'Groove', 'Border Control', 'power-elements' ),
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' => 'border-style: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_border_dimensions',
				[
					'label' => esc_html_x( 'Width', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'peeao_pricing_table_subtitle_border_style!' => '',
					],
				]
			);
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_subtitle_border_style' );
			$this->start_controls_tab(
				'peeao_pricing_table_subtitle_border_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_subtitle_border_style!' => '',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_border_color',
				[
					'label' => esc_html_x( 'Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_subtitle_border_style!' => '',
					],
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_subtitle_tab_border_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_subtitle_border_style!' => '',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_hover_border_color',
				[
					'label' => esc_html_x( 'Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p:hover' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_subtitle_border_style!' => '',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
	
			$this->add_control(
				'peeao_pricing_table_subtitlehr13',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_subtitle_border_radius',
				[
					'label' =>esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px'],
					'default' => [
						'top' => '',
						'right' => '',
						'bottom' => '' ,
						'left' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_subtitle_box_shadow_group',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading p',
				]
			);
			$this->end_controls_section();
	
			//Image Style Start
			$this->start_controls_section(
				'peeao_pricing_table_style_image',
				[
					'label' => esc_html__( 'Header Image', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_pricing_table_icon_type' => 'image',
	
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_image_space',
				[
					'label' => esc_html__( 'Margin Bottom', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 10,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_pricing_table_style_tabs_image'
			);
	
			$this->start_controls_tab(
				'peeao_pricing_table_style_img_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_pricing_table_imge_border_group',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_image_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_iamge_box_shadow_group',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img',
				]
			);
	
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_style_img_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_pricing_table_imge_border_hover_group',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_image_hover_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_iamge_box_shadow_hv_group',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading .elementor-pricing-img img',
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_image_hover_animation',
				[
					'label' => esc_html__( 'Animation', 'power-elements' ),
					'type' => Controls_Manager::HOVER_ANIMATION,
				]
			);
	
	
			$this->end_controls_tab();
	
			$this->end_controls_tabs();
	
			$this->end_controls_section();
	
			//Icon Style Start
			$this->start_controls_section(
				'peeao_pricing_table_section_style_icon',
				[
					'label' => esc_html__( 'Header Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_pricing_table_icons__switch'	=> 'yes',
						'peeao_pricing_table_icon_type' => 'icon',
	
					],
				]
			);
	
			$this->start_controls_tabs( 'icon_colors' );
	
			$this->start_controls_tab(
				'peeao_pricing_table_icon_colors_normal',
				[
					'label' => esc_html__( 'Normal', 'power-elements' ),
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_icon_primary_color',
				[
					'label' => esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_icon_secondary_color_normal',
				[
					'label' => esc_html__( 'BG Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'background-color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_pricing_table_border_group',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-pricing-icon',
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_icon_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_icon_colors_hover',
				[
					'label' => esc_html__( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_hover_primary_color',
				[
					'label' => esc_html__( 'Primary Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_hover_secondary_color',
				[
					'label' => esc_html__( 'Secondary Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'background-color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_pricing_table_border_icon_group',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon',
				]
			);
			
			$this->add_responsive_control(
				'peeao_pricing_table_icon_hover_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_pricing_table_icons_hover_animation',
				[
					'label' => esc_html__( 'Hover Animation', 'power-elements' ),
					'type' =>   Controls_Manager::HOVER_ANIMATION,
				]
			);
	
			$this->end_controls_tab();
	
			$this->end_controls_tabs();
			$this->add_responsive_control(
				'peeao_pricing_table_icon_size',
				[
					'label' => esc_html__( 'Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 6,
							'max' => 300,
						],
					],
					'default' => [
						'size' => 40,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_icon_space',
				[
					'label' => esc_html__( 'Margin Bottom', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => -20,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 15,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_icon_padding',
				[
					'label' => esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 15,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'padding: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_rotate',
				[
					'label' => esc_html__( 'Rotate', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'size' => 0,
						'unit' => 'deg',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon' => 'transform: rotate({{SIZE}}{{UNIT}});',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_icon_box_shadow_group',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-heading .power-pricing-icon',
				]
			);
	
			$this->end_controls_section();
	
			//Price Tag style start
			$this->start_controls_section(
				'peeao_pricing_table_section_tag_style',
				[
					'label' =>esc_html__( 'Price Tag', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_price_typography_group',
					'label' =>esc_html__( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-value-number, {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-value-number',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_tag_text_color',
				[
					'label' =>esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-value-number' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-value-number' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'peeao_pricing_table_tag_hover_color',
				[
					'label' =>esc_html__( 'Hover Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table:hover .power-price-tag .power-value-number' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-value-circle .power-value-number' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_period_style',
				[
					'label' => esc_html__( 'Period Options', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_period_text_color',
				[
					'label' =>esc_html__( 'Period Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-below' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-price-below' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_period_text_color_hover',
				[
					'label' =>esc_html__( 'Period Hover Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-value-circle .power-price-below' => 'color: {{VALUE}};',
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table:hover .power-price-tag .power-price-below' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_period_typography_group',
					'label' =>esc_html__( 'Period Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-below, {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-price-below',
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_currency_style',
				[
					'label' => esc_html__( 'Currency Symbol Options', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_currency_size',
					'label' =>esc_html__( 'Currency Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-value-price,
									 {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-value-price',
				]
			);
			$this->add_control(
				'peeao_pricing_table_heading_currency_color',
				[
					'label' =>esc_html__( 'Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-value-price' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle .power-value-price' => 'color: {{VALUE}};',
					],
				]
			);	
			$this->add_control(
				'peeao_pricing_table_heading_currency_hover_color',
				[
					'label' =>esc_html__( 'Hover Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-tag .power-value-price' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-value-circle .power-value-price' => 'color: {{VALUE}};',
					],
				]
			);	
			$this->add_control(
				'peeao_pricing_table_currency_position',
				[
					'label' => esc_html__( 'Position', 'power-elements' ),
					'type' => Controls_Manager::CHOOSE,
					'label_block' => false,
					'default' => 'before',
					'options' => [
						'before' => [
							'title' => esc_html__( 'Before', 'power-elements' ),
							'icon' => 'eicon-h-align-left',
						],
						'after' => [
							'title' => esc_html__( 'After', 'power-elements' ),
							'icon' => 'eicon-h-align-right',
						],
					],
				]
			);
			$this->add_control(
				'peeao_pricing_table_tag_heading_options',
				[
					'label' => esc_html__( 'Price Tag Wrapper Options', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				array(
					'name'     => 'peeao_pricing_table_tag_wrapper_bg_color_group',
					'default' => '',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-tag-wid-o-sep,  {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle',
				)
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_pricing_table_tag_wrapper_border_group',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-tag-wid-o-sep,  {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle',

				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_tag_wrapper_box_shadow_group',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-tag-wid-o-sep,  {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_tag_text_padding',
				[
					'label' =>esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'default' => 	[
						'top' => '8',
						'right' => '0',
						'bottom' => '8',
						'left' => '0',
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-tag-wid-o-sep' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_tag_text_margin',
				[
					'label' =>esc_html__( 'Margin', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'default' => 	[
						'top' => '0',
						'right' => '0',
						'bottom' => '0',
						'left' => '0',
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-tag .power-price-tag-wid-o-sep' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-value-circle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
	

		//Price Features style start
		$this->start_controls_section(
			'peeao_pricing_table_section_seperator_style',
			[
				'label' =>esc_html__( 'Seperator', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'peeao_pricing_table_section_seperator_icon_colors' );

		$this->start_controls_tab(
			'peeao_pricing_table_section_seperator_style_normal',
			[
				'label' => esc_html__( 'Normal', 'power-elements' ),
			]
		);

		$this->add_control(
			'peeao_pricing_table_seperator_primary_color',
			[
				'label' =>esc_html__( 'Primary Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-icon-with-border i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_pricing_table_seperator_secondary_color',
			[
				'label' =>esc_html__( 'Secondary Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-icon-with-border::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-icon-with-border::after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'peeao_pricing_table_section_seperator_style_hover',
			[
				'label' => esc_html__( 'Hover', 'power-elements' ),
			]
		);

		$this->add_control(
			'peeao_pricing_table_seperator_primary_color:hover',
			[
				'label' =>esc_html__( 'Primary Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-icon-with-border i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_pricing_table_seperator_secondary_color_hover',
			[
				'label' =>esc_html__( 'Secondary Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-icon-with-border::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-icon-with-border::after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->end_controls_section();
		//Price Features style start
		$this->start_controls_section(
			'peeao_pricing_table_section_content_style',
			[
				'label' =>esc_html__( 'Features', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'peeao_pricing_table_content_typography_group',
				'label' =>esc_html__( 'Typography', 'power-elements' ),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details-info > li, {{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details',
			]
		);

		$this->add_control(
			'peeao_pricing_table_fhr1',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);
		$this->start_controls_tabs( 'peeao_pricing_table_tabs_content_style' );

		$this->start_controls_tab(
			'peeao_pricing_table_content_tab',
			[
				'label' =>esc_html__( 'Normal', 'power-elements' ),
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_content_text_color',
			[
				'label' =>esc_html__( 'Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#262626',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details-info > li' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_pricing_table_heading_features_list',
			[
				'label' => esc_html__( 'Features List Options', 'power-elements' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'peeao_pricing_table_heading_features_list_odd_bg_color',
			[
				'label' =>esc_html__( 'Odd Item BG Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details-info li:nth-child(odd)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_heading_features_list_even_bg_color',
			[
				'label' =>esc_html__( 'Even Item BG Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details-info li:nth-child(even)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'peeao_pricing_table_item_border',
				'label' => esc_html__( 'Style', 'power-elements' ),
				'condition' => [
					'peeao_pricing_table_content_style' => 'list',
				],
				'selector'	=> '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details li',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_pricing_table_content_tab_hover',
			[
				'label' =>esc_html__( 'Hover', 'power-elements' ),
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_content_hover_color',
			[
				'label' =>esc_html__( 'Color', 'power-elements' ),
				'default' => '#262626',
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-details' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-details-info li' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_pricing_table_heading_features_list_hover',
			[
				'label' => esc_html__( 'Features List Options', 'power-elements' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'peeao_pricing_table_heading_features_list_odd_bg_color_hover',
			[
				'label' =>esc_html__( 'Odd Item BG Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-details-info li:nth-child(odd)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_heading_features_list_even_bg_color_hover',
			[
				'label' =>esc_html__( 'Even Item BG Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-details-info li:nth-child(even)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'peeao_pricing_table_item_border_hover',
				'label' => esc_html__( 'Style', 'power-elements' ),
				'condition' => [
					'peeao_pricing_table_content_style' => 'list',
				],
				'selector'	=> '{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-details li',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'peeao_pricing_table_divider_width',
			[
				'label' => esc_html__( 'Width', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
				'condition' => [
					'peeao_pricing_table_list_divider' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details li:before' => 'margin-left: calc((100% - {{SIZE}}%)/2); margin-right: calc((100% - {{SIZE}}%)/2)',
				],
			]
		);

		$this->add_responsive_control(
			'peeao_pricing_table_divider_gap',
			[
				'label' => esc_html__( 'List Gap', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 15,
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details li:before' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'peeao_pricing_table_content_style' => 'list',
				]
			]
		);

		$this->add_control(
			'peeao_pricing_table_hr5',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_features_item_margin',
			[
				'label' =>esc_html__( 'Item Margin', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
					'top' => 0,
					'left' => 0,
					'right' => 0,
					'bottom' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'peeao_pricing_table_content_style' => 'list',
				]
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_features_item_padding',
			[
				'label' =>esc_html__( 'Item Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'peeao_pricing_table_content_style' => 'list',
				]
			]
		);
	
		$this->add_control(
			'peeao_pricing_table_heading_features_wrapper',
			[
				'label' => esc_html__( 'Features Wrapper Options', 'power-elements' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'peeao_pricing_table_hr6',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_responsive_control(
			'peeao_pricing_table_features_body_margin',
			[
				'label' =>esc_html__( 'Margin', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
					'top' => 0,
					'left' => 0,
					'right' => 0,
					'bottom' => 40,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_pricing_table_features_body_padding',
			[
				'label' =>esc_html__( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	
	//Button Wrapper style start
	$this->start_controls_section(
		'peeao_pricing_table_section_button_wrapper_style',
		[
			'label' =>esc_html__( 'Button Wrapper', 'power-elements' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
	$this->start_controls_tabs( 'peeao_pricing_table_button_wrapper_style' );

	$this->start_controls_tab(
		'peeao_pricing_table_button_wrapper_normal',
		[
			'label' =>esc_html__( 'Normal', 'power-elements' ),
		]
	);

	$this->add_control(
		'peeao_pricing_table_pricing_button_wrapper_bg_sp', [
			'type' => Controls_Manager::COLOR,
			'label' => esc_html__('Background Color', 'power-elements'),
			'default' => '',
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn' => 'background-color: {{VALUE}};',
			],
		]
	);
	$this->end_controls_tab();

	$this->start_controls_tab(
		'peeao_pricing_table_button_wrapper_wrapper_hover',
		[
			'label' =>esc_html__( 'Hover', 'power-elements' ),
		]
	);

	$this->add_control(
		'peeao_pricing_table_pricing_button_wrapper_bg_sp_hover', [
			'type' => Controls_Manager::COLOR,
			'label' => esc_html__('Background Color', 'power-elements'),
			'default' => '',
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table:hover .power-price-btn' => 'background-color: {{VALUE}};',
			],
		]
	);

	$this->end_controls_tab();
	$this->end_controls_tabs();

	$this->add_responsive_control(
		'peeao_pricing_table_pricing_button_wrapper_padding',
		[
			'label' =>esc_html__( 'Padding', 'power-elements' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors' => [
				'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$this->end_controls_section();
			//Button style start
			$this->start_controls_section(
				'peeao_pricing_table_section_btn_style',
				[
					'label' =>esc_html__( 'Button', 'power-elements' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'peeao_pricing_table_btn_typography_group',
					'label' =>esc_html__( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a',
				]
			);
			$this->add_control(
				'peeao_pricing_table_hr1',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_button_style' );
	
			$this->start_controls_tab(
				'peeao_pricing_table_tab_button_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_btn_text_color',
				[
					'label' =>esc_html__( 'Text Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '#ffffff',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				array(
					'name'     => 'peeao_pricing_table_btn_bg_color_group',
					'default' => '',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a',
				)
			);
	
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_btn_tab_button_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_btn_hover_color',
				[
					'label' =>esc_html__( 'Text Color', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-btn a' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Background::get_type(),
				array(
					'name'     => 'peeao_pricing_table_btn_bg_hover_color_group',
					'default' => '',
					'selector' => '{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-btn a',
				)
			);
	
			$this->end_controls_tab();
			$this->end_controls_tabs();
	
			$this->add_responsive_control(
				'peeao_pricing_table_text_padding',
				[
					'label' =>esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'default'    => [
						'top' => '15',
						'right' => '60',
						'bottom' => '15',
						'left' => '60',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
			$this->add_control(
				'peeao_pricing_table_hr2',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_btn_border_style',
				[
					'label' => esc_html_x( 'Border Type', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'' => esc_html__( 'None', 'power-elements' ),
						'solid' => esc_html_x( 'Solid', 'Border Control', 'power-elements' ),
						'double' => esc_html_x( 'Double', 'Border Control', 'power-elements' ),
						'dotted' => esc_html_x( 'Dotted', 'Border Control', 'power-elements' ),
						'dashed' => esc_html_x( 'Dashed', 'Border Control', 'power-elements' ),
						'groove' => esc_html_x( 'Groove', 'Border Control', 'power-elements' ),
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' => 'border-style: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_btn_border_dimensions',
				[
					'label' => esc_html_x( 'Width', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'peeao_pricing_table_btn_border_style!' => '',
					]
				]
			);
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_button_border_style' );
			$this->start_controls_tab(
				'peeao_pricing_table_tab_button_border_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_btn_border_style!' => '',
					]
				]
			);
	
			$this->add_responsive_control(
				'peeao_pricing_table_btn_border_color',
				[
					'label' => esc_html_x( 'Border Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_btn_border_style!' => '',
					]
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_btn_tab_button_border_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
					'condition' => [
						'peeao_pricing_table_btn_border_style!' => '',
					]
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_btn_hover_border_color',
				[
					'label' => esc_html_x( 'Border Color', 'Border Control', 'power-elements' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-btn a' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'peeao_pricing_table_btn_border_style!' => '',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
	
	
	
			$this->add_control(
				'peeao_pricing_table_hr3',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
			$this->add_responsive_control(
				'peeao_pricing_table_btn_border_radius',
				[
					'label' =>esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%'],
					'default' => [
						'top' => '100',
						'right' => '100',
						'bottom' => '100' ,
						'left' => '100',
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
	
				]
			);
	
			$this->start_controls_tabs( 'peeao_pricing_table_tabs_button_box_shadow_style' );
	
			$this->start_controls_tab(
				'peeao_pricing_table_tab_button_box_shadow_normal',
				[
					'label' =>esc_html__( 'Normal', 'power-elements' ),
	
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_button_box_shadow_group',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-price-table .power-price-btn a',
	
				]
			);
			$this->end_controls_tab();
	
			$this->start_controls_tab(
				'peeao_pricing_table_tab_button_box_shadow_hover',
				[
					'label' =>esc_html__( 'Hover', 'power-elements' ),
	
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_pricing_table_button_box_shadow_hover_group',
					'selector' => '{{WRAPPER}}:hover .peeao-wrapper .power-price-table .power-price-btn a',
	
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
	
			$this->end_controls_section();
	
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			extract($settings);
			//For button
			$btn_class = ($peeao_pricing_table_button_class != '') ? $peeao_pricing_table_button_class : '';
			$btn_link = (! empty( $peeao_pricing_table_btn_link['url'])) ? $peeao_pricing_table_btn_link['url'] : '';
			$btn_target = ( $peeao_pricing_table_btn_link['is_external']) ? '_blank' : '_self';
	
			$this->add_render_attribute( 'icon-align', 'class', 'power-align-icon-' . $peeao_pricing_table_icon_align );

			if ( ! empty( $peeao_pricing_table_image['url'] ) ) {
				$this->add_render_attribute( 'image', 'src', $peeao_pricing_table_image['url'] );
				$this->add_render_attribute( 'image', 'alt', Control_Media::get_image_alt( $peeao_pricing_table_image ) );
	
				$image_html = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'peeao_pricing_table_image' );
	
	
				$image = '<figure class="elementor-pricing-img">' . $image_html . '</figure>';
			} ?>
	
			<div class="peeao-wrapper">
				<div class="power-price-table <?php echo ($peeao_pricing_table_heading_price_tag_layout == 'circle') ? 'power-price-table-color-circle' : ''; ?>">
					<div class="power-price-heading  <?php echo ($peeao_pricing_table_heading_price_tag_layout == 'circle') ? 'power-price-heading-circle' : ''; ?>">
						<?php if($peeao_pricing_table_icon_type == 'image') : ?>
							<?php echo $image; ?>
						<?php endif; ?>
						<?php if($peeao_pricing_table_icon_type == 'icon') : ?>					
							<?php Icons_Manager::render_icon( $peeao_pricing_table_icons, [ 'aria-hidden' => 'true', 'class'    => [
										'power-pricing-icon',
										'elementor-animation-'. esc_attr($peeao_pricing_table_icons_hover_animation)
									] ] );?>
						<?php endif; ?>
						<?php if($peeao_pricing_table_title != ''): ?>
							<<?php echo esc_attr($peeao_pricing_table_title_size); ?>
							class=" power_elements-pricing-title"><?php echo esc_html($peeao_pricing_table_title); ?>
							</<?php echo esc_attr($peeao_pricing_table_title_size); ?>>
						<?php endif; ?>
						<?php if($peeao_pricing_table_subtitle != ''): ?>
							<p ><?php echo esc_html($peeao_pricing_table_subtitle); ?></p>
						<?php endif; ?>
						<div class="<?php echo ($peeao_pricing_table_heading_price_tag_layout == 'circle') ? 'power-price-value-circle' : 'power-price-tag'; ?>">
							<div class="<?php echo ($peeao_pricing_table_heading_price_tag_layout == 'circle') ? 'power-circle-middle' : 'power-price-tag-wid-o-sep'; ?>">
								<?php if($peeao_pricing_table_currency_position == 'before'): ?>
									<sup class="power-value-price power-value-violet"><?php echo esc_html($peeao_pricing_table_currency_icon); ?></sup>
								<?php endif; ?>
								<span class="power-value-number power-number-violet"><?php echo esc_html($peeao_pricing_table_price); ?></span>
								<?php if($peeao_pricing_table_currency_position == 'after'): ?>
									<sup class="power-value-price power-value-violet"><?php echo esc_html($peeao_pricing_table_currency_icon); ?></sup>
								<?php endif; ?>
								<?php if($peeao_pricing_table_duration != ''): ?>
									<h6 class="power-price-below"><?php echo esc_html($peeao_pricing_table_duration); ?></h6>
								<?php endif; ?>
							</div>
							<?php if($peeao_pricing_table_seperator__switch == 'yes'): ?>
								<div class="power-price-icon power-price-icon-violet <?php echo ($peeao_pricing_table_seperator_before_after__switch == 'yes') ? 'power-price-icon-with-border' : ''; ?>">
									<i class="<?php echo esc_attr($peeao_pricing_table_seperator_icon['value']);?>"></i>
								</div>
							<?php endif; ?>
						</div>
					</div>
					<div class="power-price-details">
						<?php if($peeao_pricing_table_content_style == 'paragraph'){ ?>
							<p> <?php echo Utils::kses($peeao_pricing_table_content); ?></p>
						<?php } ?>
						<?php if($peeao_pricing_table_content_style == 'list'){ ?>
							<ul class="power-price-details-info power-price-details-black">
								<?php  foreach($peeao_pricing_table_content_repeater as $repeat){  ?>
									<li class="elementor-repeater-item-<?php echo esc_attr( $repeat[ '_id' ] ); ?>">
										<?php Icons_Manager::render_icon( $repeat['peeao_pricing_table_check_icons'], [ 'aria-hidden' => 'true' ] ); ?>
										<?php echo esc_html($repeat['peeao_pricing_table_list']); ?>
									</li>
								<?php } ?>
							</ul>
						<?php } ?>
					</div>
					<?php if ( $peeao_pricing_table_btn_text ): ?>
						<div class="power-price-btn">
							<a href="<?php echo esc_url( $btn_link ); ?>" 
								target="<?php echo esc_attr( $btn_target ); ?>" 
								class="btn power-btn-md power-btn-radius-half power-btn-linear-bg power-btn-box-shadow text-uppercase <?php echo esc_attr( $btn_class ); ?> power-pricing-btn-icon-pos-<?php echo esc_attr($peeao_pricing_table_icon_align); ?>"
							>
								<?php
								if ( $peeao_pricing_table_btn_icons != '' && $peeao_pricing_table_icon_align == 'left' ):
									Icons_Manager::render_icon( $peeao_pricing_table_btn_icons, [ 'aria-hidden' => 'true' ] );
								endif;
			
								echo esc_html( $peeao_pricing_table_btn_text );
								
								if ( $peeao_pricing_table_btn_icons != '' && $peeao_pricing_table_icon_align == 'right' ):
									Icons_Manager::render_icon( $peeao_pricing_table_btn_icons, [ 'aria-hidden' => 'true' ] );
								endif;
								?>
							</a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		<?php }
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}