<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Portfolio_Filter extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_portfolio_filter';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Portfolio Filter', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-posts-justified';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_portfolio_filter_section_content_tab',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_style',
				[
					'label'        => __( 'Style', 'power-elements' ),
					'type'         => Controls_Manager::SELECT,
					'default'      => 'portfolio_no_hover',
					'options'      => [
						'portfolio_no_hover'  => __( 'Style 1', 'power-elements' ),
						'portfolio_hover'  => __( 'Style 2', 'power-elements' ),
						'portfolio_left_right'  => __( 'Style 3', 'power-elements' ),
						'portfolio_hover_2'  => __( 'Style 4', 'power-elements' ),
					]
				]
			);
			$this->add_group_control(
				'powerpost',
				[
					'name' => 'powerpost',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_advanced',
				[
					'label' => __( 'Advanced', 'power-elements' ),
					'type' => Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_orderby',
				[
					'label' => __( 'Order By', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'post_date',
					'options' => [
						'post_date' => __( 'Date', 'power-elements' ),
						'post_title' => __( 'Title', 'power-elements' ),
						'menu_order' => __( 'Menu Order', 'power-elements' ),
						'rand' => __( 'Random', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_order',
				[
					'label' => __( 'Order', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'desc',
					'options' => [
						'asc' => __( 'ASC', 'power-elements' ),
						'desc' => __( 'DESC', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_offset',
				[
					'label' => __( 'Offset', 'power-elements' ),
					'type' => Controls_Manager::NUMBER,
					'default' => 0,
					'description' => __( 'Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_post__not_in',
				[
					'label' => __('Exclude', 'power-elements'),
					'type' => Controls_Manager::SELECT2,
					'options' => Partials::get_all_types_post(),
					'label_block' => true,
					'post_type' => '',
					'multiple' => true,
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_posts_per_page',
				[
					'label' => __('Posts Per Page', 'power-elements'),
					'type' => Controls_Manager::NUMBER,
					'default' => '4',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_layout_tab',
				[
					'label' => __( 'Layout', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_title',
				[
					'label' => __( 'Filter Default Title', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' => __( 'All Works', 'power-elements' ),
					'placeholder' => __( 'All Works', 'power-elements' ),
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_gutter',
				[
					'label' => __( 'Gutter', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 30,
							'step' => 10,
						]
					],
					'default' => [
						'unit' => 'px',
						'size' => 10,
					]
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_grid',
				[
					'label' => __( 'Grid', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 5,
							'step' => 1,
						]
					],
					'default' => [
						'unit' => 'px',
						'size' => 2,
					]
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_show_filter',
				[
					'label' => __( 'Show Filter', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'power-elements' ),
					'label_off' => __( 'Hide', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_show_popup',
				[
					'label' => __( 'Show Popup', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'power-elements' ),
					'label_off' => __( 'Hide', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_icon',
				[
					'label'       => __( 'Icon', 'power-elements' ),
					'type'        => Controls_Manager::ICON,
					'label_block' => true,
					'default'     => 'fa fa-plus',
					'condition'   => [
						'peeao_portfolio_filter_show_popup' => 'yes',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_button_label',
				[
					'label'       => __( 'Button Label', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'View More', 'power-elements' ),
					'placeholder' => __( 'View More', 'power-elements' ),
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_filter_style_tab',
				[
					'label' => __( 'Portfolio', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			); 
			$this->add_responsive_control(
				'peeao_portfolio_filter_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_thumb' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_thumb',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_content_wrapper_style_tab',
				[
					'label' => __( 'Content Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_portfolio_filter_content_wrapper_background',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_info, {{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info', 
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_icon_style_tab',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_icon_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item a.power_portfolio_popup' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_icon_size',
				[
					'label' => __( 'Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						]
					],
					'default' => [
						'unit' => 'px',
						'size' => 42,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item a.power_portfolio_popup' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_content_style_tab',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_content_options',
				[
					'label' => __( 'Info Wrapper', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_info_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_info_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_info_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_content_title_options',
				[
					'label' => __( 'Title', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .power_portfolio_filter_item_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .power_portfolio_filter_item_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .power_portfolio_filter_item_title,{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_title',
				] 
			);
			$this->add_control(
				'peeao_portfolio_filter_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_title a' => 'color: {{VALUE}}',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .power_portfolio_filter_item_title a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_title_hover_color',
				[
					'label'     => __( 'Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_title a:hover' => 'color: {{VALUE}}',
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .power_portfolio_filter_item_title a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_content_intro_options',
				[
					'label' => __( 'Category', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_af_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_tag' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_af_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_tag' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_af_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_tag',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_af_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_filter_item .power_portfolio_label_text .power_portfolio_filter_item_tag' => 'color: {{VALUE}}',
					],
				]

			);
			$this->add_control(
				'peeao_portfolio_filter_content_excerpt_options',
				[
					'label' => __( 'Excerpt', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_excerpt_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
					'selectors'  => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .port-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .port-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_excerpt_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
					'selectors'  => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .port-excerpt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .port-excerpt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_excerpt_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .port-excerpt, {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .port-excerpt',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_excerpt_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'peeao_portfolio_filter_style' => [ 'portfolio_left_right', 'portfolio_hover_2'],
					],
					'selectors' => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .port-excerpt' => 'color: {{VALUE}}',
						'{{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .port-excerpt' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_filter_wrapper_style_tab',
				[
					'label' => __( 'Filter', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			); 
			$this->add_responsive_control(
				'peeao_portfolio_filter_heading_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_heading_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_heading_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfolio_button_group',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfolio_button_group',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_filter_section_filter_button_style_tab',
				[
					'label' => __( 'Filter Button', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_btn_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_btn_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_btn_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_btn_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_btn_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_btn_hover_color',
				[
					'label'     => __( 'Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_btn_active_color',
				[
					'label'     => __( 'Active Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button.is-checked' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_btn_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_btn_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_btn_hover_border',
				[
					'label'      => __( 'Border Hover/Active Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_portfolio_button_group .power_portfolio_button:hover, .power_portfolio_button_group .power_portfolio_button.is-checked' => 'border-color: {{VALUE}} !important;',
					],
				]
			);
			$this->end_controls_section();


			/*
			 * READ MORE Style
			 */
			$this->start_controls_section(
				'peeao_portfolio_filter_read_more_style',
				[
					'label'     => __( 'Read More', 'power-elements' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_portfolio_filter_style' => ['portfolio_left_right', 'portfolio_hover_2'],
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_portfolio_filter_read_more_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_portfolio_filter_read_more_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_read_more_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio ,  {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio',
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_read_more_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio' => 'color: {{VALUE}}',
						' {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_portfolio_filter_read_more_bg_color',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio,  {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio', 
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_read_more_align',
				[
					'label'     => __( 'Alignment', 'power-elements' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => [
						'left'   => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'selectors' => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio' => 'text-align: {{VALUE}};',
						' {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio' => 'text-align: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_read_more_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio,  {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfolio_filter_read_more_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio,  {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_read_more_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						' {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_read_more_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						' {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_filter_read_more_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						' {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_portfolio_filter_read_more_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_filter_read_more_color_hover',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio:hover, {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_portfolio_filter_read_more_bg_color_hover',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .portfolio_left_right .power_portfolio_thumb .grid-2 .grid-sizer.info .btn-portfolio:hover, {{WRAPPER}} .portfolio_hover_2 .power_portfolio_thumb .power_portfolio_info .btn-portfolio:hover', 
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			
		}
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			
			/**
			 * Setup the post arguments.
			 */
			
			$post_args              = Partials::get_post_settings( $settings );
			$query_args             = Partials::get_query_args( 'powerpost', $settings , 'portfolio_filter');
			$query_args             = array_merge( $query_args, $post_args, $settings );
			
			if ( isset( $query_args['tax_query'] ) ) {
				$tax_query = $query_args['tax_query'];
			}
			/**
			 * Get posts from database. 
			 */
			$posts = Partials::load_filter( $query_args, 'portfolio_filter' );
			/**
			 * Set total posts.
			 */
			//$total_post = $posts['count'];
			?>
			<div class="peeao-wrapper">
				<div id="power-post-grid-<?php echo esc_attr( $this->get_id() ); ?>"
					class="power-post-grid-container">
					<div class="power_portfolio_filter <?php echo esc_attr( $settings['peeao_portfolio_filter_style'] )  ?>">
						<?php
							if ( ! empty( $posts['content'] ) ) {
								echo $posts['content'];
							} else { 
								echo '<p class="text-danger">'.esc_html__('Something went wrong.','power-elements').'</p>';
							}
						?>
					</div>
				</div>
            </div>
			<?php
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		//protected function _content_template() {}
	}