<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Icon_Box extends Widget_Base {
		
		/**
		 * Get widget name. 
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_icon_box';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Icon Box', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-icon-box';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_list',
				[
					'label' => __( 'Icon List', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_style',
				[
					'label'   => __( 'Type', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'type_2',
					'options' => [
						'type_1' => __( 'Type 1', 'power-elements' ),
						'type_2' => __( 'Type 2', 'power-elements' ),
						'type_3' => __( 'Type 3', 'power-elements' ),
						'type_4' => __( 'Type 4', 'power-elements' )
					]
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_align',
				[
					'label'     => __( 'Alignment', 'power-elements' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => [
						'left'   => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'default'   => 'center',
					'condition' => [
						'peeao_icon_box_style' => ['type_2','type_4'],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox.type_2' => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox.type_4' => 'text-align: {{VALUE}};',
					]
				]
			);
			$this->add_control(
				'peeao_icon_box_floating_image',
				[
					'label'     => __( 'Choose Floating Image', 'power-elements' ),
					'type'      => Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_icon_box_style' => 'type_4',
					],
				]
			);
			$this->add_control(
				'peeao_icon_box_image',
				[
					'label'        => __( 'Icon or Image', 'power-elements' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Icon', 'power-elements' ),
					'label_off'    => __( 'Image', 'power-elements' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			$this->add_control(
				'peeao_icon_box_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => '',
						'library' => 'peeaoicons',
					],
					'condition'   => [
						'peeao_icon_box_image' => 'yes',
					],
				]
			);
			$this->add_control(
				'peeao_icon_box_box_image',
				[
					'label'     => __( 'Choose Image', 'power-elements' ),
					'type'      => Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_icon_box_image!' => 'yes',
					],
				]
			);					
			$this->add_control(
				'peeao_icon_box_box_number',
				[
					'label'       => __( 'Number', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( '01', 'power-elements' ),
					'placeholder' => __( 'Type your number here', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_box_title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Photography of Nature', 'power-elements' ),
					'placeholder' => __( 'Type your title here', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_box_description',
				[
					'label'       => __( 'Description', 'power-elements' ),
					'type'        => Controls_Manager::TEXTAREA,
					'rows'        => 10,
					'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut 
					sed bibendum leo maur massa eleifend et purus vel feugiat 
					rutrum nulla cras vitae est.', 'power-elements' ),
					'placeholder' => __( 'Type your description here', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_box_link',
				[
					'label'       => __( 'Link', 'power-elements' ),
					'type'        => Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'power-elements' ),
					'default'     => [
						'url' => '',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_section_icon_box_button',
				[
					'label' => __( 'Button', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_btn_show',
				[
					'label' => esc_html__( 'Show Button?', 'power-elements' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);
			$this->add_control(
				'peeao_icon_box_btn_style',
				[
					'label'        => __( 'Type', 'power-elements' ),
					'type'         => \Elementor\Controls_Manager::SELECT,
					'default'      => 'effect_1',
					'options'      => [
						'effect_1'  => __( 'Effect 1', 'power-elements' ),
						'effect_2'  => __( 'Effect 2', 'power-elements' ),
						'effect_3'  => __( 'Effect 3', 'power-elements' ),
						'effect_4'  => __( 'Effect 4', 'power-elements' ),
						'effect_5'  => __( 'Effect 5', 'power-elements' ),
						'effect_6'  => __( 'Effect 6', 'power-elements' ),
						'effect_7'  => __( 'Effect 7', 'power-elements' ),
						'effect_8'  => __( 'Effect 8', 'power-elements' ),
						'effect_9'  => __( 'Effect 9', 'power-elements' ),
						'effect_10' => __( 'Effect 10', 'power-elements' ),
						'effect_11' => __( 'Effect 11', 'power-elements' ),
						'effect_12' => __( 'Effect 12', 'power-elements' ),
						'effect_13' => __( 'Effect 13', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_icon_box_btn_text',
				[
					'label'       => __( 'Text', 'power-elements' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Read More', 'power-elements' ),
					'placeholder' => __( 'Read More', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_icon_box_btn_link',
				[
					'label'       => __( 'Button Link', 'power-elements' ),
					'type'        => \Elementor\Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'power-elements' ),
					'default'     => [
						'url' => '#',
					],
				]
			);
		
			$this->add_control(
				'peeao_icon_box_btn_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => '',
						'library' => 'peeaoicons',
					],
				]
			);
			$this->add_control(
				'peeao_icon_box_btn_icon_align',
				[
					'label'     => __( 'Icon Position', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::SELECT,
					'default'   => 'power_icon_box_btn_icon_left',
					'options'   => [
						'power_icon_box_btn_icon_right' => __( 'Right', 'power-elements' ),
						'power_icon_box_btn_icon_left'  => __( 'Left', 'power-elements' ),
					],
					'condition' => [
						'peeao_icon_box_btn_icon!' => '',
					],
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_btn_icon_indent',
				[
					'label'     => __( 'Icon Spacing', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 50,
						],
					],
					'condition' => [
						'peeao_icon_box_btn_icon!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power_icon_box_btn_icon_right i' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_icon_box_btn_icon_left i'  => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS WRAPPER
			 */
			$this->start_controls_section(
				'section_wrapper_style',
				[
					'label' => __( 'Icon Box Container', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_icon_box_wrapper_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_icon_box_wrapper_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_wrapper_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_shadow',
					'selector' => '{{WRAPPER}} .power_iconbox',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_wrapper_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_wrapper_bg_hover',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox:hover,{{WRAPPER}} .peeao-wrapper .power_iconbox.type_4:hover::after',
				]
			);
			$this->add_group_control( 
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_wrapper_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_shadow_hover',
					'selector' => '{{WRAPPER}} .power_iconbox:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_padding_hover',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_margin_hover',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_icon_box_wrapper_floating',
				[
					'label' => __( 'Floating', 'power-elements' ),
					'type'  => Controls_Manager::HEADING,
					'condition' => [
						'peeao_icon_box_style' => 'type_4',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_wrapper_radius_hover_after',
				[
					'label'      => __( 'Floating Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_iconbox.type_4:hover::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'peeao_icon_box_style' => 'type_4',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_shadow_hover_after',
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_iconbox.type_4:hover::after',
					'condition' => [
						'peeao_icon_box_style' => 'type_4',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS ICON
			 */
			$this->start_controls_section(
				'section_icon_style',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,	
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_size',
				[
					'label'     => __( 'Size', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 36,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon i'   => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->start_controls_tabs(
				'peeao_icon_box_icon_tabs'
			);
			$this->start_controls_tab(
				'peeao_icon_box_icon_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon i' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_icon_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_icon_box_shadow',
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_icon_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon i' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_bg_hover',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_icon_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_icon_box_shadow_hover',
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS IMAGE
			 */
			$this->start_controls_section(
				'section_icon_image_style',
				[
					'label' => __( 'Image', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,	
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_image_width',
				[
					'label'     => __( 'Width', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => '',
					],
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon img'   => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_image_height',
				[
					'label'     => __( 'Height', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => '',
					],
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon img'   => 'height: {{SIZE}}{{UNIT}};',
					],
				] 
			);


			$this->add_responsive_control(
				'peeao_icon_box_image_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_image_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->start_controls_tabs(
				'peeao_icon_box_image_tabs'
			);
			$this->start_controls_tab(
				'peeao_icon_box_image_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_image_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_image_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_image_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_image_box_shadow',
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_icon',
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_image_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_image_bg_hover',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_image_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_image_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_image_box_shadow_hover',
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_icon',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS NUMBER
			 */
			$this->start_controls_section(
				'section_number_style',
				[
					'label' => __( 'Number', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_icon_box_number_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_iconbox .power_icon_box_box_number',
				]
			);
			$this->start_controls_tabs(
				'peeao_icon_box_number_tabs'
			);

			$this->start_controls_tab(
				'peeao_icon_box_number_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_number_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#00a2ff',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_icon_box_box_number' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_number_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_icon_box_box_number',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_number_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox .power_icon_box_box_number',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_number_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_icon_box_box_number',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_number_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_icon_box_box_number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_number_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_number_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_icon_box_box_number' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_number_hover_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_icon_box_box_number',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_number_hover_bg',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_icon_box_box_number',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_icon_box_number_hover_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_icon_box_box_number',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_number_hover_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover .power_icon_box_box_number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_responsive_control(
				'peeao_icon_box_number_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_icon_box_box_number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_number_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_icon_box_box_number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS TITLE
			 */
			$this->start_controls_section(
				'section_title_style',
				[
					'label' => __( 'Title', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_icon_box_title_tabs'
			);
			$this->start_controls_tab(
				'peeao_icon_box_title_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#202020',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content h3' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_icon_box_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => 'bold',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 16 ] ]
						],
						'text_transform' => [
							'default' => 'uppercase'
						]
					],
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_content h3',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_title_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_content h3',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_title_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_title_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#202020',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content h3' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS DESCRIPTION
			 */
			$this->start_controls_section(
				'section_des_style',
				[
					'label' => __( 'Description', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_icon_box_des_tabs'
			);
			$this->start_controls_tab(
				'peeao_icon_box_des_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_des_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#202020',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_icon_box_des_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => 'Regular',
						],
						'font_family' => [
							'default' => 'Hind',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 14 ] ]
						],
					],
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_content p',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_des_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_iconbox .power_iconbox_content p',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_des_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_des_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_icon_box_des_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_icon_box_des_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#202020',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_icon_box_btn_section_style',
				[
					'label' => __( 'Button', 'power-elements' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_icon_box_btn_content_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_icon_box_btn',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_btn_text_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} a.power_icon_box_btn, {{WRAPPER}} .power_icon_box_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator'  => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_btn_margin_top',
				[
					'label'     => __( 'Margin Top', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox .power_iconbox_content a.power_icon_box_btn' => 'margin-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox .power_iconbox_content .power_icon_box_btn'  => 'margin-top: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_icon_box_btn_margin_left',
				[
					'label'     => __( 'Margin Left', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'max' => 50,
						],
					],
					'condition' => [
						'peeao_icon_box_style' => 'type_1',
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox.type_1 .power_iconbox_content a.power_icon_box_btn' => 'margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox.type_1 .power_iconbox_content .power_icon_box_btn'  => 'margin-left: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs( 'peeao_icon_box_btn_tabs_button_style' );
			
			$this->start_controls_tab(
				'peeao_icon_box_btn_tab_style_normal',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_icon_box_btn_text_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '#0071f0',
					'selectors' => [
						'{{WRAPPER}} .power_icon_box_btn-text' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_btn_background_color',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_icon_box_btn',
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_icon_box_btn_border',
					'fields_options' => [
						'border' => [
							'default' => 'none',
						],
						'width' => [
							'default' => [
								'top' => '0',
								'right' => '0',
								'bottom' => '0',
								'left' => '0',
								'isLinked' => true,
							],
						],
						'color' => [
							'default' => 'transparent',
						],
					],
					'selector'  => '{{WRAPPER}} a.power_icon_box_btn, {{WRAPPER}} .power_icon_box_btn',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_btn_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '0',
						'right' => '0',
						'bottom' => '0',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => true,
					],
					'selectors'  => [
						'{{WRAPPER}} a.power_icon_box_btn, {{WRAPPER}} .power_icon_box_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_btn_box_shadow',
					'selector' => '{{WRAPPER}} .power_icon_box_btn',
				]
			);
			$this->add_control(
				'peeao_icon_box_btn_icon_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} a.power_icon_box_btn .button_value .power_icon_box_btn_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_icon_box_btn .button_value .power_icon_box_btn_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'peeao_icon_box_btn_tab_style_before',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			
			$this->add_control(
				'peeao_icon_box_btn_hover_text_color',
				[
					'label'     => __( 'Text Color', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content a.power_icon_box_btn .button_value' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn .button_value' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:focus .power_iconbox_content a.power_icon_box_btn' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:focus .power_iconbox_content .power_icon_box_btn' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_icon_box_btn_background_color_hover',
					'label'    => __( 'Background Color', 'power-elements' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_content a.power_icon_box_btn, {{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'      => 'peeao_icon_box_btn_border_before',
					'selector'  => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_content a.power_icon_box_btn, {{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn',
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'peeao_icon_box_btn_before_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'default'    => [
						'top' => '0',
						'right' => '0',
						'bottom' => '0',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content a.power_icon_box_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_icon_box_btn_before_box_shadow',
					'selector' => '{{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn:before',
				]
			);
			
			$this->add_control(
				'peeao_icon_box_btn_hover_icon_hover_color',
				[
					'label'     => __( 'Icon Color', 'power-elements' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content a.power_icon_box_btn .button_value .power_icon_box_btn_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:hover .power_iconbox_content .power_icon_box_btn .button_value .power_icon_box_btn_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:focus .power_iconbox_content a.power_icon_box_btn .power_icon_box_btn_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox:focus .power_iconbox_content .power_icon_box_btn .power_icon_box_btn_icon' => 'color: {{VALUE}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();

			if ( ! empty( $settings['peeao_icon_box_box_link']['url'] ) ) {
				$this->add_render_attribute( 'box_button', 'href', $settings['peeao_icon_box_box_link']['url'] );
				
				if ( $settings['peeao_icon_box_box_link']['is_external'] ) {
					$this->add_render_attribute( 'box_button', 'target', '_blank' );
				}
				
				if ( $settings['peeao_icon_box_box_link']['nofollow'] ) {
					$this->add_render_attribute( 'box_button', 'rel', 'nofollow' );
				}
			}

			$floating_html =  $settings['peeao_icon_box_style'] == 'type_4' && !empty($settings['peeao_icon_box_floating_image']['url']) ? 
				'<div class="power_icon-box-top-icon">
					<img src="' . esc_url( $settings['peeao_icon_box_floating_image']['url'] ) . '" alt="' . esc_attr( $settings['peeao_icon_box_box_title'] ) . '">
				</div>' : '';

			$icon_image = ($settings['peeao_icon_box_image'] == 'yes' ) ? 
				'<div class="power_iconbox_icon">
					<i class="' . esc_attr( $settings['peeao_icon_box_icon']['value'] ) . '"></i>
				</div>' : 
				'<div class="power_iconbox_icon">
					' . Utils::kses($floating_html) . '
					<div class="power_icon-box-image">
						<img src="' . esc_url( $settings['peeao_icon_box_box_image']['url'] ) . '" alt="' . esc_attr( $settings['peeao_icon_box_box_title'] ) . '">
					</div>
				</div>';
			
			$number_html = ($settings['peeao_icon_box_box_number'] != '' ) ? '<h6 class="power_icon_box_box_number">' . Utils::kses( $settings['peeao_icon_box_box_number'] ) . '</h6>' : '';
			$box_title_html = ($settings['peeao_icon_box_box_title'] != '' ) ? '<h3>' . Utils::kses( $settings['peeao_icon_box_box_title'] ) . '</h3>' : '';
			$box_description_html = ($settings['peeao_icon_box_box_description'] != '' ) ? '<p>' . Utils::kses( $settings['peeao_icon_box_box_description'] ) . '</p>' : '';
			

			if ( ! empty( $settings['peeao_icon_box_btn_link']['url'] ) ) {
				$this->add_render_attribute( 'button', 'href', $settings['peeao_icon_box_btn_link']['url'] );
				$this->add_render_attribute( 'button', 'class', 'power_icon_box_btn-link' );
				
				if ( $settings['peeao_icon_box_btn_link']['is_external'] ) {
					$this->add_render_attribute( 'button', 'target', '_blank' );
				}
				
				if ( $settings['peeao_icon_box_btn_link']['nofollow'] ) {
					$this->add_render_attribute( 'button', 'rel', 'nofollow' );
				}
			}
			
			$this->add_render_attribute( 'button', 'class', [
				'power_icon_box_btn',
				$settings['peeao_icon_box_btn_style'],
				$settings['peeao_icon_box_btn_icon_align']
			] );
			$this->add_render_attribute( 'button', 'role', 'button' );
			$this->add_render_attribute( 'button', 'data-text', $settings['peeao_icon_box_btn_text'] );
			
			
			if ( ! empty( $settings['peeao_icon_box_btn_size'] ) ) {
				$this->add_render_attribute( 'button', 'class', 'elementor-size-' . $settings['peeao_icon_box_btn_size'] );
			}

			$btn_html = ($settings['peeao_icon_box_btn_show'] == 'yes') ? 
						'<div '.$this->get_render_attribute_string( 'wrapper' ).'>
							<a '.$this->get_render_attribute_string( 'button' ).'>
								'.$this->render_btn_text().'
							</a>
						</div>' : '';


			if ( ! empty( $settings['peeao_icon_box_box_link']['url'] ) ) {
				$url_start = '<a '.$this->get_render_attribute_string( 'box_button' ).'>';
				$url_end = '</a>';
			}else{
				$url_start = '';
				$url_end = '';
			}

			echo '
				<div class="peeao-wrapper">
				'.$url_start.'
				<div class="power_iconbox ' . esc_attr( $settings['peeao_icon_box_style'] ) . '">
					' . Utils::kses($icon_image) . '
					'.$number_html.'
					<div class="power_iconbox_content">
						'.$box_title_html.'
						'.$box_description_html.'
						'.$btn_html.'
					</div>
				</div>
				'.$url_end.'
            </div>';
		}
		/**
		 * Render button text.
		 *
		 * Render button widget text.
		 *
		 * @since 1.5.0
		 * @access protected
		 */
		protected function render_btn_text() {
			$settings = $this->get_settings();
			

			$this->add_render_attribute( [
				'content-wrapper' => [
					'class' => 'power_icon_box_btn-content-wrapper',
				],
				'text'            => [
					'class' => [ 'power_icon_box_btn-text', 'button_value' ]
				],
			] );
			
			$this->add_inline_editing_attributes( 'text', 'none' );
			ob_start();
			?>
			<?php if ( $settings['peeao_icon_box_btn_icon_align'] == 'power_icon_box_btn_icon_right' ) : ?>
				<?php if ( ! empty( $settings['peeao_icon_box_btn_icon'] ) ) : ?>
                    <span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php echo $settings['peeao_icon_box_btn_text']; ?><?php \Elementor\Icons_Manager::render_icon( $settings['peeao_icon_box_btn_icon'], [ 'class'    => 'power_icon_box_btn_icon' ] );?></span>
				<?php endif; ?>
			<?php else : ?>
                <span <?php echo $this->get_render_attribute_string( 'text' ); ?>><?php \Elementor\Icons_Manager::render_icon( $settings['peeao_icon_box_btn_icon'], [ 'class'    => 'power_icon_box_btn_icon' ] );?></i><?php echo $settings['peeao_icon_box_btn_text']; ?></span>
			<?php endif; ?>
			<?php 
			return ob_get_clean();
		}
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
		
	}
