<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Icons_Manager;

 
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Accordion extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_accordion';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0 
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return esc_html__( 'Accordion', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-accordion';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		protected function _register_controls() {
			$this->start_controls_section(
				'section_tab', [
					'label' => esc_html__( 'Accordion', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_open_first_item',
				[
					'label' => esc_html__( 'Keep first item auto open?', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'power-elements' ),
					'label_off' => esc_html__( 'No', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'peeao_accordion_style',
				[
					'label' =>esc_html__( 'Style', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'accordion-primary',
					'options' => [
						'accordion-primary' =>esc_html__( 'Primary', 'power-elements' ),
						'curve-shape' =>esc_html__( 'Curve Shape', 'power-elements' ),
						'accordion-primary side-curve' =>esc_html__( 'Side Curve', 'power-elements' ),
						'accordion-4' =>esc_html__( 'Box Icon', 'power-elements' ),
						'floating-style' =>esc_html__( 'Floating Style', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_accordion_display_loop_count',
				[
					'label' => esc_html__( 'Show Loop Count', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'power-elements' ),
					'label_off' => esc_html__( 'Hide', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'no',
					'condition' => [
						'peeao_accordion_icon_pos_style' => 'right',
					]
				]
			);
			$repeater = new Repeater();
			$repeater->add_control(
				'peeao_acc_title', [
					'label' => esc_html__('Title', 'power-elements'),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
					'dynamic' => [
						'active' => true,
					],
				]
			);
			$repeater->add_control(
				'peeao_acc_is_active',
				[
					'label' => esc_html__('Keep this item open? ', 'power-elements'),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'no',
					'label_on' =>esc_html__( 'Yes', 'power-elements' ),
					'label_off' =>esc_html__( 'No', 'power-elements' ),
				]
			);
			$repeater->add_control(
				'peeao_acc_source',
				[
					'label'   => __( 'Source', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'custom',
					'options' => [
						'custom' => __( 'Custom', 'power-elements' ),
						'nested_template'   => __( 'Nested Templates', 'power-elements' )
					]
				]
			);
			$repeater->add_control(
				'nested_template_id', 
				[
					'label'   => __( 'Nested Templates', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => Partials::get_all_nested_templates(),
					'condition' => [
						'peeao_acc_source' => 'nested_template',
					]
				]
			);
			$repeater->add_control(
				'peeao_acc_content', [
					'label' => esc_html__('Description', 'power-elements'),
					'type' => Controls_Manager::WYSIWYG,
					'label_block' => true,
					'condition' => [
						'peeao_acc_source' => 'custom',
					]
				]
			);
			$this->add_control(
				'peeao_accordion_items',
				[
					'label' => esc_html__('Content', 'power-elements'),
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'title_field' => '{{ peeao_acc_title }}',
					'dynamic' => [
						'active' => true,
					],
					'default' => [
						[
							'peeao_acc_title' => esc_html__(' How to take the service from a hosting company ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this accordion. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
							'peeao_acc_is_active'    => 'yes'
						],[
							'peeao_acc_title' => esc_html__(' How will we cutomize elements in this accordion ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this accordion. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
						],[
							'peeao_acc_title' => esc_html__(' How will we cutomize elements in this accordion ?', 'power-elements'),
							'peeao_acc_content' => esc_html__('You need no programming Knowledge to edit this accordion. You’ll be able
							 to change any element there as you wish. So change according to the vibe 
							 your website', 'power-elements'),
						],
					],
					'fields' => $repeater->get_controls(),
				]
			);
			$this->add_control(
				'peeao_accordion_icon_pos_style',
				[
					'label' => esc_html__( 'Icon Position', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'right',
					'options' => [
						'right'  => esc_html__( 'Right', 'power-elements' ),
						'left' => esc_html__( 'Left', 'power-elements' ),
						'bothside' => esc_html__( 'Both side', 'power-elements' ),
					],
				]
			); 
			$this->add_control(
				'peeao_accordion_left_icon',
				[
					'label' => esc_html__( 'Left Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-arrow-up',
						'library' => 'peeaoicons',
					],
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['left', 'bothside']
					]
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_active',
				[
					'label' => esc_html__( 'Left Icon Active', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-arrow-down',
						'library' => 'peeaoicons',
					],
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['left', 'bothside']
					]
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon',
				[
					'label' => esc_html__( 'Right Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-arrow-up',
						'library' => 'peeaoicons',
					],
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['right', 'bothside']
					]
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_active',
				[
					'label' => esc_html__( 'Right Icon Active', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-arrow-down',
						'library' => 'peeaoicons',
					],
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['right', 'bothside']
					]
				]
			);
			$this->end_controls_section();
	
			//Title Style Section
			$this->start_controls_section(
				'peeao_accordion_section_title_style', [
					'label'	 =>esc_html__( 'Title', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_title_typography',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link',
				]
			);
			$this->start_controls_tabs(
				'peeao_accordion_style_tabs'
			);
			$this->start_controls_tab(
				'peeao_accordion_style_open_tab',
				[
					'label' => esc_html__( 'Open', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_title_color', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card .power-card-header>.power-btn-link[aria-expanded="true"]' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-accordion.curve-shape .power-card-header>.power-btn-link[aria-expanded=true]' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header>.power-btn-link[aria-expanded="true"] .power-accordion-title' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_accordion_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-accordion.accordion-primary .power-card .power-card-header>.power-btn-link[aria-expanded="true"], 
									{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header>.power-btn-link[aria-expanded=true], 
									{{WRAPPER}} .peeao-wrapper .power-accordion.floating-style .power-card .power-btn-link[aria-expanded="true"]',
				]
			);
			$this->add_control(
				'peeao_accordion_curve_fill_color', [
					'label'      =>esc_html__( 'Background Color', 'power-elements' ),
					'type'       => Controls_Manager::COLOR,
					'condition' => [
						'peeao_accordion_style' => ['curve-shape']
					],
					'selectors'  => [
						'{{WRAPPER}} .power-accordion.curve-shape .power-card-header>.power-btn-link[aria-expanded=true] .path' => 'fill: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_accordion_curve_stroke_color', [
					'label'      =>esc_html__( 'Border Color', 'power-elements' ),
					'type'       => Controls_Manager::COLOR,
					'condition' => [
						'peeao_accordion_style' => ['curve-shape']
					],
					'selectors'  => [
						'{{WRAPPER}} .power-accordion.curve-shape .power-card-header>.power-btn-link[aria-expanded=true] .path' => 'stroke: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_accordion_title_border_open',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-accordion .power-card .power-card-header > .power-btn-link[aria-expanded="true"],
					{{WRAPPER}} .peeao-wrapper .power-accordion .power-card:not(:last-child) .power-card-header > .power-btn-link[aria-expanded="true"]',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_border_radious_curve_shape_open',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card .power-card-header>.power-btn-link[aria-expanded="true"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_accordion_box_shadow_open',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-accordion .power-card .power-card-header>.power-btn-link[aria-expanded="true"]',
				]
			);
	
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_accordion_style_close_tab',
				[
					'label' => esc_html__( 'Close', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_title_color_close', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card .power-card-header>.power-btn-link[aria-expanded="false"]' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-accordion.curve-shape .power-card-header>.power-btn-link[aria-expanded=false]' => 'color: {{VALUE}};',
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header>.power-btn-link[aria-expanded="false"] .power-accordion-title' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_accordion_background_close',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header>.power-btn-link,{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header>.power-btn-link.collapsed',
				]
			);
			$this->add_control(
				'peeao_accordion_curve_fill_close', [
					'label'      =>esc_html__( 'Background', 'power-elements' ),
					'type'       => Controls_Manager::COLOR,
					'condition' => [
						'peeao_accordion_style' => ['curve-shape']
					],
					'selectors'  => [
						'{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link .path' => 'fill: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'peeao_accordion_curve_stroke_close', [
					'label'      =>esc_html__( 'Border Color', 'power-elements' ),
					'type'       => Controls_Manager::COLOR,
					'condition' => [
						'peeao_accordion_style' => ['curve-shape']
					],
					'selectors'  => [
						'{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link .path' => 'stroke: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_accordion_title_border_close',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power-accordion .power-card .power-card-header > .power-btn-link[aria-expanded="false"],
					{{WRAPPER}} .peeao-wrapper .power-accordion .power-card:not(:last-child) .power-card-header > .power-btn-link[aria-expanded="false"]',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_border_radious_close',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'condition' => [
						'peeao_accordion_style!' => ['curve-shape']
					],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_accordion_box_shadow_close',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_control(
				'peeao_accordion_title_divide',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_title_padding',
				[
					'label' => esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px' ],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card-header>.power-btn-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_title_margin_bottom',
				[
					'label' => esc_html__( 'Margin Bottom', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => -10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => -1,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
	
			//Subtitle Style Section
			$this->start_controls_section(
				'peeao_accordion_section_content_style', [
					'label'	 =>esc_html__( 'Description', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_accordion_content_color', [
					'label'		 =>esc_html__( 'color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'default'   => '#586c85',
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-body p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power-accordion .power-card-body' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_content_typography',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card-body p, {{WRAPPER}} .power-accordion .power-card-body',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_accordion_content_background',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power-accordion .power-card-body, {{WRAPPER}} .accordion.floating-style .power-card-body',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_content_border_radious',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_content_padding',
				[
					'label' => esc_html__( 'Padding', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '30',
						'right' => '10',
						'bottom' => '30',
						'left' => '35',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_content_width',
				[
					'label' => esc_html__( 'Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ '%' ],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%',
						'size' => 90,
					],
					'selectors' => [
						'{{WRAPPER}} .power-accordion.floating-style .power-card-body' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'peeao_accordion_style' => 'floating-style'
					]
				]
			);
			$this->end_controls_section();
	
			//Slide border
			$this->start_controls_section(
				'peeao_accordion_section_border_style', [
					'label'	 =>esc_html__( 'Border', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'peeao_accordion_border_open',
					'label' => esc_html__( 'Border', 'power-elements' ),
					'fields_options' => [
						'border' => [
							'default' => 'solid',
						],
						'width' => [
							'default' => [
								'top' => '1',
								'right' => '1',
								'bottom' => '1',
								'left' => '1',
								'isLinked' => false,
							],
						],
						'color' => [
							'default' => '#000',
						],
					],
					'selector' => '{{WRAPPER}} .power-accordion > .power-card',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_border_radious_open',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .power-accordion > .power-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_accordion_element_box_shadow_group',
					'label' => esc_html__( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power-accordion > .power-card',
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_element_margin_bottom',
				[
					'label' => esc_html__( 'Margin Bottom', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => -10,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => -1,
					],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power-accordion .power-card:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
	
			//Left Icon Style Section
			$this->start_controls_section(
				'peeao_accordion_section_left_icon_style', 
				[
					'label'	 =>esc_html__( 'Left Icon', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['left', 'bothside']
					]
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_section_left_icon_margin',
				[
					'label' => esc_html__( 'Margin', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_accordion_style_tabs_left_icon'
			);
			$this->start_controls_tab(
				'peeao_accordion_left_icon_open_tab',
				[
					'label' => esc_html__( 'Close Icon', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_color_open', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-open.icon-left' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_left_icon_typography_open',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card-header .power-btn-link  .icon-left.icon-open',
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_border_color_open', [
					'label'		 =>esc_html__( 'Border Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left.icon-open' => 'border-color: {{VALUE}};'
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_left_icon_border_width_open',
				[
					'label' => esc_html__( 'Border Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 10,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 1,
					],
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left.icon-open' => 'border-width: {{SIZE}}{{UNIT}};'
					],
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_box_open_bg_hr',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
					'condition' => [
						'peeao_accordion_style' => 'accordion-4'
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_accordion_left_icon_box_open_bg',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power-accordion.accordion-4 .power-card-header .power-btn-link::before',
					'condition' => [
						'peeao_accordion_style' => 'accordion-4'
					]
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_accordion_left_icon_close_tab',
				[
					'label' => esc_html__( ' Open icon', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_color_close', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left.icon-closed' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_left_icon_typography_close',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card .power-card-header .power-btn-link .icon-left.icon-closed',
				]
			);
			$this->add_control(
				'peeao_accordion_left_icon_border_color_close', [
					'label'		 =>esc_html__( 'Border Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left.icon-closed' => 'border-color: {{VALUE}};'
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_left_icon_border_width_close',
				[
					'label' => esc_html__( 'Border Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 10,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 1,
					],
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-left.icon-closed' => 'border-width: {{SIZE}}{{UNIT}};'
					],
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_box_close_bg_hr',
				[
					'type' => Controls_Manager::DIVIDER,
					'style' => 'thick',
					'condition' => [
						'peeao_accordion_style' => 'accordion-4'
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_accordion_left_icon_box_close_bg',
					'label' => esc_html__( 'Background', 'power-elements' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power-accordion.accordion-4 .power-card-header .power-btn-link[aria-expanded="true"]::before',
					'condition' => [
						'peeao_accordion_style' => ['accordion-4']
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			//Right Icon Style Section
			$this->start_controls_section(
				'peeao_accordion_section_right_icon_style', 
				[
					'label'	 =>esc_html__( 'Right Icon', 'power-elements' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
					'condition' => [
						'peeao_accordion_icon_pos_style' => ['right', 'bothside']
					]
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_section_right_icon_margin',
				[
					'label' => esc_html__( 'Margin', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .peeao_accordion_icon_group' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'peeao_accordion_style_tabs_right_icon'
			);
			$this->start_controls_tab(
				'peeao_accordion_right_icon_open_tab',
				[
					'label' => esc_html__( 'Close Icon', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_color_open', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-open.icon-right' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_right_icon_typography_open',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card-header .power-btn-link  .icon-right.icon-open',
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_border_color_open', [
					'label'		 =>esc_html__( 'Border Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-right.icon-open' => 'border-color: {{VALUE}};'
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_right_icon_border_width_open',
				[
					'label' => esc_html__( 'Border Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 10,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 1,
					],
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-right.icon-open' => 'border-width: {{SIZE}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'peeao_accordion_right_icon_close_tab',
				[
					'label' => esc_html__( ' Open icon', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_color_close', [
					'label'		 =>esc_html__( 'Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-right.icon-closed' => 'color: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'peeao_accordion_right_icon_typography_close',
					'selector'	 => '{{WRAPPER}} .power-accordion .power-card .power-card-header .power-btn-link .icon-right.icon-closed',
				]
			);
			$this->add_control(
				'peeao_accordion_right_icon_border_color_close', [
					'label'		 =>esc_html__( 'Border Color', 'power-elements' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-right.icon-closed' => 'border-color: {{VALUE}};'
					],
				]
			);
			$this->add_responsive_control(
				'peeao_accordion_right_icon_border_width_close',
				[
					'label' => esc_html__( 'Border Width', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 10,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 1,
					],
					'selectors'	 => [
						'{{WRAPPER}} .power-accordion .power-card-header .power-btn-link .icon-right.icon-closed' => 'border-width: {{SIZE}}{{UNIT}};'
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
	
		}
	
		protected function render( ) {
	
			$settings = $this->get_settings();
			extract($settings);
			$acc_id = uniqid(); 
			?>
 
			<div class="peeao-wrapper"> 
				<div class="power-accordion <?php echo esc_attr( $peeao_accordion_style ); ?>" id="accordion-<?php echo esc_attr($acc_id); ?>">
					<?php foreach ($peeao_accordion_items as $i=>$accorion_content) :
						$collapse_show = ($accorion_content['peeao_acc_is_active'] == 'yes') ? ' show collapse' : ' collapse';
						$collapse_show = ($peeao_accordion_open_first_item == 'yes' && $accorion_content['peeao_acc_is_active'] != 'yes' && $i == 0) ? ' show collapse' : $collapse_show; ?>
						<div class="power-card">
							<div class="power-card-header" id="primaryHeading-<?php echo esc_attr($i); ?>">
								<a href="#Collapse-<?php echo esc_attr($accorion_content['_id'].$acc_id)?>" 
									class="power-btn-link <?php echo $settings['peeao_accordion_icon_pos_style'].'_icon'; ?>" 
									data-power-toggle="collapse" data-target="#Collapse-<?php echo esc_attr($accorion_content['_id'].$acc_id)?>" aria-expanded="<?php echo esc_attr($collapse_show == ' collapse' ? 'false' : 'true');  ?>" aria-controls="Collapse-<?php echo esc_attr($accorion_content['_id'].$acc_id)?>">
									<?php if(($peeao_accordion_icon_pos_style == 'left') || ($peeao_accordion_icon_pos_style == 'bothside')) :  ?>
										<?php  Icons_Manager::render_icon( $settings['peeao_accordion_left_icon'], [ 'aria-hidden' => 'true', 'class'    => 'icon-open icon-left' ] ); ?>
										<?php Icons_Manager::render_icon( $settings['peeao_accordion_left_icon_active'], [ 'aria-hidden' => 'true', 'class'    => 'icon-closed icon-left' ] ); ?>
									<?php  endif;
									if($peeao_accordion_display_loop_count == 'yes') :  ?><span class="power-accordion-number"></span><?php endif; ?>
									<span class="power-accordion-title"><?php echo esc_html($accorion_content['peeao_acc_title']); ?></span>
									<?php if(($peeao_accordion_icon_pos_style == 'right') || ($peeao_accordion_icon_pos_style == 'bothside')) :  ?>
										<div class="power_accordion_icon_group">
											<?php Icons_Manager::render_icon( $settings['peeao_accordion_right_icon'], [ 'aria-hidden' => 'true', 'class'    => 'icon-open icon-right' ] ); ?>
											<?php Icons_Manager::render_icon( $settings['peeao_accordion_right_icon_active'], [ 'aria-hidden' => 'true', 'class'    => 'icon-closed icon-right' ] ); ?>
										</div>
									<?php endif; ?>
									<?php if ( $peeao_accordion_style == 'curve-shape' ): ?>
										<svg version="1.1" class="svg-shape" x="0px" y="0px" viewBox="0 0 541 64" height="64" preserveAspectRatio="none">
											<polygon class="path" points="85,55 81,55 51,55 42.5,64 34,55 0,55 0,0 34.4,0 42.5,9.5 50.6,0 81,0 85,0 541,0 541,55 "/>
										</svg>
									<?php endif; ?>
								</a>
							</div>
							<div id="Collapse-<?php echo esc_attr($accorion_content['_id'].$acc_id)?>" class="<?php echo esc_attr($collapse_show); ?>" aria-labelledby="primaryHeading-<?php echo esc_attr($i); ?>" data-parent="#accordion-<?php echo esc_attr($acc_id); ?>">
								<div class="power-card-body">
									<?php if($accorion_content['peeao_acc_source'] == 'custom'){
										echo $accorion_content['peeao_acc_content'];
									}elseif($accorion_content['peeao_acc_source'] == 'nested_template'){
										echo Utils::get_builder_content($accorion_content['nested_template_id']) ; 
									} ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php }
		protected function _content_template() { }
	}