<?php
namespace PowerElements\Frontend\HeaderFooter;
use \PowerElements\Helpers\Utils as Utils;

if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );

class Init {

	public function __construct() {
		add_action( 'get_header', [ __CLASS__, 'set_header_content' ] );
		add_action( 'get_footer', [ __CLASS__, 'set_footer_content' ] );
    }

	public static function set_header_content() {
        $defaults = self::get_all_filtered_header_footer('header');
        
        if( empty($defaults) || is_404()){
            return;
        } 
        ?>

        <!DOCTYPE html>
        <html <?php language_attributes(); ?>>
        <head>
            <meta charset="<?php bloginfo( 'charset' ); ?>">
            <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
            <?php if ( ! current_theme_supports( 'title-tag' ) ) : ?>
                <title>
                    <?php echo wp_get_document_title(); ?>
                </title>
            <?php endif; ?>
            <?php wp_head(); ?>
        </head>
        <body <?php body_class(); ?>>
        <?php wp_body_open(); ?>
        <?php do_action('power_elements/before_header'); ?>
        <div class="peeao-wrapper">
            <?php echo Utils::get_builder_content($defaults[0]);?>
        </div> 
        <?php do_action('power_elements/after_header'); ?>

        <?php
		remove_all_actions( 'wp_head' );
		ob_start();
		locate_template( self::get_defaults('header'), true );
		ob_get_clean();

    }
    
	public static function set_footer_content() {
        $defaults = self::get_all_filtered_header_footer('footer');
        if( empty($defaults) || is_404()){
            return;
        } 
        ?>

        <?php do_action('power_elements/before_footer'); ?>
        <div class="peeao-wrapper">
            <?php echo Utils::get_builder_content($defaults[0]); ?>
        </div>
        <?php do_action('power_elements/after_footer'); ?>
        <?php wp_footer(); ?>
        </body>
        </html>

        <?php
		ob_start();
		locate_template( self::get_defaults('footer'), true );
		ob_get_clean();

	}

    public static function get_defaults($arg, $part=''){
        $defaults = [];
		$part = (string) $part;
		if ( '' !== $part ) {
			$defaults[] = "{$arg}-{$part}.php";
		}
        $defaults[] = "{$arg}.php";
        
        return $defaults;
    }


    public static function get_default_header_footer($term='header'){
        $term = 'peeao_'.$term.'_term';
        $args = [ 
            'post_type' => 'peeao_header_footer',
            'posts_per_page' => -1,
            'tax_query' => [   
                [
                    'taxonomy' => 'peeao_header_footer_cat',
                    'field' => 'slug',
                    'terms' => $term
                ]
            ],
            'meta_query' => [
                [   
                  'key'     => 'peeao_header_footer_action',  
                  'value'   => 'yes', 
                ]
            ]
        ];
        $query = new \WP_Query( $args );
        
        $defaults = [];
        if ( $query->have_posts() ) :
            while ( $query->have_posts() ) : $query->the_post();
                $defaults[] = get_the_ID();
            endwhile;
        endif;
        wp_reset_postdata();
        
        if( !empty($defaults)){
            return $defaults[0];
        }else{
            return '';
        }
    }
    public static function get_all_default_header_footer($term='header'){
        
        $term = 'peeao_'.$term.'_term';
        $args = [ 
            'post_type' => 'peeao_header_footer',
            'posts_per_page' => -1,
            'tax_query' => [   
                [
                    'taxonomy' => 'peeao_header_footer_cat',
                    'field' => 'slug',
                    'terms' => $term
                ]
            ],
            'meta_query' => [
                [   
                  'key'     => 'peeao_header_footer_action',  
                  'value'   => 'yes', 
                ]
            ]
        ];
        $query = new \WP_Query( $args );
        
        $defaults = [];
        if ( $query->have_posts() ) :
            while ( $query->have_posts() ) : $query->the_post();
                $defaults[] = get_the_ID();
            endwhile;
        endif;

        wp_reset_postdata();
        return $defaults;
    }


    public static function get_all_filtered_header_footer($term='header'){
        $templates = self::get_all_default_header_footer($term);
        $manual_arr = [];
        $group_arr = [];
        $all_arr = [];
        
        foreach($templates as $d){
            
            $show_on = get_post_meta( $d, 'peeao_header_footer_action_show_on', true);
            
            if($show_on == 'group'){
                $show_on_group = get_post_meta( $d, 'peeao_header_footer_action_show_on_group', true);
                if($show_on_group == 'all_pages'){
                    if(is_page()){
                        $group_arr[] = $d; 
                    }
                }elseif($show_on_group == 'all_posts'){
                    if(is_single()){
                        $group_arr[] = $d; 
                    }
                }elseif($show_on_group == 'search'){
                    if(is_search()){
                        $group_arr[] = $d; 
                    }
                }elseif($show_on_group == 'error'){
                    if(is_404()){
                        $group_arr[] = $d; 
                    } 
                }elseif($show_on_group == 'front'){
                    if( is_home() || is_front_page()){
                        $group_arr[] = $d; 
                    }
                }elseif($show_on_group == 'archive'){
                    if(is_archive()){
                        $group_arr[] = $d; 
                    }
                }elseif($show_on_group == 'all_inner'){
                    if( !is_home() || !is_front_page()){
                        $group_arr[] = $d; 
                    }
                }
            }
            
            if($show_on == 'manual'){
                $show_on_manual = get_post_meta( $d, 'peeao_header_footer_action_show_on_manual', true);
                if($show_on_manual == get_the_ID()){
                    $manual_arr[] = $d; 
                }
            }
            
            if($show_on == 'all'){
                 $all_arr[] = $d;
            }
        }
        
        return array_merge($manual_arr, $group_arr, $all_arr);

    }

    public static function get_specific_header_footer($term='header'){
        $defaults = self::get_all_filtered_header_footer($term);
        if( !empty($defaults)){
            return $defaults[0];
        }else{
            return '';
        }
    }
}