<?php
namespace PowerElements\Admin\Menu;
 
defined( 'ABSPATH' ) || die();

class Init { 
    private static $page_slug	 = 'power-elements-dashboard';
    static $menu_slug = '';

    public function __construct() {
            
        add_action( 'admin_menu', [ __CLASS__, 'add_menu' ], 21 );
        add_action( 'admin_menu', [ __CLASS__, 'update_menu_items' ], 99 );
        add_action( 'admin_enqueue_scripts', [ __CLASS__, 'enqueue_scripts' ] );
         
    }
    
    public static function enqueue_scripts( $hook ) {
        if ( self::$menu_slug !== $hook || ! current_user_can( 'manage_options' ) ) {
            return;
        }

        wp_enqueue_style(
            'power-elements-framework',
            POWER_ELEMENTS_CSS_DIR_URL . '/libraries.min.css',  
            null,
            '1.0'
        );
        
        wp_enqueue_style(
            'power-elements-font-awesome',
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/font-awesome.min.css',
            null,
            '1.0'
        );
        wp_enqueue_style(
            'power-elements-admin',
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/admin.min.css',
            null,
            '1.0'
        );
        wp_enqueue_script(
            'power-elements-dashboard-bootstrap',
            POWER_ELEMENTS_ADMIN_JS_DIR_URL . '/bootstrap.min.js',
            [ 'jquery' ],
            '1.0',
            true
        );
        wp_enqueue_script(
            'power-elements-admin',
            POWER_ELEMENTS_ADMIN_JS_DIR_URL . '/admin.min.js',
            [ 'jquery' ],
            '1.0',
            true
        );

    }
    public static function add_menu() {
        self::$menu_slug = add_menu_page(
            __( 'Power Elements Dashboard', 'power-elements' ),
            __( 'Power Elements', 'power-elements' ),
            'manage_options',
            self::$page_slug,
            [ __CLASS__, 'render_main' ],
            POWER_ELEMENTS_IMG_DIR_URL .'/fav.png',
            2
        );
        // add_submenu_page(
        //     self::$page_slug,
        //     sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'My Templates' ),
        //     'My Templates',
        //     'manage_options',
        //     home_url('/').'wp-admin/edit.php?post_type=peeao_template&admin_tab=power_templates'
        // );
        add_submenu_page(
            self::$page_slug,
            sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Header Footer' ),
            'Header Footer',
            'manage_options',
            home_url('/').'wp-admin/edit.php?post_type=peeao_header_footer&admin_tab=header_footer'
        );
        add_submenu_page(
            self::$page_slug,
            sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Nested Templates' ),
            'Nested Templates',
            'manage_options',
            home_url('/').'wp-admin/edit.php?post_type=peeao_nested&admin_tab=nested'
        );
        add_submenu_page(
            self::$page_slug,
            sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Blocks' ),
            'Blocks',
            'manage_options',
            home_url('/').'wp-admin/edit.php?post_type=peeao_block&admin_tab=block'
        );
        add_submenu_page(
            self::$page_slug,
            sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Widgets' ),
            'Widgets',
            'manage_options',
            self::$page_slug . '&admin_tab=widgets',
            [ __CLASS__, 'render_main' ]
        );


        do_action('power_admin_menu',self::$page_slug);



        // add_submenu_page(
        //     self::$page_slug,
        //     sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Forms' ),
        //     'Forms',
        //     'manage_options',
        //     home_url('/').'wp-admin/edit.php?post_type=peeao_form&admin_tab=form'
        // );
        // add_submenu_page(
        //     self::$page_slug,
        //     sprintf( __( '%s - Power Elements Elementor Addons', 'power-elements' ), 'Integrations' ),
        //     'Integrations',
        //     'manage_options',
        //     self::$page_slug . '&admin_tab=integrations',
        //     [ __CLASS__, 'render_main' ]
        // );
    }
    public static function update_menu_items() {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        global $submenu;
        $menu = $submenu[ self::$page_slug ];
        array_shift( $menu );
        $submenu[ self::$page_slug ] = $menu;
    }
    public static function get_tabs() {
        $tabs = [
            'widgets' => [
                'title' => esc_html__( 'Widgets', 'power-elements' ),
                'render' => [ __CLASS__, 'render_widgets' ]
            ],
        ];

        return apply_filters( 'psb_dashboard_get_tabs', $tabs );
    }

    private static function load_template( $template ) { 

        $file = POWER_ELEMENTS_MENU_DIR_PATH . '/view/' . $template . '.php';
        if ( is_readable( $file ) ) {
            include( $file );
        }
        
    }

    public static function render_main() {
        self::load_template( 'main' );
    }
    public static function render_home() {
        self::load_template( 'home' );
    }
    public static function render_widgets() {
        self::load_template( 'widgets' );
    }
    public static function render_integrations() {
        self::load_template( 'integrations' );
    }
    public static function render_templates() {
        self::load_template( 'templates' );
    }
    public static function render_tabs($template) {
        self::load_template( $template );
    }
}
