var PowerBlogCarouselHandler = function ($scope) {
	var $controller = $scope.find(".power_blogcarousel");
	var $outside_grid_owl_prev = $scope.find(".power_outside_grid_owl_prev");
	var $outside_grid_owl_next = $scope.find(".power_outside_grid_owl_next");
	if ($controller.length) {
		$controller.each(function (index, _el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
			$outside_grid_owl_prev.on("click", function () {
				$controller.trigger('prev.owl.carousel');
			});
			$outside_grid_owl_next.on("click", function () {
				$controller.trigger('next.owl.carousel');
			});
		});
	}
}
var PowerCarouselHandler = function ($scope) {
	var $controller = $scope.find(".power_carousel");
	if ($controller.length) {
		$controller.each(function (index, el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
var PowerCircleProgressbarHandler = function ($scope) {
	var $controller = $scope.find(".power_progress_circular");
	var max = -219.99078369140625;
	jQuery.each($controller, function (index, value) {
		percent = value.getAttribute('data-progress');
		circle_postfix = value.getAttribute('data-postfix');
		value.querySelector('.power_progress_circular_fill').setAttribute('style', 'stroke-dashoffset: ' + ((100 - percent) / 100) * max);
		value.querySelector('.power_progress_circular_value').innerHTML = percent + circle_postfix;
	});
} 
var PowerFunfactHandler = function ($scope) {
	var $controller = $scope.find(".power_fun_number");
	jQuery.each($controller, function (index, value) {
		jQuery(this).prop('Counter', 0).animate({
			Counter: jQuery(this).text()
		}, {
			duration: 4000,
			easing: 'swing',
			step: function (now) {
				jQuery(this).text(Math.ceil(now));
			}
		});
	});
}
var PowerNavMenuHandler = function ($scope) {
	// menu js start
	jQuery.fn.menumaker = function (options) {
		var powermenu = jQuery(this), settings = jQuery.extend({
			format: 'dropdown',
			sticky: false
		}, options);
		return this.each(function () {
			jQuery(this).find('.mobile-btn').on('click', function () {
				jQuery(this).toggleClass('menu-opened');
				var mainmenu = jQuery(this).next('ul');
				if (mainmenu.hasClass('open')) {
					mainmenu.slideToggle().removeClass('open');
				} else {
					mainmenu.slideToggle().addClass('open');
					if (settings.format === 'dropdown') {
						mainmenu.find('ul').show();
					}
				}
			});
			powermenu.find('li ul').parent().addClass('menu-item-has-children');
			var subToggle;
			subToggle = function () {
				powermenu.find('.menu-item-has-children').prepend('<span class="submenu-button"></span>');
				powermenu.find('.menu-item-has-children>a').append('<i class="ion-ios-arrow-down"></i>');
				powermenu.find('.submenu-button').on('click', function () {
					jQuery(this).toggleClass('submenu-opened');
					if (jQuery(this).siblings('ul').hasClass('open')) {
						jQuery(this).siblings('ul').removeClass('open').slideToggle();
					} else {
						jQuery(this).siblings('ul').addClass('open').slideToggle();
					}
				});
			};
			if (settings.format === 'multitoggle')
				subToggle();
			else
				powermenu.addClass('dropdown');
			if (settings.sticky === true)
				powermenu.css('position', 'fixed');
			var resizeFix;
			resizeFix = function () {
				var mediasize = 768;
				if (jQuery(window).width() > mediasize) {
					powermenu.find('ul').show();
				}
				if (jQuery(window).width() <= mediasize) {
					powermenu.find('ul').hide().removeClass('open');
				}
			};
			resizeFix();
			return jQuery(window).on('resize', resizeFix);
		});
	};

	var $controller = $scope.find("#powermenu");
	$controller.menumaker({ format: 'multitoggle' });
	// menu js end

	// Search bar open
	jQuery('a.search_icon').on('click', function (e) {
		e.preventDefault();
		jQuery('.search_overlay').toggleClass('active');
	});
	jQuery('.closebtn').on('click', function (e) {
		e.preventDefault();
		jQuery('.search_overlay').removeClass('active');
	});
}
var PowerPortfolioCarouselHandler = function ($scope) {
	var $controller = $scope.find(".power_portfoliocarousel");
	if ($controller.length) {
		$controller.each(function (index, el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
var PowerPortfolioFilterHandler = function ($scope) {
	var $controller = $scope.find(".power_portfolio_filter");

	jQuery(window).load(function () {
		var $grid = $controller.find('.power_portfolio_wrapper').isotope({
			itemSelector: '.power_portfolio_filter_item',
			percentPosition: true,
			layoutMode: 'fitRows',
			masonry: {
				columnWidth: '.grid-sizer'
			}
		});

		var iso = $grid.data('isotope');

		var $filterCount = $controller.find('.filter-count');

		// bind filter button click

		$controller.find('.power_portfolio_button_group .power_portfolio_button').on('click', function () {
			var filterValue = jQuery(this).attr('data-filter');
			// use filterFn if matches value
			$grid.isotope({ filter: filterValue });
			updateFilterCount();
		});

		function updateFilterCount() {
			if (typeof iso != 'undefined' || iso != null) {
				$filterCount.text(iso.filteredItems.length);
			}
		}
		// change is-checked class on buttons
		$controller.find('.power_portfolio_button_group').each(function (i, buttonGroup) {
			var $buttonGroup = jQuery(buttonGroup);
			$buttonGroup.on('click', 'button', function () {
				$buttonGroup.find('.is-checked').removeClass('is-checked');
				jQuery(this).addClass('is-checked');
			});
		});

	});
}
var PowerTabHandler = function ($scope) {
	var $controller = $scope.find(".power_tab_nav");
	$controller.find('> .power_tab_button_group > li > a').eq(0).addClass("selected");
	$controller.find('> .power_tab_container > .power_tab_info').eq(0).css('display', 'block');

	$controller.find('>.power_tab_button_group').on("click", function (e) {

		if (jQuery(e.target).is("a")) {

			/*Handle Tab Nav*/
			$controller.find('> .power_tab_button_group > li > a').removeClass("selected");
			jQuery(e.target).addClass("selected");

			/*Handles Tab Content*/
			var clicked_index = jQuery("a", this).index(e.target);
			$controller.find('> .power_tab_container > .power_tab_info').css('display', 'none');
			$controller.find('> .power_tab_container > .power_tab_info').eq(clicked_index).fadeIn();

		}

		jQuery(this).blur();
		return false;

	});
}
var PowerTeamCarouselHandler = function ($scope) {
	var $controller = $scope.find(".power_teamcarousel");
	if ($controller.length) {
		$controller.each(function (index, el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
var PowerSliderHandler = function ($scope) {
	var $controller = $scope.find(".power_slider");
	if ($controller.length) {
		$controller.each(function (index, el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
var PowerTestimonialCarouselHandler = function ($scope) {
	var $controller = $scope.find(".power_testimonialcarousel");
	if ($controller.length) {
		$controller.each(function (index, el) {
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
var PowerVideoHandler = function ($scope) {
	var $controller = $scope.find(".power_video_popup");
	if ($controller.length > 0) {
		$controller.magnificPopup({
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: true,
			fixedContentPos: false,
		});
	}
}

var PowerInstafeedHandler = function ($scope) {
	var $controller = $scope.find("#power-instafeed-gallery");

	if ($controller.length > 0) {
		$controller.each(function () {

			var limit = jQuery(this).data('limit'),
				columns = jQuery(this).data('columns'),
				access_token = jQuery(this).data('access_token'),
				user_id = jQuery(this).data('user_id'),
				enable_carousel = jQuery(this).data('enable_carousel'),
				gutter = jQuery(this).data('gutter'),
				get = "user",
				resolution = "standard_resolution",
				useHttp = "true";

			$controller.children().css({"padding": gutter + "px"});
			console.log($controller.children());
			var galleryFeedCarousel = new Instafeed({
				get: get,
				userId: user_id,
				accessToken: access_token,
				resolution: resolution,
				useHttp: useHttp,
				limit: limit,
				target: "power-instafeed-gallery",
				after: function () {
					var instafeed = jQuery(".indtafeed-slide");
					instafeed.owlCarousel({
						loop: true,
						dots: true,
						margin: 3,
						responsive: {
							0: {
								items: 1
							},
							200: {
								items: 2
							},
							400: {
								items: 3
							},
							768: {
								items: columns
							}
						}
					});
				}
			});

			var galleryFeed = new Instafeed({
				get: get,
				userId: user_id,
				accessToken: access_token,
				resolution: resolution,
				useHttp: useHttp,
				limit: limit,
				target: "power-instafeed-gallery",
			});

			if (enable_carousel == 'yes') {
				galleryFeedCarousel.run();
			} else {
				galleryFeed.run();
			}

		});
	}
}
var PowerStickyHandler = function ($scope) {
	$isSticky = $scope.hasClass("power-sticky-section");
	if ($isSticky) {
		jQuery(window).scroll(function () {
			if (jQuery(window).scrollTop() > 0) {
				$scope.addClass('sticky')
			} else {
				$scope.removeClass('sticky')
			}
		})
	}
}
var PowerHeadingHandler = function ($scope) {
	$container = $scope.find(".power_heading_wrapper");

	$power_typed = ".power_typed";
	$power_typed_string = ".power-typed-strings";

	if ($power_typed.length) {
		$container.find(".power_typed").each(function (index, el) {
			console.log($power_typed);
			console.log($power_typed_string);

			var typed = new Typed($power_typed, {
				stringsElement: $power_typed_string,
				typeSpeed: 200,
				backSpeed: 100,
				fadeOut: false,
				loop: true, 
				cursorChar: '.',
			});
		});
	}
}
var PowerCausesCarouselHandler = function ($scope) {
	var $controller = $scope.find(".windzfare_causes_carousel");
	if ($controller.length) {
		$controller.each(function (index, el) {
			console.log($controller.data('owl-carousel'));
			$controller.owlCarousel($controller.data('owl-carousel'));
		});
	}
}
jQuery(window).on("elementor/frontend/init", function () {
	var widgets = {
		'power_elements_heading.default': PowerHeadingHandler,
		'power_elements_blog_carousel.default': PowerBlogCarouselHandler,
		'power_elements_carousel.default': PowerCarouselHandler,
		'power_elements_circle_progress.default': PowerCircleProgressbarHandler,
		'power_element_funfact.default': PowerFunfactHandler,
		'power_elements_nav_menu.default': PowerNavMenuHandler,
		'power_elements_portfolio_filter.default': PowerPortfolioFilterHandler,
		'power_elements_portfolio_carousel.default': PowerPortfolioCarouselHandler,
		'power_elements_tabs.default': PowerTabHandler,
		'power_elements_team_carousel.default': PowerTeamCarouselHandler,
		'power_elements_slider.default': PowerSliderHandler,
		'power_elements_testimonial_carousel.default': PowerTestimonialCarouselHandler,
		'power_elements_instafeed.default': PowerInstafeedHandler,
		'power_elements_video.default': PowerVideoHandler,
		'power_elements_campaigns_carousel.default': PowerCausesCarouselHandler,
		'section': PowerStickyHandler
	};
	jQuery.each(widgets, function (widget, callback) {
		elementorFrontend.hooks.addAction('frontend/element_ready/' + widget, callback);
	});
});