! function(e) {
    "use strict";
    var t, i, n, a = window.powerElementsLibreryData || {};
    i = {
        LibraryLayoutView: null,
        LibraryHeaderView: null,
        LibraryLoadingView: null,
        LibraryErrorView: null,
        LibraryBodyView: null,
        LibraryCollectionView: null,
        FiltersCollectionView: null,
        LibraryTabsCollectionView: null,
        LibraryTabsItemView: null,
        FiltersItemView: null,
        LibraryTemplateItemView: null,
        LibraryInsertTemplateBehavior: null,
        LibraryTabsCollection: null,
        LibraryCollection: null,
        CategoriesCollection: null,
        LibraryTemplateModel: null,
        CategoryModel: null,
        TabModel: null,
        KeywordsModel: null,
        KeywordsView: null,
        LibraryPreviewView: null,
        LibraryHeaderBack: null,
        LibraryHeaderInsertButton: null,
        LibraryProButton: null,
        init: function() {
            var e = this;
            e.LibraryTemplateModel = Backbone.Model.extend({
                defaults: {
                    template_id: 0,
                    name: "",
                    title: "",
                    thumbnail: "",
                    preview: "",
                    source: "",
                    package: "",
                    livelink: "",
                    categories: [],
                    keywords: []
                }
            }), e.CategoryModel = Backbone.Model.extend({
                defaults: {
                    slug: "",
                    title: ""
                }
            }), e.CategoryModel = Backbone.Model.extend({
                defaults: {
                    slug: "",
                    title: ""
                }
            }), e.TabModel = Backbone.Model.extend({
                defaults: {
                    slug: "",
                    title: ""
                }
            }), e.KeywordsModel = Backbone.Model.extend({
                defaults: {
                    keywords: {}
                }
            }), e.LibraryCollection = Backbone.Collection.extend({
                model: e.LibraryTemplateModel
            }), e.CategoriesCollection = Backbone.Collection.extend({
                model: e.CategoryModel
            }), e.LibraryTabsCollection = Backbone.Collection.extend({
                model: e.TabModel
            }), e.LibraryLoadingView = Marionette.ItemView.extend({
                id: "power-template-library-loading",
                template: "#view-power-loading"
            }), e.LibraryErrorView = Marionette.ItemView.extend({
                id: "power-template-library-error",
                template: "#view-power-error"
            }), e.LibraryHeaderView = Marionette.LayoutView.extend({ 
                id: "power-template-library-header",
                template: "#view-power-header",
                ui: {
                    closeModal: "#power-template-library-header-close-modal"
                },
                events: {
                    "click @ui.closeModal": "onCloseModalClick"
                },
                regions: {
                    headerTabs: "#power-template-library-header-tabs",
                    headerActions: "#power-template-library-header-actions"
                },
                onCloseModalClick: function() {
                    t.closeModal()
                }
            }), e.LibraryPreviewView = Marionette.ItemView.extend({
                template: "#view-power-preview",
                id: "power-template-library-preview",
                ui: {
                    img: "img"
                },
                onRender: function() {
                    this.ui.img.attr("src", this.getOption("preview"))
                }
            }), e.LibraryHeaderBack = Marionette.ItemView.extend({
                template: "#view-power-header-back",
                id: "power-template-library-header-back",
                ui: {
                    button: "button"
                },
                events: {
                    "click @ui.button": "onBackClick"
                },
                onBackClick: function() {
                    t.setPreview("back")
                }
            }), e.LibraryInsertTemplateBehavior = Marionette.Behavior.extend({
                ui: {
                    insertButton: ".power-template-library-template-insert"
                },
                events: {
                    "click @ui.insertButton": "onInsertButtonClick"
                },
                onInsertButtonClick: function() {
                    var e = this.view.model,
                        i = {};
                    t.layout.showLoadingView(), elementor.templates.requestTemplateContent(e.get("source"), e.get("template_id"), {
                        data: {
                            tab: t.getTab(),
                            page_settings: !0
                        },
                        success: function(n) {
                            n.licenseError ? t.layout.showLicenseError() : (t.closeModal(), elementor.channels.data.trigger("template:before:insert", e), null !== t.atIndex && (i.at = t.atIndex), elementor.sections.currentView.addChildModel(n.content, i), n.page_settings && elementor.settings.page.model.set(n.page_settings), elementor.channels.data.trigger("template:after:insert", e), t.atIndex = null)
                        }
                    })
                }
            }), e.LibraryHeaderInsertButton = Marionette.ItemView.extend({
                template: "#view-power-insert-button",
                id: "power-template-library-insert-button",
                behaviors: {
                    insertTemplate: {
                        behaviorClass: e.LibraryInsertTemplateBehavior
                    }
                }
            }), e.LibraryProButton = Marionette.ItemView.extend({
                template: "#view-power-pro-button",
                id: "power-template-library-pro-button"
            }), e.LibraryTemplateItemView = Marionette.ItemView.extend({
                template: "#view-power-item",
                className: function() {
                    var e = " power-template-has-url",
                        t = " elementor-template-library-template-";
                    return "" === this.model.get("preview") && (e = " power-template-no-url"), "power-local" === this.model.get("source") ? t += "local" : t += "remote", "elementor-template-library-template" + t + e
                },
                ui: function() {
                    return {
                        previewButton: ".elementor-template-library-template-preview"
                    }
                },
                events: function() {
                    return {
                        "click @ui.previewButton": "onPreviewButtonClick"
                    }
                },
                onPreviewButtonClick: function() {
                    "" !== this.model.get("preview") && t.setPreview(this.model)
                },
                behaviors: {
                    insertTemplate: {
                        behaviorClass: e.LibraryInsertTemplateBehavior
                    }
                }
            }), e.FiltersItemView = Marionette.ItemView.extend({
                template: "#view-power-filters-item",
                className: function() {
                    return "power-filter-item"
                },
                ui: function() {
                    return {
                        filterLabels: ".power-template-library-filter-label"
                    }
                },
                events: function() {
                    return {
                        "click @ui.filterLabels": "onFilterClick"
                    }
                },
                onFilterClick: function(e) {
                    var i = jQuery(e.target);
                    t.setFilter("category", i.val())
                }
            }), e.LibraryTabsItemView = Marionette.ItemView.extend({
                template: "#view-power-tabs-item",
                className: function() {
                    return "elementor-template-library-menu-item"
                },
                ui: function() {
                    return {
                        tabsLabels: "label",
                        tabsInput: "input"
                    }
                },
                events: function() {
                    return {
                        "click @ui.tabsLabels": "onTabClick"
                    }
                },
                onRender: function() {
                    this.model.get("slug") === t.getTab() && this.ui.tabsInput.attr("checked", "checked")
                },
                onTabClick: function(e) {
                    var i = jQuery(e.target);
                    t.setTab(i.val()), t.setFilter("keyword", "")
                }
            }), e.LibraryCollectionView = Marionette.CompositeView.extend({
                template: "#view-power-templates",
                id: "power-template-library-templates",
                childViewContainer: "#power-template-library-templates-container",
                initialize: function() {
                    this.listenTo(t.channels.templates, "filter:change", this._renderChildren)
                },
                filter: function(e) {
                    var i = t.getFilter("category"),
                        n = t.getFilter("keyword");
                    return !i && !n || (n && !i ? _.contains(e.get("keywords"), n) : i && !n ? _.contains(e.get("categories"), i) : _.contains(e.get("categories"), i) && _.contains(e.get("keywords"), n))
                },
                getChildView: function(t) {
                    return e.LibraryTemplateItemView
                },
                onRenderCollection: function() {
                    var i = this.$childViewContainer,
                        n = this.$childViewContainer.children(),
                        a = t.getTab();
                    "power_page" !== a && "local" !== a && setTimeout(function() {
                        e.masonry.init({
                            container: i,
                            items: n
                        })
                    }, 200)
                }
            }), e.LibraryTabsCollectionView = Marionette.CompositeView.extend({
                template: "#view-power-tabs",
                childViewContainer: "#power-template-library-tabs-items",
                initialize: function() {},
                getChildView: function(t) {
                    return e.LibraryTabsItemView
                }
            }), e.FiltersCollectionView = Marionette.CompositeView.extend({
                id: "power-template-library-filters",
                template: "#view-power-filters",
                childViewContainer: "#power-template-library-filters-container",
                getChildView: function(t) {
                    return e.FiltersItemView
                }
            }), e.LibraryBodyView = Marionette.LayoutView.extend({
                id: "power-template-library-content",
                className: function() {
                    return "library-tab-" + t.getTab()
                },
                template: "#view-power-content",
                regions: {
                    contentTemplates: ".power-templates-list",
                    contentFilters: ".power-filters-list",
                    contentKeywords: ".power-keywords-list"
                }
            }), e.LibraryLayoutView = Marionette.LayoutView.extend({
                el: "#power-template-library-modal",
                regions: a.modalRegions,
                initialize: function() {
                    this.getRegion("modalHeader").show(new e.LibraryHeaderView), this.listenTo(t.channels.tabs, "filter:change", this.switchTabs), this.listenTo(t.channels.layout, "preview:change", this.switchPreview)
                },
                switchTabs: function() {
                    this.showLoadingView(), t.setFilter("keyword", ""), t.requestTemplates(t.getTab())
                },
                switchPreview: function() {
                    var i = this.getHeaderView(),
                        n = t.getPreview();
                    if ("back" === n) return i.headerTabs.show(new e.LibraryTabsCollectionView({
                        collection: t.collections.tabs
                    })), i.headerActions.empty(), void t.setTab(t.getTab());
                    "initial" !== n ? (this.getRegion("modalContent").show(new e.LibraryPreviewView({
                        preview: n.get("preview")
                    })), i.headerTabs.show(new e.LibraryHeaderBack), "pro" != n.get("package") ? i.headerActions.show(new e.LibraryHeaderInsertButton({
                        model: n
                    })) : i.headerActions.show(new e.LibraryProButton({
                        model: n
                    }))) : i.headerActions.empty()
                },
                getHeaderView: function() {
                    return this.getRegion("modalHeader").currentView
                },
                getContentView: function() {
                    return this.getRegion("modalContent").currentView
                },
                showLoadingView: function() {
                    this.modalContent.show(new e.LibraryLoadingView)
                },
                showLicenseError: function() {
                    this.modalContent.show(new e.LibraryErrorView)
                },
                showTemplatesView: function(i, n, a) {
                    this.getRegion("modalContent").show(new e.LibraryBodyView);
                    var l = this.getContentView(),
                        r = this.getHeaderView();
                    new e.KeywordsModel({
                        keywords: a
                    });
                    t.collections.tabs = new e.LibraryTabsCollection(t.getTabs()), r.headerTabs.show(new e.LibraryTabsCollectionView({
                        collection: t.collections.tabs
                    })), l.contentTemplates.show(new e.LibraryCollectionView({
                        collection: i
                    })), l.contentFilters.show(new e.FiltersCollectionView({
                        collection: n
                    }))
                }
            })
        },
        masonry: {
            self: {},
            elements: {},
            init: function(t) {
                this.settings = e.extend(this.getDefaultSettings(), t), this.elements = this.getDefaultElements(), this.run()
            },
            getSettings: function(e) {
                return e ? this.settings[e] : this.settings
            },
            getDefaultSettings: function() {
                return {
                    container: null,
                    items: null,
                    columnsCount: 3,
                    verticalSpaceBetween: 30
                }
            },
            getDefaultElements: function() {
                return {
                    $container: jQuery(this.getSettings("container")),
                    $items: jQuery(this.getSettings("items"))
                }
            },
            run: function() {
                var e = [],
                    t = this.elements.$container.position().top,
                    i = this.getSettings(),
                    n = i.columnsCount;
                t += parseInt(this.elements.$container.css("margin-top"), 10), this.elements.$container.height(""), this.elements.$items.each(function(a) {
                    var l = Math.floor(a / n),
                        r = a % n,
                        o = jQuery(this),
                        s = o.position(),
                        c = o[0].getBoundingClientRect().height + i.verticalSpaceBetween;
                    if (l) {
                        var m = s.top - t - e[r];
                        m -= parseInt(o.css("margin-top"), 10), m *= -1, o.css("margin-top", m + "px"), e[r] += c
                    } else e.push(c)
                }), this.elements.$container.height(Math.max.apply(Math, e))
            }
        }
    }, n = {
        PowerSearchView: null,
        init: function() {
            this.PowerSearchView = window.elementor.modules.controls.BaseData.extend({
                onReady: function() {
                    var t = this.model.attributes.action,
                        i = this.model.attributes.query_params;
                    this.ui.select.find("option").each(function(t, i) {
                        e(this).attr("selected", !0)
                    }), this.ui.select.select2({
                        ajax: {
                            url: function() {
                                var n = "";
                                return i.length > 0 && e.each(i, function(e, t) {
                                    window.elementor.settings.page.model.attributes[t] && (n += "&" + t + "=" + window.elementor.settings.page.model.attributes[t])
                                }), ajaxurl + "?action=" + t + n
                            },
                            dataType: "json"
                        },
                        placeholder: "Please enter 3 or more characters",
                        minimumInputLength: 3
                    })
                },
                onBeforeDestroy: function() {
                    this.ui.select.data("select2") && this.ui.select.select2("destroy"), this.$el.remove()
                }
            }), window.elementor.addControlView("power_search", this.PowerSearchView)
        }
    }, t = {
        modal: !1,
        layout: !1,
        collections: {},
        tabs: {},
        defaultTab: "",
        channels: {},
        atIndex: null,
        init: function() {
            window.elementor.on("preview:loaded", window._.bind(t.onPreviewLoaded, t)), i.init(), n.init()
        },
        onPreviewLoaded: function() {
            var e = this,
                t = setInterval(function() {
                    e.initPowerButton(), window.elementor.$previewContents.find(".elementor-add-new-section").length > 0 && clearInterval(t)
                }, 100);
            window.elementor.$previewContents.on("click.addPowerTemplate", ".add-power-template", _.bind(this.showTemplatesModal, this)), this.channels = {
                templates: Backbone.Radio.channel("POWER_EDITOR:templates"),
                tabs: Backbone.Radio.channel("POWER_EDITOR:tabs"),
                layout: Backbone.Radio.channel("POWER_EDITOR:layout")
            }, this.tabs = a.tabs, this.defaultTab = a.defaultTab
        },
        initPowerButton: function() {
            var i = window.elementor.$previewContents.find(".elementor-add-new-section"),
                n = '<button class="add-power-template peeao-wrapper" type="button"><i class="icon icon-power"></i></button>';
            i.length && a.libraryButton && e(n).prependTo(i), window.elementor.$previewContents.on("click.addPowerTemplate", ".elementor-editor-section-settings .elementor-editor-element-add", function() {
                var i = e(this).closest(".elementor-top-section"),
                    l = i.data("model-cid");
                (window.elementor.sections.currentView.collection.length && e.each(window.elementor.sections.currentView.collection.models, function(e, i) {
                    l === i.cid && (t.atIndex = e)
                }), a.libraryButton) && i.prev(".elementor-add-section").find(".elementor-add-new-section").prepend(n)
            })
        },
        getFilter: function(e) {
            return this.channels.templates.request("filter:" + e)
        },
        setFilter: function(e, t) {
            this.channels.templates.reply("filter:" + e, t), this.channels.templates.trigger("filter:change")
        },
        getTab: function() {
            return this.channels.tabs.request("filter:tabs")
        },
        setTab: function(e, t) {
            this.channels.tabs.reply("filter:tabs", e), t || this.channels.tabs.trigger("filter:change")
        },
        getTabs: function() {
            var e = [];
            return _.each(this.tabs, function(t, i) {
                e.push({
                    slug: i,
                    title: t.title
                })
            }), e
        },
        getPreview: function(e) {
            return this.channels.layout.request("preview")
        },
        setPreview: function(e, t) {
            this.channels.layout.reply("preview", e), t || this.channels.layout.trigger("preview:change")
        },
        getKeywords: function() {
            return _.each(this.keywords, function(e, t) {
                tabs.push({
                    slug: t,
                    title: e
                })
            }), []
        },
        showTemplatesModal: function() {
            this.getModal().show(), this.layout || (this.layout = new i.LibraryLayoutView, this.layout.showLoadingView()), this.setTab(this.defaultTab, !0), this.requestTemplates(this.defaultTab), this.setPreview("initial")
        },
        requestTemplates: function(t) {
            var n = this,
                a = n.tabs[t];
            n.setFilter("category", !1), a.data.templates && a.data.categories ? n.layout.showTemplatesView(a.data.templates, a.data.categories, a.data.keywords) : e.ajax({
                url: ajaxurl,
                type: "get",
                dataType: "json",
                data: {
                    action: "power_elements_get_layouts",
                    tab: t
                },
                success: function(e) {
                    var a = new i.LibraryCollection(e.data.templates),
                        l = new i.CategoriesCollection(e.data.categories);
                    n.tabs[t].data = {
                        templates: a,
                        categories: l,
                        keywords: e.data.keywords
                    }, n.layout.showTemplatesView(a, l, e.data.keywords)
                }
            })
        }, 
        closeModal: function() {
            this.getModal().hide()
        },
        getModal: function() {
            return this.modal || (this.modal = elementor.dialogsManager.createWidget("lightbox", {
                id: "power-template-library-modal",
                closeButton: !1
            })), this.modal
        }
    }, e(window).on("elementor:init", t.init)
}(jQuery);