<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class Power_Elements_Price_Table extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_price_table';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Price Table', 'power_elements_elementor' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-price-table';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * ADD Widget CSS
		 */
		
		public function get_style_depends() {
			return [ 'power-element-price-table' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'power_element_pricetable_content',
				[
					'label' => __( 'Pricetable Content', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'pt_style',
				[
					'label'   => __( 'Style', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'default' => 'style_1',
					'options' => [
						'style_1' => __( 'Style 1', 'power_elements_elementor' ),
						'style_2' => __( 'Style 2', 'power_elements_elementor' )
					]
				]
			);
			$this->add_responsive_control(
				'ribbon_align',
				[
					'label'   => __( 'Ribbon Alignment', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'ribbon_1' => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'ribbon_2' => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						],
					],
					'default' => 'ribbon_1'
				]
			);
			$this->add_control(
				'ribbon_text',
				[
					'label'       => __( 'Ribbon Text', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Ribbon text', 'power_elements_elementor' ),
					'placeholder' => __( 'Ribbon text please', 'power_elements_elementor' ),
					'selectors'   => [
						'{{WRAPPER}} .power_pricetable_header:before' => 'content:"{{VALUE}}";',
					],
				]
			);
			$this->add_control(
				'header_top',
				[
					'label'     => __( 'Header Top Section', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'top_title',
				[
					'label'       => __( 'Top Title', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Basic', 'power_elements_elementor' ),
					'placeholder' => __( 'Main title please', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'top_sub_title',
				[
					'label'       => __( 'Top Subtitle', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => __( 'Let Us Help You Grow Business', 'power_elements_elementor' ),
					'placeholder' => __( 'Subtitle please, if want hide leave empty.', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'top_icon',
				[
					'label'       => __( 'Icon', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::ICON,
					'label_block' => true,
					'default'     => '',
				]
			);
			$this->add_control(
				'header_bottom',
				[
					'label'     => __( 'Header Bottom Section', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'original_price',
				[
					'label'       => __( 'Original Price', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '$98', 'power_elements_elementor' ),
					'placeholder' => __( 'Set original price with currency', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'current_price',
				[
					'label'       => __( 'Current Price', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '58', 'power_elements_elementor' ),
					'placeholder' => __( 'Set current price without currency', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'currency',
				[
					'label'       => __( 'Currency symbol', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '$', 'power_elements_elementor' ),
					'placeholder' => __( 'Set currency symbol', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'separator',
				[
					'label'       => __( 'Separator', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '/', 'power_elements_elementor' ),
					'placeholder' => __( 'Set separator', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'period',
				[
					'label'       => __( 'Period', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'month', 'power_elements_elementor' ),
					'placeholder' => __( 'Set time period', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'short_description',
				[
					'label'       => __( 'Description', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '', 'power_elements_elementor' ),
					'placeholder' => __( 'Set short description, want hide leave empty.', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'price_table_body',
				[
					'label'     => __( 'Body Section', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$repeater = new \Elementor\Repeater();
			$repeater->add_control(
				'list_icon',
				[
					'label'       => __( 'List Icon', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::ICON,
					'label_block' => true,
					'default'     => '',
				]
			);
			$repeater->add_control(
				'list_text',
				[
					'label'       => __( 'List Text', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'default'     => __( 'Row Content', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'list',
				[
					'label'       => __( 'List', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::REPEATER,
					'fields'      => $repeater->get_controls(),
					'default'     => [
						[
							'list_title'   => __( 'Title #1', 'power_elements_elementor' ),
							'list_content' => __( 'Item content. Click the edit button to change this text.', 'power_elements_elementor' ),
						],
						[
							'list_title'   => __( 'Title #2', 'power_elements_elementor' ),
							'list_content' => __( 'Item content. Click the edit button to change this text.', 'power_elements_elementor' ),
						],
					],
					'title_field' => '{{{ list_text }}}'
				]
			);
			$this->add_control(
				'price_table_bottom',
				[
					'label'     => __( 'Bottom Section', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'button_link',
				[
					'label'         => __( 'Link', 'power_elements_elementor' ),
					'type'          => \Elementor\Controls_Manager::URL,
					'placeholder'   => __( 'https://your-link.com', 'power_elements_elementor' ),
					'show_external' => true,
					'default'       => [
						'url'         => '',
						'is_external' => true,
						'nofollow'    => true,
					],
					'dynamic'       => [
						'active' => true,
					]
				]
			);
			$this->add_control(
				'button_text',
				[
					'label'       => __( 'Button Text', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Subscribe', 'power_elements_elementor' ),
					'placeholder' => __( 'Set button readable text.', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'bottom_short_description',
				[
					'label'       => __( 'Description', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '', 'power_elements_elementor' ),
					'placeholder' => __( 'Set short description, want hide leave empty.', 'power_elements_elementor' ),
				]
			);
			$this->end_controls_section();
			/*
			 * Wraper stype
			 */
			$this->start_controls_section(
				'price_table_wrapper_style',
				[
					'label' => __( 'Wrapper Style', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			//tab wrapper start
			$this->start_controls_tabs( 'price_table_wrapper_tabs' );
			$this->start_controls_tab(
				'wrapper_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'wrapper_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'wrapper_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'wrapper_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'wrapper_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable',
				]
			);
			$this->add_control(
				'wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			// END NORMAL TAB
            //START HOVER TAB
			$this->start_controls_tab(
				'wrapper_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'wrapper_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'wrapper_border_hover',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable:hover',
				]
			);
			$this->add_control(
				'wrapper_hover_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			//END HOVER TAB
            $this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * Ribbon Style
			 */
			$this->start_controls_section(
				'ribbon_style',
				[
					'label' => __( 'Ribbon Style', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'ribbon_left',
				[
					'label'      => __( 'Left', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 15,
					],
					'condition'  => [
						'ribbon_align' => 'ribbon_1',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_1:before' => 'left: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'ribbon_right',
				[
					'label'      => __( 'Right', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 15,
					],
					'condition'  => [
						'ribbon_align' => 'ribbon_2',
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_2:before' => 'right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'ribbon_top',
				[
					'label'      => __( 'Top', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 15,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_1:before,{{WRAPPER}} .power_pricetable_header.ribbon_2:before' => 'top: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'ribbon_padding',
				[
					'label'      => __( 'Ribbon', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_1:before,{{WRAPPER}} .power_pricetable_header.ribbon_2:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'ribbon_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_1:before,{{WRAPPER}} .power_pricetable_header.ribbon_2:before' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'ribbon_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header.ribbon_1:before,{{WRAPPER}} .power_pricetable_header.ribbon_2:before' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'ribbon_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header.ribbon_1:before,{{WRAPPER}} .power_pricetable_header.ribbon_2:before',
				]
			);
			$this->end_controls_section();
			/*
			 * Header Top
			 */
			$this->start_controls_section(
				'header_top_style',
				[
					'label' => __( 'Title and Icon', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'header_top_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_top' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'header_top_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_top' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header_top' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'heading_top_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_header_top',
				]
			);
			$this->add_control(
				'heading_top_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_top' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_title',
				[
					'label'     => __( 'Title', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab title start
			$this->start_controls_tabs( 'heading_top_title_tabs' );
			$this->start_controls_tab(
				'header_top_title_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_top_title_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header_top .power_pricetable_title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_top_title_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header_top .power_pricetable_title',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_top_title_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_top_title_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header_top .power_pricetable_title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end title tabs
			$this->add_control(
				'heading_top_sub_title',
				[
					'label'     => __( 'Sub Title', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab subtitle start
			$this->start_controls_tabs( 'heading_top_subtitle_tabs' );
			$this->start_controls_tab(
				'header_top_subtitle_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_top_subtitle_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header_top p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_top_subtitle_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header_top p',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_top_subtitle_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_top_subtitle_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header_top p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end subtitle tabs
			
			$this->add_control(
				'heading_top_icon',
				[
					'label'     => __( 'Icon', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab icons start
			$this->start_controls_tabs( 'header_top_icon_tabs' );
			$this->start_controls_tab(
				'heading_top_icon_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'heading_top_icon_width',
				[
					'label'      => __( 'Width', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'em'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 80,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_height',
				[
					'label'      => __( 'Height', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'em'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 80,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_normal_font_size',
				[
					'label'      => __( 'Font Size', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						],
						'em'  => [
							'min' => 0,
							'max' => 50,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 30,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_line_height',
				[
					'label'      => __( 'Line Height', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', 'em' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'em'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 80,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'line-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_normal_bg_color',
				[
					'label'     => __( 'Bg Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'heading_top_icon_normal_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable .power_pricetable_icon',
				]
			);
			$this->add_control(
				'heading_top_icon_normal_border_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'heading_top_icon_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'heading_top_icon_hover_font_size',
				[
					'label'      => __( 'Font Size', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 40,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_icon' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_icon' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'heading_top_icon_hover_bg_color',
				[
					'label'     => __( 'Bg Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_icon' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'heading_top_icon_hover_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable:hover .power_pricetable_icon',
				]
			);
			$this->add_control(
				'heading_top_icon_hover_border_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end icons tabs
			$this->end_controls_section();
			/**
			 *Header Bottom
			 */
			$this->start_controls_section(
				'header_bottom_style',
				[
					'label' => __( 'Price & Period', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'header_bottom_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_bottom' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'header_bottom_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_bottom' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'heading_bottom_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header_bottom' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'heading_bottom_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_header_bottom',
				]
			);
			$this->add_control(
				'heading_bottom_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_header_bottom' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'header_bottom_original_price',
				[
					'label'     => __( 'Original price style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab original price start
			$this->start_controls_tabs( 'heading_original_price_tabs' );
			$this->start_controls_tab(
				'header_original_price_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_original_price_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header h2 .original_price' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_original_price_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header h2 .original_price',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_original_price_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_original_price_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header h2 .original_price' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end original price tabs
			$this->add_control(
				'header_bottom_currency',
				[
					'label'     => __( 'Currency style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab currency start
			$this->start_controls_tabs( 'heading_currency_tabs' );
			$this->start_controls_tab(
				'header_currency_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_currency_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header h2 .currency' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_currency_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header h2 .currency',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_currency_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_currency_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header h2 .currency' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end currency tabs
			$this->add_control(
				'header_bottom_current_price',
				[
					'label'     => __( 'Current Price', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab current price start
			$this->start_controls_tabs( 'heading_current_price_tabs' );
			$this->start_controls_tab(
				'header_current_price_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_current_price_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header h2 .current_price' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_current_price_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header h2 .current_price',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_current_price_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_current_price_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header h2 .current_price' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end current price tabs
			$this->add_control(
				'header_bottom_period',
				[
					'label'     => __( 'Period style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			//tab period start
			$this->start_controls_tabs( 'heading_period_tabs' );
			$this->start_controls_tab(
				'header_period_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_period_normal_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable .power_pricetable_header h2 .period' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'header_period_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header h2 .period',
				]
			);
			$this->end_controls_tab();
			// start hover
			$this->start_controls_tab(
				'header_period_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'header_period_hover_font_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_header h2 .period' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			//end period tabs
			$this->add_control(
				'header_bottom_short_description',
				[
					'label'     => __( 'Short Description style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'short_description_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'short_description_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_header p',
				]
			);
			$this->add_control(
				'header_bottom_separator',
				[
					'label'     => __( 'Separator style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'header_bottom_separator_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_header .separator' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * Price Body
			 */
			$this->start_controls_section(
				'price_table_body_style',
				[
					'label' => __( 'Body Style', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'price_table_body_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_body_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_body_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_body' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'price_table_body_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_body',
				]
			);
			$this->add_control(
				'price_table_body_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_body_heading',
				[
					'label'     => __( 'List style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->start_controls_tabs( 'price_table_body_list_tabs' );
			// NORMAL TAB START
			$this->start_controls_tab(
				'price_table_body_list_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_control(
				'price_table_body_list_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_body_list_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_body_list_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_body ul li' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'price_table_body_list_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_body ul li' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'price_table_body_list_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_body ul li',
				]
			);
			$this->add_control(
				'price_table_body_list_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_body ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			// END NORMAL TAB
			// START HOVER TAB
			$this->start_controls_tab(
				'price_table_body_list_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'price_table_body_list_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable:hover .power_pricetable_body ul li' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'price_table_body_list_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_body ul li:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			// END HOVER TAB
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * PRICE TABLE BOTTOM
			 */
			$this->start_controls_section(
				'price_table_bottom_style',
				[
					'label' => __( 'Bottom Style', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'price_table_bottom_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'price_table_bottom_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_bottom',
				]
			);
			$this->add_control(
				'price_table_bottom_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'price_table_bottom_align',
				[
					'label'        => __( 'Alignment', 'power_elements_elementor' ),
					'type'         => \Elementor\Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom' => 'text-align: {{VALUE}};'
					],
				]
			);
			$this->add_control(
				'price_table_bottom_a_heading',
				[
					'label'     => __( 'Button style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->start_controls_tabs( 'price_table_bottom_a_tabs' );
			// NORMAL TAB START
			$this->start_controls_tab(
				'price_table_bottom_a_normal',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'price_table_bottom_a_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button',
				]
			);
			$this->add_control(
				'price_table_bottom_a_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_a_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'price_table_bottom_a_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button',
				]
			);
			$this->add_control(
				'price_table_bottom_a_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_a_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'price_table_bottom_a_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button',
				]
			);
			$this->end_controls_tab();
			// END NORMAL TAB
			// HOVER TAB START
			$this->start_controls_tab(
				'price_table_bottom_a_hover',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'price_table_bottom_a_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_a_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'price_table_bottom_a_border_hover',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button:hover',
				]
			);
			$this->add_control(
				'price_table_bottom_a_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom a.power_pricetable_button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			//END HOVER TAB
            $this->end_controls_tabs();
			$this->add_control(
				'price_table_bottom_p_heading',
				[
					'label'     => __( 'Paragraph style', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'price_table_bottom_p_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_pricetable_bottom p',
				]
			);
			$this->add_control(
				'price_table_bottom_p_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_pricetable_bottom p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_p_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'price_table_bottom_p_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_pricetable_bottom p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'price_table_bottom_p_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_pricetable_bottom p',
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();
			
			if ( $settings['top_icon'] != '' ) {
				$top_icon_html = ' <div class="power_pricetable_icon">
                            <i class="' . esc_attr( $settings['top_icon'] ) . '"></i>
                        </div>';
			} else {
				$top_icon_html = '';
			}
			if ( $settings['top_sub_title'] != '' ) {
				$header_sub_title = '<p>' . esc_html( $settings['top_sub_title'] ) . '</p>';
			} else {
				$header_sub_title = '';
			}
			if ( $settings['short_description'] != '' ) {
				$header_bottom_description = '<p>' . esc_html( $settings['short_description'] ) . '</p>';
			} else {
				$header_bottom_description = '';
			}
			
			if ( $settings['bottom_short_description'] != '' ) {
				$bottom_description = '<p>' . esc_html( $settings['short_description'] ) . '</p>';
			} else {
				$bottom_description = '';
			}
			if ( $settings['list'] ) {
				$list_html = ' <div class="power_pricetable_body">
                    <ul>';
				foreach ( $settings['list'] as $item ) {
					$list_icon_html = ( $item['list_icon'] != '' ) ? '<i class="' . esc_attr( $item['list_icon'] ) . '"></i>' : '';
					$list_html      .= ' <li>' . $list_icon_html . ' ' . esc_html( $item['list_text'] ) . '</li>';
				}
				$list_html .= '</ul></div>';
			} else {
				$list_html = '';
			}
			
			echo '<div class="power_pricetable ' . esc_attr( $settings['pt_style'] ) . '">
                <div class="power_pricetable_header ' . esc_attr( $settings['ribbon_align'] ) . '">
                    <div class="power_pricetable_header_top">
                        <h5 class="power_pricetable_title">' . esc_html( $settings['top_title'] ) . '</h5>
                    </div>
                    <div class="power_pricetable_header_bottom">
                        <h2>
                            <del class="original_price">' . esc_html( $settings['original_price'] ) . '</del>
                            <span class="currency">' . esc_html( $settings['currency'] ) . '</span><span class="current_price">' . esc_html( $settings['current_price'] ) . '</span><br/>
                            <span class="separator">' . ' ' . esc_html( $settings['separator'] ) . ' ' . '</span>
                            <span class="period">' . esc_html( $settings['period'] ) . '</span>
                        </h2>
                        ' . $header_bottom_description . '
                       ' . $header_sub_title . $top_icon_html . '
                    </div>
                </div>
                ' . $list_html . '
                <div class="power_pricetable_bottom">
                    <a href="' . esc_url( $settings['button_link']['url'] ) . '" class="power_pricetable_button">' . esc_html( $settings['button_text'] ) . '</a>
                    ' . $bottom_description . '
                </div>
            </div>';
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {
			?>
            <div class="power_pricetable {{settings.pt_style}}">
                <div class="power_pricetable_header {{settings.ribbon_align}}">
                    <div class="power_pricetable_header_top">
                        <h5 class="power_pricetable_title">{{{settings.top_title}}}</h5>
                        <p>{{{settings.top_sub_title}}}</p>
                        <# if(settings.top_icon!=''){#>
                        <div class="power_pricetable_icon">
                            <i class="{{{settings.top_icon}}}"></i>
                        </div>
                        <# } #>
                    </div>
                    <div class="power_pricetable_header_bottom">
                        <h2>
                            <del class="original_price">{{{settings.original_price}}}</del>
                            <span class="currency">{{{settings.currency}}}</span><span class="current_price">{{{settings.current_price}}}</span>
                            <span class="separator">{{{settings.separator}}}</span>
                            <span class="period">{{{settings.period}}}</span>
                        </h2>
                        <p>{{{settings.short_description}}}</p>
                    </div>
                </div>
                <div class="power_pricetable_body">
                    <ul>
                        <# _.each( settings.list, function( item ) { #>
                        <li><i class="{{item.list_icon}}"></i> {{item.list_text}}</li>
                        <# }); #>
                    </ul>
                </div>
                <div class="power_pricetable_bottom">
                    <a href="{{settings.button_link.url}}"
                       class="power_pricetable_button">{{{settings.button_text}}}</a>
                    <p>{{{settings.bottom_short_description}}}</p>
                </div>
            </div>
			<?php
		}
	}