<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class Power_Elements_Banner extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_banner';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Banner', 'power_elements_elementor' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return ' eicon-banner';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * ADD Widget CSS
		 */
		
		public function get_style_depends() {
			return [ 'power-element-banner' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_banner_content',
				[
					'label' => __( 'Content', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'banner_style',
				[
					'label'   => __( 'Style', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'default' => 'style_1',
					'options' => [
						'style_1' => __( 'Style 1', 'power_elements_elementor' ),
						'style_2' => __( 'Style 2', 'power_elements_elementor' ),
						'style_4' => __( 'Style 4', 'power_elements_elementor' ),
						'style_3' => __( 'Style 3', 'power_elements_elementor' )
					]
				]
			);
			$this->add_control(
				'banner_title',
				[
					'label'       => __( 'Title', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Heading', 'power_elements_elementor' ),
					'placeholder' => __( 'Title', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'banner_sub_title',
				[
					'label'       => __( 'Subtitle', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Subtitle', 'power_elements_elementor' ),
					'placeholder' => __( 'Small title.', 'power_elements_elementor' ),
					'description' => __( 'Small title compare than main title, want hide leave empty', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'banner_align',
				[
					'label'     => __( 'Alignment', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::CHOOSE,
					'options'   => [
						'align-left'   => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'align-center' => [
							'title' => __( 'Center', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-center',
						],
						'align-right'  => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'default'   => 'align-left',
					'condition' => [
						'banner_style' => 'style_1',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'section_banner_button',
				[
					'label' => __( 'Button', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'banner_button_effect',
				[
					'label'   => __( 'Effect', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'default' => 'effect_1',
					'options' => [
						'effect_1' => __( 'Effect 1', 'power_elements_elementor' ),
						'effect_2' => __( 'Effect 2', 'power_elements_elementor' ),
						'effect_3' => __( 'Effect 3', 'power_elements_elementor' ),
						'effect_4' => __( 'Effect 4', 'power_elements_elementor' ),
						'effect_5' => __( 'Effect 5', 'power_elements_elementor' ),
					]
				]
			);
			$this->add_control(
				'banner_button_text',
				[
					'label'       => __( 'Button Text', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Click here', 'power_elements_elementor' ),
					'placeholder' => __( 'Button Text', 'power_elements_elementor' ),
					'description' => __( 'if want to hide button, leave it empty', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'banner_button_link',
				[
					'label'       => __( 'Link', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::URL,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'https://your-link.com', 'power_elements_elementor' ),
					'default'     => [
						'url' => '#',
					],
				]
			);
			$this->add_control(
				'banner_button_icon',
				[
					'label'       => __( 'Icon', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::ICON,
					'label_block' => true,
					'description' => __( 'Want hide leave empty', 'power_elements_elementor' ),
					'default'     => '',
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE BANNER
			 */
			$this->start_controls_section(
				'power_element_banner_wrapper_style',
				[
					'label' => __( 'Banner', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'banner_padding',
				[
					'label'      => __( 'padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name'     => 'banner_background',
					'label'    => __( 'Background', 'power_elements_elementor' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .power_banner_content',
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE TITLE
			 */
			$this->start_controls_section(
				'power_element_banner_title_style',
				[
					'label' => __( 'Title', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'banner_title_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_title',
				]
			);
			$this->add_control(
				'banner_title_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'banner_title_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_title',
				]
			);
			$this->add_control(
				'banner_title_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'banner_title_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE SUB-TITLE
			 */
			$this->start_controls_section(
				'power_element_banner_subtitle_style',
				[
					'label' => __( 'Subtitle', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'banner_subtitle_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_desc',
				]
			);
			$this->add_control(
				'banner_subtitle_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_desc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'banner_subtitle_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_desc',
				]
			);
			$this->add_control(
				'banner_subtitle_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'banner_subtitle_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * STYLE BUTTON
			 */
			$this->start_controls_section(
				'power_element_banner_button_style',
				[
					'label' => __( 'Button', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'style_banner_button_tabs'
			);
			/*
			 * BUTTON NORMAL
			 */
			$this->start_controls_tab(
				'style_banner_button',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'banner_button_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_button',
				]
			);
			$this->add_control(
				'banner_button_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'banner_button_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_button:after' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'banner_button_shadow',
					'label'    => __( 'Box Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_button',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'banner_button_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_banner_content .power_banner_button',
				]
			);
			$this->add_control(
				'banner_button_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'banner_button_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'banner_button_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_banner_content .power_banner_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			* BUTTON HOVER
			*/
			$this->start_controls_tab(
				'style_banner_button_hover',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'banner_button_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_button:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'banner_button_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_banner_content .power_banner_button:before' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();
			if ( $settings['banner_button_icon'] != '' ) {
				$icon_html = ' ' . '<i class="' . esc_attr( $settings['banner_button_icon'] ) . ' power_banner_button_icon"></i>';
			} else {
				$icon_html = '';
			}
			if ( $settings['banner_button_text'] != '' ) {
				$button_html = '<div class="power_banner_button_group">
                	<a href="' . esc_url( $settings['banner_button_link']['url'] ) . '" class="power_banner_button ' . esc_attr( $settings['banner_button_effect'] ) . ' power_banner_button_icon_right" data-text="Read More"><!--effect_(1-5)-->
                		<span class="button_value">' . esc_html( $settings['banner_button_text'] ) . ' ' . $icon_html . '</span>
                	</a>
                </div>';
			} else {
				$button_html = '';
			}
			if ( $settings['banner_sub_title'] != '' ) {
				$sub_html = '<p class="power_banner_desc">' . esc_html( $settings['banner_sub_title'] ) . '</p>';
			} else {
				$sub_html = '';
			}
			if ( $settings['banner_style'] == 'style_2' ) {
				echo ' <div class="power_banner_content ' . esc_attr( $settings['banner_align'] ) . '">
            	<div class="power_banner_top">
                     ' . $sub_html . '
                    <h4 class="power_banner_title">' . esc_html( $settings['banner_title'] ) . '</h4>
                </div>
                 ' . $button_html . '
            </div>';
			} elseif ( $settings['banner_style'] == 'style_3' ) {
				echo '<div class="power_banner_content inline_direction"> <!-- Align left/center/right not works for inline direction-->
            	<div class="power_banner_top">
                    <h4 class="power_banner_title">' . esc_html( $settings['banner_title'] ) . '</h4>
                    ' . $sub_html . '
                </div>
                ' . $button_html . '
            </div>';
			} elseif ( $settings['banner_style'] == 'style_4' ) {
				echo ' <div class="power_banner_content inline_direction center"> <!-- Align left/center/right not works for inline direction-->
            	<div class="power_banner_top">
                   ' . $sub_html . '
                    <h5 class="power_banner_title">' . esc_html( $settings['banner_title'] ) . '</h5>
                </div>
                 ' . $button_html . '
            </div>';
			} else {
				echo '<div class="power_banner_content ' . esc_attr( $settings['banner_align'] ) . '">
            	<div class="power_banner_top">
                    <h2 class="power_banner_title">' . esc_html( $settings['banner_title'] ) . '</h2>
                    ' . $sub_html . '
                </div>
                ' . $button_html . '
            </div>';
			}
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {
			?>
            <# if ( settings.banner_style == 'style_2' ) { #>
            <div class="power_banner_content align-left">
                <div class="power_banner_top">
                    <p class="power_banner_desc">{{{settings.banner_sub_title}}}</p>
                    <h4 class="power_banner_title">{{{settings.banner_title}}}</h4>
                </div>
                <# if(settings.banner_button_text!=''){ #>
                <!-- Button Start -->
                <div class="power_banner_button_group">
                    <a href="{{settings.banner_button_link.url}}"
                       class="power_banner_button {{settings.banner_button_effect}} power_banner_button_icon_right"
                       data-text="Read More"><!--effect_(1-5)-->
                        <span class="button_value"> {{{settings.banner_button_text}}}
							<# if(settings.banner_button_icon){#>
							<i class="{{settings.banner_button_icon}} power_banner_button_icon"></i>
							<# }#>
						</span>
                    </a>
                </div>
                <!-- Button End-->
                <# } #>
            </div>
            <# } else if(settings.banner_style == 'style_3'){ #>
            <div class="power_banner_content inline_direction">
                <!-- Align left/center/right not works for inline direction-->
                <div class="power_banner_top">
                    <h4 class="power_banner_title">{{{settings.banner_title}}}</h4>
                    <p class="power_banner_desc">{{{settings.banner_sub_title}}}</p>
                </div>
                <# if(settings.banner_button_text!=''){ #>
                <!-- Button Start -->
                <div class="power_banner_button_group">
                    <a href="{{settings.banner_button_link.url}}"
                       class="power_banner_button {{settings.banner_button_effect}} power_banner_button_icon_right"
                       data-text="Read More"><!--effect_(1-5)-->
                        <span class="button_value"> {{{settings.banner_button_text}}}
							<# if(settings.banner_button_icon){#>
							<i class="{{settings.banner_button_icon}} power_banner_button_icon"></i>
							<# }#>
						</span>
                    </a>
                </div>
                <!-- Button End-->
                <# } #>
            </div>
            <# } else if(settings.banner_style == 'style_4'){ #>
            <div class="power_banner_content inline_direction center">
                <!-- Align left/center/right not works for inline direction-->
                <div class="power_banner_top">
                    <p class="power_banner_desc">{{{settings.banner_sub_title}}}</p>
                    <h5 class="power_banner_title">{{{settings.banner_title}}}</h5>
                </div>
                <# if(settings.banner_button_text!=''){ #>
                <!-- Button Start -->
                <div class="power_banner_button_group">
                    <a href="{{settings.banner_button_link.url}}"
                       class="power_banner_button {{settings.banner_button_effect}} power_banner_button_icon_right"
                       data-text="Read More"><!--effect_(1-5)-->
                        <span class="button_value"> {{{settings.banner_button_text}}}
							<# if(settings.banner_button_icon){#>
							<i class="{{settings.banner_button_icon}} power_banner_button_icon"></i>
							<# }#>
						</span>
                    </a>
                </div>
                <!-- Button End-->
                <# } #>
            </div>
            <# }else{#>
            <div class="power_banner_content {{settings.banner_align}}">
                <div class="power_banner_top">
                    <h1 class="power_banner_title">{{{settings.banner_title}}}</h1>
                    <p class="power_banner_desc">{{{settings.banner_sub_title}}}</p>
                </div>
                <# if(settings.banner_button_text!=''){ #>
                <!-- Button Start -->
                <div class="power_banner_button_group">
                    <a href="{{settings.banner_button_link.url}}"
                       class="power_banner_button {{settings.banner_button_effect}} power_banner_button_icon_right"
                       data-text="Read More"><!--effect_(1-5)-->
                        <span class="button_value"> {{{settings.banner_button_text}}}
							<# if(settings.banner_button_icon){#>
							<i class="{{settings.banner_button_icon}} power_banner_button_icon"></i>
							<# }#>
						</span>
                    </a>
                </div>
                <!-- Button End-->
                <# } #>
            </div>
            <# } #>
			<?php
		}
	}