<?php
	/**
	 * Created by PhpStorm.
	 * User: j3sha
	 * Date: 6/15/2019
	 * Time: 12:41 PM
	 */
	/*elementor-column <?php echo esc_attr( $post_args['power_post_grid_columns'] ); ?>*/
	$archive_year  = get_the_time( 'Y' );
	$archive_month = get_the_time( 'm' );
	$archive_day   = get_the_time( 'd' );
?>
<div class="item">
    <article class="power_blog_post">
        <div class="power_blog_post_header">
			<?php if ( $post_args['power_show_category'] == 1 ) { ?>
                <h4 class="power_blog_post_cat">
                    <span><?php echo esc_html( $post_args['power_category_text'], 'power_elements_elementor' ) ?></span><?php echo Power_elements_Helper::power_get_categories_lists( get_the_ID() ) ?>
                </h4>
			<?php } ?>
			<?php if ( $post_args['power_show_title'] == 1 ) { ?>
                <h3 class="power_blog_post_title"><a
                            href="<?php echo esc_url( get_the_permalink( get_the_ID() ) ) ?>"><?php echo the_title(); ?></a>
                </h3>
			<?php } ?>
        </div>
		<?php if ( $post_args['power_show_image'] == 1 ) {
			$post_image_url = wp_get_attachment_image_url( get_post_thumbnail_id(), $post_args['image_size'] );
			?>
            <div class="power_blog_post_img">
                <img src="<?php echo esc_url( $post_image_url ) ?>" alt="<?php echo get_the_title(); ?>">
            </div>
		<?php } ?>
        <div class="power_blog_post_content">
			<?php if ( $post_args['power_show_meta'] == 1 ) { ?>
                <ul class="power_blog_post_meta">
                    <?php if ( $post_args['power_show_author'] == 1 ) { ?>
                    <li>
                        <span class="power_blog_author"> 
                            <?php if ( $post_args['power_show_avatar'] == 1 ) {
								echo get_avatar( get_the_author_meta( 'ID' ), 40 );
							} ?>
                            <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'nickname' ) ); ?>"><?php echo get_the_author(); ?></a></span>
                    </li>
                    <?php } ?>
                    <?php if ( $post_args['power_show_date'] == 1 ) { ?>
                    <li><span class="power_blog_date"><a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day ); ?>"><?php echo get_the_date(); ?></a></span>
                    </li>
                    <?php } ?>
                    <?php if ( $post_args['power_show_comments'] == 1 ) { ?>
                    <li><span class="power_blog_comments"><a href="<?php echo get_comments_link(); ?>">
                     <?php if ( get_comments_number() > 1 ) {
                         echo sprintf( __( '%d Comments.', 'power_elements_elementor' ), get_comments_number() );
                     } elseif ( get_comments_number() == 1 ) {
                         _e( '1 Comment.', 'get_comments_number()' );
                     } else {
                         _e( '0 Comment.', 'get_comments_number()' );
                     } ?>
                    </a></span></li>
                    <?php } ?>
                </ul>
			<?php } ?>
			<?php if ( $post_args['power_show_excerpt'] == 1 ) { ?>
                <div class="power_blog_post_intro">
                    <p><?php echo wp_trim_words( get_the_excerpt(), $post_args['power_excerpt_length'] ); ?></p>
                </div>
			<?php } ?>
			<?php if ( $post_args['power_show_read_more'] == 1 ) { ?>
                <div class="power_blog_button_group">
                    <a href="<?php echo get_the_permalink() ?>" class="power_blog_button">
                        <span class="power_blog_button_value"><?php echo esc_html( $post_args['power_read_more_text'] ) ?></span>
                    </a>
                </div>
			<?php } ?>
        </div>
    </article>
</div>
