<?php
	
	/*
	Plugin Name: Power Elements elementor add-on
	Plugin URI: https://wordpress.org/plugins/power-elements-elementor-add-on 
	Description: Power_elements elementor supported addons, this plugin helps to add Default Icon Field of Elementor with popular font icons, such as, Ionicons, Simple Line, Google Material and Fontawesome. This plugin do not merge different icons. It helps to enrich your page with single icons set.
	Version: 1.0
	Author: Power_elements
	Author URI: https://power_elementsfiles.com/
	License: GPLv2 or later
	*/
	
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	define('PLUGIN_DIRECTORY_URL',plugin_dir_url(__FILE__));
	define('POWER_PLUGIN_PATH', plugin_dir_path(__FILE__));
	final class Power_Elements {
		
		/**
		 * Plugin Version
		 *
		 * @since 1.0.0
		 *
		 * @var string The plugin version.
		 */
		const VERSION = '1.0';
		
		/**
		 * Minimum Elementor Version
		 *
		 * @since 1.0.0
		 *
		 * @var string Minimum Elementor version required to run the plugin.
		 */
		const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
		/**
		 * Minimum PHP Version
		 *
		 * @since 1.0.0
		 *
		 * @var string Minimum PHP version required to run the plugin.
		 */
		const MINIMUM_PHP_VERSION = '5.6';
		/**
		 * Instance
		 *
		 * @since 1.0.0
		 *
		 * @access private
		 * @static
		 *
		 * @var Elementor_Custom Icon_Extension The single instance of the class.
		 */
		private static $_instance = null;
		
		/**
		 * Constructor
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function __construct() {
			add_action( 'init', [ $this, 'i18n' ] );
			add_action( 'plugins_loaded', [ $this, 'init' ] );
		}
		
		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 * @static
		 *
		 * @return Elementor_Custom Icon_Extension An instance of the class.
		 */
		
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			
			return self::$_instance;
		}
		
		/**
		 * Initialize the plugin
		 *
		 * Load the plugin only after Elementor (and other plugins) are loaded.
		 * Checks for basic plugin requirements, if one check fail don't continue,
		 * if all check have passed load the files required to run the plugin.
		 *
		 * Fired by `plugins_loaded` action hook.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function init() {
			// Check if Elementor installed and activated
			if ( ! did_action( 'elementor/loaded' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
				
				return;
			}
			
			// Check for required Elementor version
			if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
				
				return;
			}
			
			// Check for required PHP version
			if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
				
				return;
			}
			// Include plugin files 
			$this->includes();
			
			// custom controll register
			add_action( 'elementor/controls/controls_registered', array( $this, 'power_elements_controll_register' ) );
			
			//Widget Rigister
			add_action( 'elementor/widgets/widgets_registered', array( $this, 'power_elements_register' ), 10, 1 );
			// Add custom Category
			add_action( 'elementor/elements/categories_registered', [$this, 'power_elements_widget_categories'] );
			
			add_action( 'elementor/frontend/after_register_styles', 'Power_Elements_Enqueue_Script::power_elements_button_widget_styles' );
			add_action( 'elementor/editor/after_enqueue_styles', 'Power_Elements_Enqueue_Script::power_elements_widget_styles' );
			add_action( 'elementor/preview/enqueue_styles', 'Power_Elements_Enqueue_Script::power_elements_widget_styles' );
			
			add_action( 'elementor/frontend/after_register_scripts', 'Power_Elements_Enqueue_Script::power_elements_button_widget_scripts' );
			add_action( 'elementor/editor/before_enqueue_scripts', 'Power_Elements_Enqueue_Script::power_elements_widget_script' );
			add_action( 'elementor/preview/enqueue_scripts', 'Power_Elements_Enqueue_Script::power_elements_widget_script' );
		}
		
		/**
		 * Load External Files
		 *
		 * Load plugin external files.
		 *
		 * Fired by `init` action hook.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function includes() {
			require_once( __DIR__ . '/lib/power_elements-helper.php' );
			require_once( __DIR__ . '/lib/power-elements-enqueue-script.php' );
		}
		
		/**
		 * Load Textdomain
		 *
		 * Load plugin localization files.
		 *
		 * Fired by `init` action hook.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function i18n() {
			
			load_plugin_textdomain( 'power_elements_elementor_icons', false, basename( dirname( __FILE__ ) ) . '/languages' );
			
		}
		
		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have Elementor installed or activated.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_missing_main_plugin() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
				esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'power_elements_elementor' ),
				'<strong>' . esc_html__( 'Elementor Custom Icon Extension', 'power_elements_elementor' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'power_elements_elementor' ) . '</strong>'
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
		
		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required Elementor version.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_minimum_elementor_version() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'power_elements_elementor' ),
				'<strong>' . esc_html__( 'Elementor Custom Icon Extension', 'power_elements_elementor' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'power_elements_elementor' ) . '</strong>',
				self::MINIMUM_ELEMENTOR_VERSION
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
		
		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required PHP version.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_minimum_php_version() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'power_elements_elementor' ),
				'<strong>' . esc_html__( 'Elementor Custom Icon Extension', 'power_elements_elementor' ) . '</strong>',
				'<strong>' . esc_html__( 'PHP', 'power_elements_elementor' ) . '</strong>',
				self::MINIMUM_PHP_VERSION
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
		
		/*
		 * Elementor Rigester
		 * Power Elements Widgets
		 */
		
		public function power_elements_register(){
			// Include Widget files
			require_once( __DIR__ . '/widgets/power_elements_button.php' );
			//require_once( __DIR__ . '/widgets/power_elements_social.php' );
			require_once( __DIR__ . '/widgets/power_elements_heading.php' );
			//require_once( __DIR__ . '/widgets/power_elements_icon_list.php' );
			require_once( __DIR__ . '/widgets/power_elements_icon_box.php' );
			require_once( __DIR__ . '/widgets/power_elements_testimonial.php' );
			require_once( __DIR__ . '/widgets/power_elements_testimonial_carousel.php' );
			require_once( __DIR__ . '/widgets/power_elements_team.php' );
			require_once( __DIR__ . '/widgets/power_elements_team_carousel.php' );
			require_once( __DIR__ . '/widgets/power_elements_price_table.php' );
			require_once( __DIR__ . '/widgets/power_elements_accordion.php' );
			//require_once( __DIR__ . '/widgets/power_elements_toggle.php' );
			require_once( __DIR__ . '/widgets/power_elements_tabs.php' );
			require_once( __DIR__ . '/widgets/power_elements_banner.php' );
			require_once( __DIR__ . '/widgets/power_elements_progressbar.php' );
			//require_once( __DIR__ . '/widgets/power_elements_circle_progressbar.php' );
			require_once( __DIR__ . '/widgets/power_elements_imagebox.php' );
			require_once( __DIR__ . '/widgets/power_elements_map.php' );
			//require_once( __DIR__ . '/widgets/power_elements_image_carousel.php' );
			//require_once( __DIR__ . '/widgets/power_elements_video.php' );
			//require_once( __DIR__ . '/widgets/power_elements_funfact.php' );
			require_once( __DIR__ . '/widgets/power_elements_portfolio_filter.php' );
			require_once( __DIR__ . '/widgets/power_elements_portfolio_carousel.php' );
			//require_once( __DIR__ . '/widgets/power_elements_blog.php' );
			//require_once( __DIR__ . '/widgets/power_elements_blog_carousel.php' );
			//require_once( __DIR__ . '/widgets/power_elements_blog_filter.php' );
			require_once( __DIR__ . '/widgets/power_elements_section.php' );
			require_once( __DIR__ . '/widgets/power_elements_contact_info.php' );
			require_once( __DIR__ . '/widgets/power_elements_slider.php' );
			
			// Register widget
			$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
			$widgets_manager->register_widget_type( new \Power_Elements_Button() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Social() );
			$widgets_manager->register_widget_type( new \Power_Elements_Heading() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Icon_List() );
			$widgets_manager->register_widget_type( new \Power_Elements_Icon_Box() );
			$widgets_manager->register_widget_type( new \Power_Elements_Testimonial() );
			$widgets_manager->register_widget_type( new \Power_Elements_Testimonial_Carousel() );
			$widgets_manager->register_widget_type( new \Power_Elements_Team() );
			$widgets_manager->register_widget_type( new \Power_Elements_Team_Carousel() );
			$widgets_manager->register_widget_type( new \Power_Elements_Price_Table() );
			$widgets_manager->register_widget_type( new \Power_Elements_Accordion() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Toggle() );
			$widgets_manager->register_widget_type( new \Power_Elements_Tabs() );
			$widgets_manager->register_widget_type( new \Power_Elements_Progressbar() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Circle_Progressbar() );
			$widgets_manager->register_widget_type( new \Power_Elements_Imagebox() );
			$widgets_manager->register_widget_type( new \Power_Elements_Map() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Image_Carousel() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Video() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Funfact() );
			$widgets_manager->register_widget_type( new \Power_Elements_Portfolio_Filter() );
			$widgets_manager->register_widget_type( new \Power_Elements_Portfolio_Carousel() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Blog() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Blog_Carousel() );
			//$widgets_manager->register_widget_type( new \Power_Elements_Blog_Filter() );
			$widgets_manager->register_widget_type( new \Power_Elements_Section() );
			$widgets_manager->register_widget_type( new \Power_Elements_Contact_Info() );
			$widgets_manager->register_widget_type( new \Power_Elements_Slider() );
		}
		
		/*
		 *
		 * POWER CUSTOM CONTROLL REGISTER
		 */
		
		function power_elements_controll_register(){
			// Include Widget files
			require_once( __DIR__ . '/control/power_elements_post.php' );
			
			// control manager
			$controls_manager = \Elementor\Plugin::$instance->controls_manager;
			//$controls_manager->register_control( 'powerpost', new \Power_Elements_Post() );
			$controls_manager->add_group_control('powerpost', new Power_Elements_Post);
		}
		
		/*
		 * Elementor Category
		 */
		
		public function power_elements_widget_categories( $elements_manager){
			$elements_manager->add_category(
				'power-elements',
				[
					'title' => __( 'Power Elements', 'power_elements_elementor' ),
					'icon' => 'fa fa-plug',
				]
			);
		}
		
	}
	
	Power_Elements::instance();