<?php
	/**
	 * Created by PhpStorm.
	 * User: Power_elements
	 * Date: 4/16/2019
	 * Time: 3:23 PM
	 */
	
	if ( ! defined( 'ABSPATH' ) ) {
		return;
	}
	
	$status='default';
	
	
	if (isset( $_POST['power_elements_nonce_field'] ) ) {
		if ( isset( $_POST['power_elements_icons_fonts'] ) && wp_verify_nonce( $_POST['power_elements_nonce_field'], 'power_elements-action' ) && current_user_can( 'manage_options' ) ) {
			update_option( 'power_elements_icons_fonts', sanitize_key( $_POST['power_elements_icons_fonts'] ) );
			$status = true;
		}else {
			$status = false;
		}
	}
	
	$options = get_option( 'power_elements_icons_fonts' );
?>

    <div class="wrap">
        <h2><?php echo esc_html__( 'Icon and CSS setup', 'power_elements-elementor' ) ?></h2>
        <div class="wrap">
            <form method="post" name="power_elements_custom_form" id="power_elements_custom_form"
                  action="admin.php?page=power_elements-elementor-custom-icons">
                <select name="power_elements_icons_fonts">
                    <option value="power_elements_default" <?php selected( $options, 'power_elements_default' ); ?>><?php echo esc_html__( 'Fontawesome', 'power_elements-elementor' ) ?></option>
                    <option value="free-ionicons" <?php selected( $options, 'free-ionicons' ); ?>><?php echo esc_html__( 'Ionicons', 'power_elements-elementor' ) ?></option>
                    <option value="free-simpleicon" <?php selected( $options, 'free-simpleicon' ); ?>><?php echo esc_html__( 'Simple Icons', 'power_elements-elementor' ) ?></option>
                    <option value="free-materialicon" <?php selected( $options, 'free-materialicon' ); ?>><?php echo esc_html__( 'Google Material Icons', 'power_elements-elementor' ) ?></option>
                </select>
                <span class="submit"><input name="save" type="submit" value="Save changes"/></span>
				<?php wp_nonce_field( 'power_elements-action', 'power_elements_nonce_field' ); ?>
            </form>
        </div>
    </div>
<?php
	if ( $status===true ) {
		echo '<div class="notice notice-success is-dismissible">
        			<p>' . esc_html__( 'Update Successful.', 'power_elements-elementor' ) . '</p>
    			 </div>';
	}elseif($status===false){
		echo '<div class="notice notice-error is-dismissible">
        			<p>' . esc_html__( 'Authentication Failed.', 'power_elements-elementor' ) . '</p>
    			 </div>';
    }
?>