<?php
/**
 Plugin Name: Oculus Assistant
 Plugin URI:http://wpthemebooster.com
 Description: Oculus Assistant is a plugin for our FundPress Theme.
 Author: wpthemebooster
 Author URI: http://wpthemebooster.com
 Version:1.0.2
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define("OCULUS_PLUGIN_DIR", plugin_dir_path(__FILE__ ));

class Oculus_Main{

	/**
     * Holds the class object.
     *
     * @since 1.0.0
     *
     */
    
	public static $_instance;

	/**
     * Plugin Name
     *
     * @since 1.0.0
     *
     */

	public $plugin_name = 'Oculus Assistant';

	/**
     * Plugin Version
     *
     * @since 1.0.0
     *
     */

	public $plugin_version = '1.0.0';

	/**
     * Plugin File
     *
     * @since 1.0.0
     *
     */

	public $file = __FILE__;

	/**
     * Load Construct
     * 
     * @since 1.0.0
     */

	public function __construct(){
		$this->oculus_plugin_init();
		$this->oculus_file_include();
	}

	/**
     * Plugin Initialization
     *
     * @since 1.0.0
     *
     */

	public function oculus_plugin_init(){
		require_once (plugin_dir_path($this->file). 'post-type/post-class.php');
          add_action( 'wp_enqueue_scripts', array( $this, 'oculus_enqueue_script'));
     }
     
	public function oculus_file_include(){
		require_once (plugin_dir_path($this->file). 'init.php');
     }
     
     public function oculus_enqueue_script(){}

	public static function oculus_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Oculus_Main();
        }
        return self::$_instance;
    }

}
$Oculus_Main = Oculus_Main::oculus_get_instance();