<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class Power_Elements_Testimonial extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_testimonial';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Testimonial', 'power_elements_elementor' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-testimonial';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * ADD Widget CSS
		 */
		
		public function get_style_depends() {
			return [ 'power-element-testimonial' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'power_element_content',
				[
					'label' => __( 'Testimonial Content', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'testimonial_style',
				[
					'label'   => __( 'Style', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'default' => 'style_1',
					'options' => [
						'style_1' => __( 'Style 1', 'power_elements_elementor' ),
						'style_2' => __( 'Style 2', 'power_elements_elementor' ),
						'style_3' => __( 'Style 3', 'power_elements_elementor' ),
						'style_4' => __( 'Style 4', 'power_elements_elementor' ),
						'style_5' => __( 'Style 5', 'power_elements_elementor' ),
						'style_6' => __( 'Style 6', 'power_elements_elementor' )
					]
				]
			);
			$this->add_control(
				'name_text',
				[
					'label'       => __( 'Name', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Your Name', 'power_elements_elementor' ),
					'placeholder' => __( 'Your Name Please', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'address_text',
				[
					'label'       => __( 'Address or Designation', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'CEO, Advertising Corp', 'power_elements_elementor' ),
					'placeholder' => __( 'Give your designation please.', 'power_elements_elementor' ),
					'label_block' => true
				]
			);
			$this->add_control(
				'quote_text',
				[
					'label'       => __( 'Quote', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => __( 'Quote', 'power_elements_elementor' ),
					'placeholder' => __( 'Give your quote please.', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'testimonial_image',
				[
					'label'   => __( 'Choose Image', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				]
			);
			$this->add_control(
				'testimonial_ratting',
				[
					'label'   => __( 'Ratting', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'min'     => 0,
					'max'     => 5,
					'step'    => 0.5,
					'default' => '',
				]
			);
			$this->end_controls_section();
			
			$this->start_controls_section(
				'power_element_style',
				[
					'label' => __( 'Testimonial Wrapper', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'testimonial_align',
				[
					'label'        => __( 'Alignment', 'power_elements_elementor' ),
					'type'         => \Elementor\Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justified', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name'     => 'testimonial_background',
					'label'    => __( 'Background', 'power_elements_elementor' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .power_testimonial_item',
				]
			);
			$this->add_control(
				'hr',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'testimonial_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item',
				]
			);
			$this->add_control(
				'hr-shadow',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'box_shadow',
					'label'    => __( 'Box Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item',
				]
			);
			$this->add_control(
				'hr-dimension',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			$this->add_control(
				'testimonial_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'testimonial_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'power_element_style_image',
				[
					'label' => __( 'Testimonial Image', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'testimonial_width',
				[
					'label'      => __( 'Width', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 100,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_image img' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'testimonial_height',
				[
					'label'      => __( 'Height', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 100,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_image img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'testimonial_img_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_image img',
				]
			);
			$this->add_control(
				'testimonial_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'power_element_style_quote',
				[
					'label' => __( 'Quote Wrapper', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name'     => 'reviewer_background',
					'label'    => __( 'Background', 'power_elements_elementor' ),
					'types'    => [ 'classic', 'gradient'],
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_content',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'reviewer_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_testimonial_item p.power_testimonial_reviewer_text',
				]
			);
			$this->add_control(
				'reviewer_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_testimonial_item p.power_testimonial_reviewer_text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'quote_wrapper_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_content',
				]
			);
			$this->add_control(
				'quote_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'hr-quote_wrapper_radius',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			$this->add_control(
				'quote_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'quote_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPOGRAPHY NAME
			 */
			$this->start_controls_section(
				'power_element_style_name',
				[
					'label' => __( 'Name Typography', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'name_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_name',
				]
			);
			$this->add_control(
				'name_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_name' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'name_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_name',
				]
			);
			$this->add_control(
				'name_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'name_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPEGRAPHY ADDRESS
			 */
			$this->start_controls_section(
				'power_element_style_address',
				[
					'label' => __( 'Address Typography', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'address_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_company',
				]
			);
			$this->add_control(
				'address_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_company' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'address_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_company',
				]
			);
			$this->add_control(
				'address_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_company' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'address_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_company' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			
			/**
			 *
			 * TYPOGRAPHY QUOTE
			 */
			$this->start_controls_section(
				'power_element_style_quote',
				[
					'label' => __( 'Quote Typography', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'quote_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_text',
				]
			);
			$this->add_control(
				'quote_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'quote_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_text',
				]
			);
			$this->add_control(
				'quote_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'quote_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPOGRAPHY ICON
			 */
			$this->start_controls_section(
				'power_element_style_icon',
				[
					'label' => __( 'Icon Typography', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'icon_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_rating li' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'icon_size',
				[
					'label'      => __( 'Icon Size', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 5,
							'max'  => 50,
							'step' => 1,
						],
						'%'  => [
							'min' => 1,
							'max' => 50,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 22,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_testimonial_item .power_testimonial_reviewer_rating li' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();
			if ( $settings['testimonial_image']['id'] != '' ) {
				if ( in_array( $settings['testimonial_style'], array( 'style_4', 'style_5', 'style_6' ) ) ) {
					$img = '<div class="power_testimonial_reviewer_image">
                        <img src="' . $settings['testimonial_image']['url'] . '" alt="' . esc_attr( $settings['name_text'] ) . '">
                    </div>';
				} else {
					$img = '<div class="power_testimonial_reviewer_meta_inner">
                    <div class="power_testimonial_reviewer_image">
                        <img src="' . $settings['testimonial_image']['url'] . '" alt="' . esc_attr( $settings['name_text'] ) . '">
                    </div>
                </div>';
				}
			} else {
				$img = '';
			}
			
			if ( $settings['testimonial_ratting'] ) {
				$ratting = Power_elements_Helper::wpbucket_get_rating_html( $settings['testimonial_ratting'] );
			} else {
				$ratting = '';
			}
			if ( $settings['testimonial_style'] == 'style_2' ) {
				echo '<div class="power_testimonial_item">
               ' . $img . '
                <div class="power_testimonial_reviewer_content">
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                    </div>
                    <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                  ' . $ratting . '
                </div>
            </div>';
			} elseif ( $settings['testimonial_style'] == 'style_3' ) {
				echo '<div class="power_testimonial_item">
                <div class="power_testimonial_reviewer_content">
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                    </div>
                    <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                   ' . $ratting . '
                </div>
                ' . $img . '
            </div>';
			} elseif ( $settings['testimonial_style'] == 'style_4' ) {
				echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_content">
                     <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                    ' . $ratting . '
                </div>
                <div class="power_testimonial_reviewer_meta_inner">
                    ' . $img . '
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                    </div>
                </div>
            </div>';
			} elseif ( $settings['testimonial_style'] == 'style_5' ) {
				echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_meta_inner">
                    ' . $img . '
                    <div class="power_testimonial_reviewer_details">
                       <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                       <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                    </div>
                </div>
                <div class="power_testimonial_reviewer_content">
                    <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                   ' . $ratting . '
                </div>
            </div>';
			}elseif ($settings['testimonial_style'] == 'style_6'){
			    echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_meta_inner">
                    '.$img.'
                    <div class="power_testimonial_reviewer_details">
                        <div class="power_testimonial_reviewer_content">
                            <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                             <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                            <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                           '.$ratting.'
                        </div>
                    </div>
                </div>
            </div>';
            } else {
				echo '<div class="power_testimonial_item">
                ' . $img . '
                <div class="power_testimonial_reviewer_content">
                    ' . $ratting . '
                    <p class="power_testimonial_reviewer_text">' . Power_elements_Helper::power_kses( $settings['quote_text'] ) . '</p>
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Power_elements_Helper::power_kses( $settings['name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Power_elements_Helper::power_kses( $settings['address_text'] ) . '</h6>
                    </div>
                </div>
            </div>';
			}
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {
			?>
            <# if ( settings.testimonial_style == 'style_2' ) { #>
            <div class="power_testimonial_item">
                <# if ( settings.testimonial_image.id != '' ) { #>
                <div class="power_testimonial_reviewer_meta_inner">
                    <div class="power_testimonial_reviewer_image">
                        <img src="{{settings.testimonial_image.url}}" alt="{{settings.name_text}}">
                    </div>
                </div>
                <# } #>
                <div class="power_testimonial_reviewer_content">
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">{{{settings.name_text}}}</h4>
                        <h6 class="power_testimonial_reviewer_company">{{{settings.address_text}}}</h6>
                    </div>
                    <p class="power_testimonial_reviewer_text">{{{settings.quote_text}}}</p>
                    <# if ( settings.testimonial_ratting != '' ) { #>
                    <ul class="power_testimonial_reviewer_rating">
                        <#
                        var integer = parseInt(settings.testimonial_ratting);
                        var decimal = settings.testimonial_ratting - integer;
                        var remain = 5 - integer;
                        var count = 0;
                        for ( var i = 1; i <= integer; i ++ ) {
                        #>
                        <li><i class="fa fa-star"></i></li>
                        <#
                        count += 1;
                        }
                        if ( decimal > 0 ) { #>
                        <li><i class="fa fa-star-half-o"></i></li>
                        <#
                        count += 1;
                        }
                        if ( remain > 0 ) {
                        integer = 5 - count;
                        if ( integer > 0 ) {
                        for ( var i = 1; i <= integer; i ++ ) { #>
                        <li><i class="fa fa-star-o"></i></li>
                        <#
                        }
                        }
                        }
                        #>
                    </ul>
                    <# } #>
                </div>
            </div>
            <# } else if(settings.testimonial_style == 'style_4'){ #>
            <div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_content">
                    <p class="power_testimonial_reviewer_text">{{{settings.quote_text}}}</p>
                    <# if ( settings.testimonial_ratting != '' ) { #>
                    <ul class="power_testimonial_reviewer_rating">
                        <#
                        var integer = parseInt(settings.testimonial_ratting);
                        var decimal = settings.testimonial_ratting - integer;
                        var remain = 5 - integer;
                        var count = 0;
                        for ( var i = 1; i <= integer; i ++ ) {
                        #>
                        <li><i class="fa fa-star"></i></li>
                        <#
                        count += 1;
                        }
                        if ( decimal > 0 ) { #>
                        <li><i class="fa fa-star-half-o"></i></li>
                        <#
                        count += 1;
                        }
                        if ( remain > 0 ) {
                        integer = 5 - count;
                        if ( integer > 0 ) {
                        for ( var i = 1; i <= integer; i ++ ) { #>
                        <li><i class="fa fa-star-o"></i></li>
                        <#
                        }
                        }
                        }
                        #>
                    </ul>
                    <# } #>
                </div>
                <div class="power_testimonial_reviewer_meta_inner">
                    <# if ( settings.testimonial_image.id != '' ) { #>
                    <div class="power_testimonial_reviewer_image">
                        <img src="{{settings.testimonial_image.url}}" alt="{{settings.name_text}}">
                    </div>
                    <# } #>
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">{{{settings.name_text}}}</h4>
                        <h6 class="power_testimonial_reviewer_company">{{{settings.address_text}}}</h6>
                    </div>
                </div>
            </div>
            <# } else if(settings.testimonial_style == 'style_5'){ #>
            <div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_meta_inner">
                    <# if ( settings.testimonial_image.id != '' ) { #>
                    <div class="power_testimonial_reviewer_image">
                        <img src="{{settings.testimonial_image.url}}" alt="{{settings.name_text}}">
                    </div>
                    <# } #>
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">{{{settings.name_text}}}</h4>
                        <h6 class="power_testimonial_reviewer_company">{{{settings.address_text}}}</h6>
                    </div>
                </div>
                <div class="power_testimonial_reviewer_content">
                    <p class="power_testimonial_reviewer_text">{{{settings.quote_text}}}</p>
                    <# if ( settings.testimonial_ratting != '' ) { #>
                    <ul class="power_testimonial_reviewer_rating">
                        <#
                        var integer = parseInt(settings.testimonial_ratting);
                        var decimal = settings.testimonial_ratting - integer;
                        var remain = 5 - integer;
                        var count = 0;
                        for ( var i = 1; i <= integer; i ++ ) {
                        #>
                        <li><i class="fa fa-star"></i></li>
                        <#
                        count += 1;
                        }
                        if ( decimal > 0 ) { #>
                        <li><i class="fa fa-star-half-o"></i></li>
                        <#
                        count += 1;
                        }
                        if ( remain > 0 ) {
                        integer = 5 - count;
                        if ( integer > 0 ) {
                        for ( var i = 1; i <= integer; i ++ ) { #>
                        <li><i class="fa fa-star-o"></i></li>
                        <#
                        }
                        }
                        }
                        #>
                    </ul>
                    <# } #>
                </div>
            </div>
            <# } else if(settings.testimonial_style == 'style_6'){ #>
            <div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_meta_inner">
                    <# if ( settings.testimonial_image.id != '' ) { #>
                    <div class="power_testimonial_reviewer_image">
                        <img src="{{settings.testimonial_image.url}}" alt="{{settings.name_text}}">
                    </div>
                    <# } #>
                    <div class="power_testimonial_reviewer_details">
                        <div class="power_testimonial_reviewer_content">
                            <h4 class="power_testimonial_reviewer_name">{{{settings.name_text}}}</h4>
                            <h6 class="power_testimonial_reviewer_company">{{{settings.address_text}}}</h6>
                            <p class="power_testimonial_reviewer_text">{{{settings.quote_text}}}</p>
                            <# if ( settings.testimonial_ratting != '' ) { #>
                            <ul class="power_testimonial_reviewer_rating">
                                <#
                                var integer = parseInt(settings.testimonial_ratting);
                                var decimal = settings.testimonial_ratting - integer;
                                var remain = 5 - integer;
                                var count = 0;
                                for ( var i = 1; i <= integer; i ++ ) {
                                #>
                                <li><i class="fa fa-star"></i></li>
                                <#
                                count += 1;
                                }
                                if ( decimal > 0 ) { #>
                                <li><i class="fa fa-star-half-o"></i></li>
                                <#
                                count += 1;
                                }
                                if ( remain > 0 ) {
                                integer = 5 - count;
                                if ( integer > 0 ) {
                                for ( var i = 1; i <= integer; i ++ ) { #>
                                <li><i class="fa fa-star-o"></i></li>
                                <#
                                }
                                }
                                }
                                #>
                            </ul>
                            <# } #>
                        </div>
                    </div>
                </div>
            </div>
            <# }else{#>
            <div class="power_testimonial_item">
                <# if ( settings.testimonial_image.id != '' ) { #>
                <div class="power_testimonial_reviewer_meta_inner">
                    <div class="power_testimonial_reviewer_image">
                        <img src="{{settings.testimonial_image.url}}" alt="{{settings.name_text}}">
                    </div>
                </div>
                <# } #>
                <div class="power_testimonial_reviewer_content">
                    <# if ( settings.testimonial_ratting != '' ) { #>
                    <ul class="power_testimonial_reviewer_rating">
                        <#
                        var integer = parseInt(settings.testimonial_ratting);
                        var decimal = settings.testimonial_ratting - integer;
                        var remain = 5 - integer;
                        var count = 0;
                        for ( var i = 1; i <= integer; i ++ ) {
                        #>
                        <li><i class="fa fa-star"></i></li>
                        <#
                        count += 1;
                        }
                        if ( decimal > 0 ) { #>
                        <li><i class="fa fa-star-half-o"></i></li>
                        <#
                        count += 1;
                        }
                        if ( remain > 0 ) {
                        integer = 5 - count;
                        if ( integer > 0 ) {
                        for ( var i = 1; i <= integer; i ++ ) { #>
                        <li><i class="fa fa-star-o"></i></li>
                        <#
                        }
                        }
                        }
                        #>
                    </ul>
                    <# } #>
                    <p class="power_testimonial_reviewer_text">{{{settings.quote_text}}}</p>
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">{{{settings.name_text}}}</h4>
                        <h6 class="power_testimonial_reviewer_company">{{{settings.address_text}}}</h6>
                    </div>
                </div>
            </div>
            <# } #>
			<?php
		}
	}