<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class Power_Elements_Service extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_service';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Service', 'power_elements_elementor' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-settings';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * ADD Widget CSS
		 */
		public function get_style_depends() {
			return [ 'power-element-service' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_posts_content',
				[
					'label' => __( 'Content', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_group_control(
				'powerpost',
				[
					'name' => 'powerpost',
				]
			);
			$this->add_control(
				'advanced',
				[
					'label' => __( 'Advanced', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'orderby',
				[
					'label' => __( 'Order By', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'post_date',
					'options' => [
						'post_date' => __( 'Date', 'power_elements_elementor' ),
						'post_title' => __( 'Title', 'power_elements_elementor' ),
						'menu_order' => __( 'Menu Order', 'power_elements_elementor' ),
						'rand' => __( 'Random', 'power_elements_elementor' ),
					]
				]
			);
			
			$this->add_control(
				'order',
				[
					'label' => __( 'Order', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'desc',
					'options' => [
						'asc' => __( 'ASC', 'power_elements_elementor' ),
						'desc' => __( 'DESC', 'power_elements_elementor' ),
					]
				]
			);
			
			$this->add_control(
				'offset',
				[
					'label' => __( 'Offset', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 0,
					'description' => __( 'Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'post__not_in',
				[
					'label' => __('Exclude', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'options' => Power_elements_Helper::power_get_all_types_post(),
					'label_block' => true,
					'post_type' => '',
					'multiple' => true,
					'condition' => [
						'eaeposts_post_type!' => 'by_id',
					],
				]
			);
			$this->add_control(
				'posts_per_page',
				[
					'label' => __('Posts Per Page', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => '4',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'post_layout_style',
				[
					'label'     => __( 'Layout', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'content_style',
				[
					'label'        => __( 'Select Style', 'power_elements_elementor' ),
					'type'         => \Elementor\Controls_Manager::SELECT,
					'default'      => 'style_1',
					'options'      => [
						'style_1'  => __( 'Style 1', 'power_elements_elementor' ),
						'style_2'  => __( 'Style 2', 'power_elements_elementor' ),
						'style_3'  => __( 'Style 3', 'power_elements_elementor' ),
						'style_4'  => __( 'Style 4', 'power_elements_elementor' ),
						'style_5'  => __( 'Style 5', 'power_elements_elementor' ),
					]
				]
			);
			/*$this->add_control(
				'power_post_grid_columns',
				[
					'label' => esc_html__('Number of Columns', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'elementor-col-25',
					'options' => [
						'elementor-col-100' => esc_html__('Single Column', 'power_elements_elementor'),
						'elementor-col-50' => esc_html__('Two Columns', 'power_elements_elementor'),
						'elementor-col-33' => esc_html__('Three Columns', 'power_elements_elementor'),
						'elementor-col-25' => esc_html__('Four Columns', 'power_elements_elementor'),
						'elementor-col-20' => esc_html__('Five Columns', 'power_elements_elementor'),
						'eael-col-16' => esc_html__('Six Columns', 'power_elements_elementor'),
					],
				]
			);
			*/
			$this->add_control(
				'power_show_read_more',
				[
					'label' => __('Show Read More', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __('Yes', 'power_elements_elementor'),
							'icon' => 'fa fa-check',
						],
						'0' => [
							'title' => __('No', 'power_elements_elementor'),
							'icon' => 'fa fa-ban',
						],
					],
					'default' => '1'
				]
			);
			
			$this->add_control(
				'power_read_more_text',
				[
					'label' => esc_html__('Label Text', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::TEXT,
					'label_block' => false,
					'default' => esc_html__('Read More', 'power_elements_elementor'),
					'condition' => [
						'power_show_read_more' => '1',
					],
				]
			);
			$this->add_control(
				'power_show_image',
				[
					'label' => __('Show Image', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __('Yes', 'power_elements_elementor'),
							'icon' => 'fa fa-check',
						],
						'0' => [
							'title' => __('No', 'power_elements_elementor'),
							'icon' => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Image_Size::get_type(),
				[
					'name' => 'image',
					'exclude' => ['custom'],
					'default' => 'medium',
					'condition' => [
						'power_show_image' => '1',
					],
				]
			);
			$this->add_control(
				'power_show_title',
				[
					'label' => __('Show Title', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __('Yes', 'power_elements_elementor'),
							'icon' => 'fa fa-check',
						],
						'0' => [
							'title' => __('No', 'power_elements_elementor'),
							'icon' => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			
			$this->add_control(
				'power_show_excerpt',
				[
					'label' => __('Show excerpt', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __('Yes', 'power_elements_elementor'),
							'icon' => 'fa fa-check',
						],
						'0' => [
							'title' => __('No', 'power_elements_elementor'),
							'icon' => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			
			$this->add_control(
				'power_excerpt_length',
				[
					'label' => __('Excerpt Words', 'power_elements_elementor'),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => '10',
					'condition' => [
						'power_show_excerpt' => '1',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * Blog Style
			 */
			$this->start_controls_section(
				'blog_style',
				[
					'label'     => __( 'Blog', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'blog_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'blog_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post',
				]
			);
			$this->add_control(
				'blog_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'blog_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'blog_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * Category Style
			 */
			$this->start_controls_section(
				'category_style',
				[
					'label'     => __( 'Category', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_category' => '1',
					],
				]
			);
			$this->add_control(
				'cat_label_options',
				[
					'label' => __( 'Label', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'cat_label_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
				]
			);
			$this->add_control(
				'cat_label_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'cat_label_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
				]
			);
			$this->add_control(
				'cat_label_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'cat_link_options',
				[
					'label' => __( 'Link', 'power_elements_elementor' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->start_controls_tabs(
				'cat_link_tabs'
			);
			
			$this->start_controls_tab(
				'cat_link_normal_tab',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'cat_link_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
				]
			);
			$this->add_control(
				'cat_link_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'cat_link_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
				]
			);
			$this->add_control(
				'cat_link_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'cat_link_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'cat_link_hover_tab',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'cat_link_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_cat a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * TITLE Style
			 */
			$this->start_controls_section(
				'title_style',
				[
					'label'     => __( 'Title', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_title' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'title_tabs'
			);
			
			$this->start_controls_tab(
				'title_normal_tab',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a',
				]
			);
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'title_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'title_hover_tab',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'title_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * IMAGE Style
			 */
			$this->start_controls_section(
				'image_style',
				[
					'label'     => __( 'Image', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_image' => '1',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'image_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_img img',
				]
			);
			$this->add_control(
				'image_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'image_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'image_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * CONTENT Style
			 */
			$this->start_controls_section(
				'content_inner',
				[
					'label'     => __( 'Content', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'content_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post_content' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'content_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post_content',
				]
			);
			$this->add_control(
				'content_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'content_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'content_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * META Style
			 */
			$this->start_controls_section(
				'meta_style',
				[
					'label'     => __( 'Meta', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_meta' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'meta_tabs'
			);
			
			$this->start_controls_tab(
				'meta_normal_tab',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'meta_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} {{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a',
				]
			);
			$this->add_control(
				'meta_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'date_typography',
					'label'    => __( 'Date Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} {{WRAPPER}} .power_blog_post .power_blog_post_header .power_blog_date,{{WRAPPER}} .power_blog_post .power_blog_post_header .power_blog_date a',
					'condition' => [
						'content_style' => 'style_2',
					],
				]
			);
			$this->add_control(
				'date_color',
				[
					'label'     => __( 'Date Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header .power_blog_date,{{WRAPPER}} .power_blog_post .power_blog_post_header .power_blog_date a' => 'color: {{VALUE}}',
					],
					'condition' => [
						'content_style' => 'style_2',
					],
				]
			);
			$this->add_control(
				'meta_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'content_style' => 'style_1',
					],
				]
			);
			$this->add_control(
				'meta_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'content_style' => 'style_1',
					],
				]
			);

			$this->add_control(
				'meta_margin2',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'content_style' => 'style_2',
					],
				]
			);
			$this->add_control(
				'meta_padding2',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'content_style' => 'style_2',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'meta_hover_tab',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'meta_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover a,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * EXCERPT Style
			 */
			$this->start_controls_section(
				'excerpt_style',
				[
					'label'     => __( 'Excerpt', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_excerpt' => '1',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'excerpt_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro',
				]
			);
			$this->add_control(
				'excerpt_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'excerpt_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro',
				]
			);
			$this->add_control(
				'excerpt_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'excerpt_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/*
			 * READ MORE Style
			 */
			$this->start_controls_section(
				'read_more_style',
				[
					'label'     => __( 'Read More', 'power_elements_elementor' ),
					'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [
						'power_show_read_more' => '1',
					],
				]
			);
			$this->start_controls_tabs(
				'read_more_tabs'
			);
			
			$this->start_controls_tab(
				'read_more_normal_tab',
				[
					'label' => __( 'Normal', 'plugin-name' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'read_more_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_control(
				'read_more_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'read_more_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button:after' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'read_more_align',
				[
					'label'        => __( 'Alignment', 'power_elements_elementor' ),
					'type'         => \Elementor\Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_button_group' => 'text-align: {{VALUE}};'
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'read_more_box_shadow',
					'label' => __( 'Box Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'read_more_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_blog_button',
				]
			);
			$this->add_control(
				'read_more_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'read_more_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_blog_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'read_more_hover_tab',
				[
					'label' => __( 'Hover', 'plugin-name' ),
				]
			);
			$this->add_control(
				'read_more_color_hover',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_blog_button:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'read_more_background',
					'label' => __( 'Background', 'power_elements_elementor' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .power_blog_button:before',
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();
			//$settings = $this->get_settings();
			
			/**
			 * Setup the post arguments.
			 */
			
			$post_args              = Power_elements_Helper::power_get_post_settings( $settings );
			$query_args             = Power_elements_Helper::power_get_query_args( 'powerpost', $settings );
			$query_args             = array_merge( $query_args, $post_args, $settings );
			
			if ( isset( $query_args['tax_query'] ) ) {
				$tax_query = $query_args['tax_query'];
			}
			/**
			 * Get posts from database.
			 */
			$posts = Power_elements_Helper::power_load_service( $query_args );
			/**
			 * Set total posts.
			 */
			//$total_post = $posts['count'];
			?>
            <div id="power-post-grid-<?php echo esc_attr( $this->get_id() ); ?>" class="blog_default power-post-grid-container">
                <div class="power-post-grid power-post-appender-<?php echo esc_attr( $this->get_id() ); ?>">
					<?php
						if ( ! empty( $posts['content'] ) ) {
							echo $posts['content'];
						} else {
							echo '<p class="text-danger">'.esc_html__('Something went wrong.','power_elements_elementor').'</p>';
						}
					?>
                </div>
                <div class="clearfix"></div>
            </div>
			<?php
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		//protected function _content_template() {}
	}