<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class Power_Elements_Icon_Box extends \Elementor\Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_element_icon_box';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Icon Box', 'power_elements_elementor' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-icon-box';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * ADD Widget CSS
		 */
		
		public function get_style_depends() {
			return [ 'power-element-icon-box' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'section_list',
				[
					'label' => __( 'Icon List', 'power_elements_elementor' ),
				]
			);
			$this->add_control(
				'icon_box_style',
				[
					'label'   => __( 'Type', 'power_elements_elementor' ),
					'type'    => \Elementor\Controls_Manager::SELECT,
					'default' => 'type_1',
					'options' => [
						'type_1' => __( 'Type 1', 'power_elements_elementor' ),
						'type_2' => __( 'Type 2', 'power_elements_elementor' ),
						'type_3' => __( 'Type 3', 'power_elements_elementor' ),
						'type_4' => __( 'Type 4', 'power_elements_elementor' ),
						'type_5' => __( 'Type 5', 'power_elements_elementor' )
					]
				]
			);
			$this->add_responsive_control(
				'align',
				[
					'label'     => __( 'Alignment', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::CHOOSE,
					'options'   => [
						'left'   => [
							'title' => __( 'Left', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'power_elements_elementor' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'default'   => 'center',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper' => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper' => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper' => 'text-align: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper' => 'text-align: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'box_feature_image',
				[
					'label'     => __( 'Feature Image', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition'   => [
						'icon_box_style' => [
							'type_2',
							'type_3',
							'type_4',
						],
					],
				]
			);
			$this->add_responsive_control(
				'icon_image',
				[
					'label'        => __( 'Icon or Image', 'power_elements_elementor' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => __( 'Icon', 'power_elements_elementor' ),
					'label_off'    => __( 'Image', 'power_elements_elementor' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			
			$this->add_responsive_control(
				'icon',
				[
					'label'       => __( 'Icon', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::ICON,
					'label_block' => true,
					'default'     => '',
					'condition'   => [
						'icon_image' => 'yes',
					],
				]
			);
			$this->add_responsive_control(
				'box_image',
				[
					'label'     => __( 'Choose Image', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition'   => [
						'icon_box_style' => [
							'type_1',
							'type_4',
							'type_5',
						],
					],
				]
			);
			$this->add_responsive_control(
				'box_image_second',
				[
					'label'     => __( 'Choose Second Image', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition'   => [
						'icon_box_style' => [
							'type_1',
							'type_5',
						],
					],
				]
			);
			$this->add_responsive_control(
				'box_image_third',
				[
					'label'     => __( 'Choose Third Image', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition'   => [
						'icon_box_style' => [
							'type_5',
						],
					],
				]
			);
			$this->add_responsive_control(
				'box_image_shadow',
				[
					'label'     => __( 'Choose Shadow Image', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition'   => [
						'icon_box_style' => [
							'type_3',
						],
					],
				]
			);
			$this->add_responsive_control(
				'box_number',
				[
					'label'       => __( 'Number', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( '01', 'power_elements_elementor' ),
					'placeholder' => __( 'Type your number here', 'power_elements_elementor' ),
					'condition'   => [
						'icon_box_style' => [
							'type_1',
							'type_3',
						],
					],
				]
			);
			$this->add_responsive_control(
				'box_title',
				[
					'label'       => __( 'Title', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => __( 'Default title', 'power_elements_elementor' ),
					'placeholder' => __( 'Type your title here', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'box_description',
				[
					'label'       => __( 'Description', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'rows'        => 10,
					'default'     => __( 'Default description', 'power_elements_elementor' ),
					'placeholder' => __( 'Type your description here', 'power_elements_elementor' ),
				]
			);

			$this->add_responsive_control(
				'ext_link',
				[
					'label'       => __( 'Link', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'power_elements_elementor' ),
					'default'     => [
						'url' => '#',
					],
					'condition'   => [
						'icon_box_style' => [
							'type_2',
							'type_3',
							'type_4',
						],
					],
				]
			);
			$this->add_responsive_control(
				'ext_link_icon',
				[
					'label'       => __( 'URL Icon', 'power_elements_elementor' ),
					'type'        => \Elementor\Controls_Manager::ICON,
					'label_block' => true,
					'default'     => '',
					'condition'   => [
						'icon_box_style' => [
							'type_2',
							'type_3',
						],
					],
				]
			);
			
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS
			 */
			$this->start_controls_section(
				'section_style',
				[
					'label' => __( 'Box', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_tabs'
			);
			
			$this->start_controls_tab(
				'icon_box_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'icon_box_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_2' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_3' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_4' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_5' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_box_shadow',
					'label' => __( 'Box Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1,{{WRAPPER}} .power_iconbox_2,{{WRAPPER}} .power_iconbox_3,{{WRAPPER}} .power_iconbox_4,{{WRAPPER}} .power_iconbox_5',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'icon_box_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1,{{WRAPPER}} .power_iconbox_2,{{WRAPPER}} .power_iconbox_3,{{WRAPPER}} .power_iconbox_4,{{WRAPPER}} .power_iconbox_5',
				]
			);
			$this->add_responsive_control(
				'icon_box_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'icon_box_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1:hover' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_2:hover' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_3:hover' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_4:hover' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_5:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_box_shadow_hover',
					'label' => __( 'Box Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1:hover,{{WRAPPER}} .power_iconbox_2:hover,{{WRAPPER}} .power_iconbox_3:hover,{{WRAPPER}} .power_iconbox_4:hover,{{WRAPPER}} .power_iconbox_5:hover',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'icon_box_border_hover',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1:hover,{{WRAPPER}} .power_iconbox_2:hover,{{WRAPPER}} .power_iconbox_3:hover,{{WRAPPER}} .power_iconbox_4:hover,{{WRAPPER}} .power_iconbox_5:hover',
				]
			);
			$this->add_responsive_control(
				'icon_box_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_padding_hover',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_margin_hover',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS WRAPPER
			 */
			$this->start_controls_section(
				'section_wrapper_style',
				[
					'label' => __( 'Wrapper', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_wrapper_tabs'
			);
			
			$this->start_controls_tab(
				'icon_box_wrapper_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_bg_color',
				[
					'label'     => __( 'Background Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper' => 'background-color: {{VALUE}}',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'icon_box_wrapper_border',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper',
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_wrapper_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'icon_box_wrapper_bg_color_hover',
					'label' => __( 'Background', 'power_elements_elementor' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name'     => 'icon_box_wrapper_border_hover',
					'label'    => __( 'Border', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper, {{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper',
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_padding_hover',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_box_wrapper_margin_hover',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			$this->start_controls_section(
				'section_gap_style',
				[
					'label' => __( 'Box Inner', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'gap_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'gap_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			
			/*
			 * STYLE OPTIONS ICON
			 */
			$this->start_controls_section(
				'section_icon_style',
				[
					'label' => __( 'Icon', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_icon_tabs'
			);
			$this->start_controls_tab(
				'icon_box_icon_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'icon_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_icon' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'icon_size',
				[
					'label'     => __( 'Size', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'default'   => [
						'size' => 24,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_icon_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'icon_hover_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_icon' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_icon' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS NUMBER
			 */
			$this->start_controls_section(
				'section_number_style',
				[
					'label' => __( 'Number', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_number_tabs'
			);
			$this->start_controls_tab(
				'icon_box_number_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'number_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'number_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
					'selector' =>'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h6, {{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h6, {{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h6, {{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h6, {{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h6',
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_number_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'number_hover_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper .power_iconbox_content h6' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS TITLE
			 */
			$this->start_controls_section(
				'section_title_style',
				[
					'label' => __( 'Title', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_title_tabs'
			);
			$this->start_controls_tab(
				'icon_box_title_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'title_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => __( 'Title Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_3,
					'selector' => '{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h3',
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'title_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h3,{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h3',
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_title_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'title_hover_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper .power_iconbox_content h3' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS DESCRIPTION
			 */
			$this->start_controls_section(
				'section_des_style',
				[
					'label' => __( 'Description', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'icon_box_des_tabs'
			);
			$this->start_controls_tab(
				'icon_box_des_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'des_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'des_typography',
					'label'    => __( 'Typography', 'power_elements_elementor' ),
					'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_3,
					'selector' => '{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content p',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'des_text_shadow',
					'label'    => __( 'Text Shadow', 'power_elements_elementor' ),
					'selector' => '{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content p, {{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content p',
				]
			);
			$this->add_responsive_control(
				'des_margin',
				[
					'label'      => __( 'Margin', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'des_padding',
				[
					'label'      => __( 'Padding', 'power_elements_elementor' ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_iconbox_1 .power_iconbox_wrapper .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_2 .power_iconbox_wrapper .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_3 .power_iconbox_wrapper .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_4 .power_iconbox_wrapper .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .power_iconbox_5 .power_iconbox_wrapper .power_iconbox_content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'icon_box_des_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'des_hover_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_1:hover .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_2:hover .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_3:hover .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_4:hover .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
						'{{WRAPPER}} .power_iconbox_5:hover .power_iconbox_wrapper .power_iconbox_content p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();



			/*
			 * STYLE OPTIONS DESCRIPTION
			 */
			$this->start_controls_section(
				'kempner_iconbox_section_button_style',
				[
					'label' => __( 'Button', 'power_elements_elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'kempner_iconbox_button_size',
				[
					'label'     => __( 'Size', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'default'   => [
						'size' => 50,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_wrapper .power_iconbox_icon a'   => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'kempner_iconbox_button_tabs'
			);
			$this->start_controls_tab(
				'kempner_iconbox_button_normal_tab',
				[
					'label' => __( 'Normal', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'kempner_iconbox_button_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_wrapper .power_iconbox_icon a' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'kempner_iconbox_button_bg_color',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient', 'classic'],
					'selector' => '{{WRAPPER}} .power_iconbox_wrapper .power_iconbox_icon a', 
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'kempner_iconbox_button_hover_tab',
				[
					'label' => __( 'Hover', 'power_elements_elementor' ),
				]
			);
			$this->add_responsive_control(
				'kempner_iconbox_button_hover_color',
				[
					'label'     => __( 'Color', 'power_elements_elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_iconbox_wrapper .power_iconbox_icon a:hover' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'kempner_iconbox_button_bg_hover_color',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient', 'classic'],
					'selector' => '{{WRAPPER}} .power_iconbox_wrapper .power_iconbox_icon a:hover', 
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();

			if ( ! empty( $settings['ext_link'] ) ) {
				$this->add_render_attribute( 'button', 'href', $settings['ext_link'] );
			}


			/*if ( $settings['icon_image'] == 'yes' ) {
			} else {
				$icon_image = '<img class="primary_img" src="' . esc_url( $settings['box_image']['url'] ) . '" alt="' . esc_attr( $settings['box_title'] ) . '">
                        <img class="secondary_img" src="' . esc_url( $settings['box_image_second']['url'] ) . '" alt="' . esc_attr( $settings['box_title'] ) . '">';
			}*/

			$icon_font = '<i class="' . esc_attr( $settings['icon'] ) . '"></i>';
			//$icon_image = '<img class="primary_img" src="' . esc_url( $settings['box_image']['url'] ) . '" alt="' . esc_attr( $settings['box_title'] ) . '">';
			//$icon_image2 = '<img class="secondary_img" src="' . esc_url( $settings['box_image_second']['url'] ) . '" alt="' . esc_attr( $settings['box_title'] ) . '">';
			$box_feature_image = '<img src="' . esc_url( $settings['box_feature_image']['url'] ) . '" alt="' . esc_attr( $settings['box_title'] ) . '">';
			
			if ($settings['icon_box_style']=='type_1') {
				echo '<div class="power_iconbox_1">
            		<div class="power_iconbox_wrapper">
            			<div class="power_iconbox_icon">
            				<img class="primary_img" src="' . esc_url( $settings['box_image']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
            				<img class="secondary_img" src="' . esc_url( $settings['box_image_second']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
            			</div>
                        <div class="power_iconbox_content">
                        	<h6>' . Power_elements_Helper::power_kses( $settings['box_number'] ) . '</h6>
                        	<h3>' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '</h3>
                        	<p>' .  $settings['box_description'] . '</p>
                        </div>
                    </div>
                </div>';
            } elseif ($settings['icon_box_style']=='type_2') {
            	echo '<div class="power_iconbox_2">
                    <div class="power_iconbox_wrapper">
                        <div class="power_iconbox_image">
                            ' . $box_feature_image . '
                        </div>
                        <div class="power_iconbox_content">
                            <h3>' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '</h3>
                        	<p>' .  $settings['box_description'] . '</p>
                            <div class="power_iconbox_icon">
                                <a ' . $this->get_render_attribute_string( 'button' ) . '><i class="' . $settings['ext_link_icon'] . '"></i></a>
                            </div>
                        </div>
                    </div>
                </div>';

            } elseif ($settings['icon_box_style']=='type_3') {
            	echo '<div class="power_iconbox_3">
	            	<div class="power_iconbox_wrapper">
		            	<div class="power_iconbox_image">
			            	' . $box_feature_image . '
			            	<div class="power_iconbox_icon">
				            	<a ' . $this->get_render_attribute_string( 'button' ) . '>
				            		<i class="' . $settings['ext_link_icon'] . '"></i>
				            		<h5>' . Power_elements_Helper::power_kses( $settings['box_number'] ) . '</h5>
				            	</a>
			            	</div>
			            </div>
			            <div class="power_iconbox_content">
			            	<img class="shadow_image" src="' . esc_url( $settings['box_image_shadow']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
			            	<h3>' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '</h3>
                        	<p>' . $settings['box_description'] . '</p>
		            	</div>
	            	</div>
            	</div>';
            } elseif ($settings['icon_box_style']=='type_4') {
            	echo '<div class="power_iconbox_4">
	            	<div class="power_iconbox_wrapper">
		            	<div class="power_iconbox_image">
		            		' . $box_feature_image . '
			            	<div class="power_iconbox_icon">
			            		<a ' . $this->get_render_attribute_string( 'button' ) . '><img class="primary_img" src="' . esc_url( $settings['box_image']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '"></a>
			            	</div>
		            	</div>
		            	<div class="power_iconbox_content">
		            		<h3>' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '</h3>
                        	<p>' . $settings['box_description'] . '</p>
		            	</div>
	            	</div>
            	</div>';
            } else {
				echo '<div class="power_iconbox_5">
					<div class="power_iconbox_wrapper">
						<div class="power_iconbox_icon">
							<img class="primary_img" src="' . esc_url( $settings['box_image']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
							<img class="secondary_img" src="' . esc_url( $settings['box_image_second']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
						</div>
						<div class="power_iconbox_content">
							<h3>' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '</h3>
                        	<p>' . $settings['box_description'] . '</p>
							<img class="shadow_img" src="' . esc_url( $settings['box_image_third']['url'] ) . '" alt="' . Power_elements_Helper::power_kses( $settings['box_title'] ) . '">
						</div>
					</div>
				</div>';
            }
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {
			?>
			<#
			var icon_image ='';
			if ( settings.icon_image=='yes' ) {
				icon_image ='<div class="power_iconbox_icon"><i class="'+ settings.icon +'"></i></div>';
			}else{
				icon_image ='<div class="power_iconbox_icon"><img class="primary_img" src=" '+ settings.box_image.url +' " alt="'+settings.box_title+'"/><img class="secondary_img" src=" '+ settings.box_image_second.url +' " alt="'+settings.box_title+'"/></div>';
			}
			#>
			<# if (settings.icon_box_style == 'type_1' ) { #>
				<div class="power_iconbox_1">
            		<div class="power_iconbox_wrapper">
            			<div class="power_iconbox_icon">
            				<img class="primary_img" src="{{settings.box_image.url}}" alt="{{{settings.box_title}}}">
            				<img class="secondary_img" src="{{settings.box_image_second.url}}" alt="{{{settings.box_title}}}">
            			</div>
            			<div class="power_iconbox_icon">
            				{{{icon_image}}}
            			</div>
                        <div class="power_iconbox_content">
                        	<h6>{{{settings.box_number}}}</h6>
                        	<h3>{{{settings.box_title}}}</h3>
                        	<p>{{{settings.box_description}}}</p>
                        </div>
                    </div>
                </div>
            <# } else if(settings.icon_box_style == 'type_2'){ #>
            	<div class="power_iconbox_2">
                    <div class="power_iconbox_wrapper">
                        <div class="power_iconbox_image">
                            <img src="{{settings.box_feature_image.url}}" alt="{{{settings.box_title}}}">
                        </div>
                        <div class="power_iconbox_content">
                            <h3>{{{settings.box_title}}}</h3>
                        	<p>{{{settings.box_description}}}</p>
                            <div class="power_iconbox_icon">
                            	<a href="{{settings.ext_link}}"><i class="{{settings.ext_link_icon}}"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            <# } else if(settings.icon_box_style == 'type_3'){ #>
            	<div class="power_iconbox_3">
	            	<div class="power_iconbox_wrapper">
		            	<div class="power_iconbox_image">
			            	<img src="{{settings.box_feature_image.url}}" alt="{{{settings.box_title}}}">
			            	<div class="power_iconbox_icon">
			            		<a href="{{settings.ext_link}}">
			            			<i class="{{settings.ext_link_icon}}"></i>
			            			<h5>{{{settings.box_number}}}</h5>
			            		</a>
			            	</div>
			            </div>
			            <div class="power_iconbox_content">
			            	<img class="shadow_image" src="{{settings.box_image_shadow.url}}" alt="' . esc_attr( $settings['box_title'] ) . '">
			            	<h3>{{{settings.box_title}}}</h3>
                        	<p>{{{settings.box_description}}}</p>
		            	</div>
	            	</div>
            	</div>
            <# } else if(settings.icon_box_style == 'type_4'){ #>
            	<div class="power_iconbox_4">
	            	<div class="power_iconbox_wrapper">
		            	<div class="power_iconbox_image">
		            		<img src="{{settings.box_feature_image.url}}" alt="{{{settings.box_title}}}">
			            	<div class="power_iconbox_icon">
			            		<a href="{{settings.ext_link}}">{{{icon_image}}}</a>
			            	</div>
		            	</div>
		            	<div class="power_iconbox_content">
		            		<h3>{{{settings.box_title}}}</h3>
                        	<p>{{{settings.box_description}}}</p>
		            	</div>
	            	</div>
            	</div>
            <# } else { #>
            	<div class="power_iconbox_5">
					<div class="power_iconbox_wrapper">
						<div class="power_iconbox_icon">
							<img class="primary_img" src="{{settings.box_image.url}}" alt="{{{settings.box_title}}}">
            				<img class="secondary_img" src="{{settings.box_image_second.url}}" alt="{{{settings.box_title}}}">
						</div>
						<div class="power_iconbox_content">
							<h3>{{{settings.box_title}}}</h3>
                        	<p>{{{settings.box_description}}}</p>
							<img class="shadow_img" src="{{settings.box_image_third.url}}" alt="{{{settings.box_title}}}">
						</div>
					</div>
				</div>
            <# } #>

			<?php
		}
		
	}