<?php if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );

/**
 * Creates widget with recent post thumbnail
 */

class Benzo_About_Author extends WP_Widget
{
    function __construct() {
        $widget_opt = array(
            'classname'     => 'benzo-about-author',
            'description'   => esc_html__('Benzo about author','benzo')
        );
        
        parent::__construct('benzo-about-author', esc_html__('Benzo about author', 'benzo'), $widget_opt);
    }
    
    function widget( $args, $instance ){
        
        echo benzo_return($args['before_widget']);
        if ( !empty( $instance[ 'title' ] ) ) {

            echo benzo_return($args[ 'before_title' ]) . apply_filters( 'widget_title', $instance[ 'title' ] ) . benzo_return($args[ 'after_title' ]);
        }



        if(isset($instance['author_image_url'])){
            $author_image_url = $instance['author_image_url'];
        }else{
            $author_image_url = '';
        }
        if(isset($instance['about_author'])){
            $about_author = $instance['about_author'];
            $about_author_arr = array('q' => $about_author);
            $query_string = http_build_query($about_author_arr);
        }else{
            $about_author = '';
            $query_string = '';
        }
        ?>
        <div class="sidebar_author">
            <?php if($author_image_url != ''): ?>
                <img src="<?php echo esc_url($author_image_url); ?>" alt="sidebar">
            <?php endif; ?>
            <?php if($about_author != ''): ?>
                <?php echo esc_html($about_author); ?>
            <?php endif; ?>
        </div>
        <?php
        echo benzo_return($args['after_widget']);
    }
    
    
    function update ( $old_instance , $new_instance) {
        $new_instance['title'] = strip_tags( $old_instance['title'] );
        $new_instance['about_author'] = $old_instance['about_author'];
        $new_instance['author_image_url'] = $old_instance['author_image_url'];

        return $new_instance;
    	
    }
    
    function form($instance){
    	if(isset($instance['title'])){
            $title = $instance['title'];
        }
        else{
            $title = esc_html__( 'About Author', 'benzo' );
        }
        if(isset($instance['author_image_url'])){
            $author_image_url = $instance['author_image_url'];
        }else{
            $author_image_url = '';
        }
        if(isset($instance['about_author'])){
            $about_author = $instance['about_author'];
        }else{
            $about_author = '';
        }
        


        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'benzo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'author_image_url' )); ?>"><?php esc_html_e( 'Author Image URL:' , 'benzo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'author_image_url' )); ?>"
                   name="<?php echo esc_attr($this->get_field_name( 'author_image_url' )); ?>" type="text"
                   value="<?php echo esc_attr( $author_image_url ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'about_author' )); ?>"><?php esc_html_e( 'Address:' , 'benzo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'about_author' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'about_author' )); ?>" type="text" 
                       value="<?php echo esc_attr( $about_author ); ?>" />
        </p>
    <?php
    }
}
 