<?php
/**
 * Plugin Name: Benzo Assistant
 * Plugin URI:http://wpthemebooster.com
 * Description: Benzo Assistant is a plugin to assist our Benzo Theme.
 * Author: wpthemebooster
 * Author URI: http://wpthemebooster.com
 * Version:1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define("BENZO_PLUGIN_DIR", plugin_dir_path(__FILE__ ));

class Benzo_Main{

	public static $_instance;
	public $plugin_name = 'Benzo Assistant';
	public $plugin_version = '1.0.0';
	public $file = __FILE__;

	public function __construct(){
		$this->benzo_plugin_init();
	}
	public function benzo_plugin_init(){
          add_action( 'widgets_init', array( __CLASS__, 'benzo_widgets_init' ) );
          add_action( 'admin_enqueue_scripts', [$this, 'admin_enqueue_scripts']);
     }    
     public function admin_enqueue_scripts(){
          wp_enqueue_script( 
              'widgets-script', 
              plugin_dir_url(__FILE__) . 'assets/js/scripts.js', 
              array('jquery'), 
              '1.0',
              true
          );
      }
     public static function get_social_share() { ?>
          <span>Share:</span>
          <ul class="share_list">
               <li><a href="https://www.facebook.com/share.php?u=<?php the_permalink();?>"><i class="fa fa-facebook"></i></a></li>
               <li><a href="http://twitter.com/intent/tweet?status=<?php the_title() ?>+<?php the_permalink();?>"><i class="fa fa-twitter"></i></a></li>
               <li><a href="http://www.tumblr.com/share/link?url=<?php echo the_permalink(); ?>"><i class="fa fa-tumblr"></i></a></li>
               <li><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo the_permalink(); ?>&title=<?php the_title(); ?>&source=<?php echo home_url('/');?>"><i class="fa fa-linkedin"></i></a></li>
               <li><a href="https://pinterest.com/pin/create/button/?url=<?php echo the_permalink(); ?>&media=&description="><i class="fa fa-pinterest"></i></a></li>
          </ul>
     <?php }
	public static function benzo_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Benzo_Main();
        }
        return self::$_instance;
    }
     public static function benzo_widgets_init() {
          include plugin_dir_path( __FILE__ ).'widgets/recent-post.php';
          register_widget( 'Benzo_Recent_Post' );
          include plugin_dir_path( __FILE__ ).'widgets/about-author.php';
          register_widget( 'Benzo_About_Author' );
     }
}
$Benzo_Main = Benzo_Main::benzo_get_instance();